/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.ontologyConfigReader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.tools.ontologyCfgReader.mapping.jaxb.CvSourceList;
import psidev.psi.tools.ontologyConfigReader.OntologyConfigReaderException;

public class OntologyConfigReader {
    public static final Log log = LogFactory.getLog(OntologyConfigReader.class);

    private Unmarshaller getUnmarshaller() throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"psidev.psi.tools.ontologyCfgReader.mapping.jaxb");
        return jc.createUnmarshaller();
    }

    private CvSourceList unmarshall(URL url) throws JAXBException, FileNotFoundException {
        if (url == null) {
            throw new IllegalArgumentException("You must give a non null URL.");
        }
        Unmarshaller u = this.getUnmarshaller();
        return (CvSourceList)u.unmarshal(url);
    }

    private CvSourceList unmarshall(File file) throws JAXBException, FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null file.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("You must give an existing file.");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("You must give a readable file.");
        }
        Unmarshaller u = this.getUnmarshaller();
        return (CvSourceList)u.unmarshal((InputStream)new FileInputStream(file));
    }

    private CvSourceList unmarshall(InputStream is) throws JAXBException {
        if (is == null) {
            throw new IllegalArgumentException("You must give a non null input stream.");
        }
        Unmarshaller u = this.getUnmarshaller();
        return (CvSourceList)u.unmarshal(is);
    }

    private CvSourceList unmarshall(String s) throws JAXBException {
        if (s == null) {
            throw new IllegalArgumentException("You must give a non null String.");
        }
        Unmarshaller u = this.getUnmarshaller();
        return (CvSourceList)u.unmarshal((Reader)new StringReader(s));
    }

    public CvSourceList read(String s) throws OntologyConfigReaderException {
        try {
            return this.unmarshall(s);
        }
        catch (JAXBException e) {
            throw new OntologyConfigReaderException(e);
        }
    }

    public CvSourceList read(File file) throws OntologyConfigReaderException {
        try {
            return this.unmarshall(file);
        }
        catch (JAXBException e) {
            throw new OntologyConfigReaderException(e);
        }
        catch (FileNotFoundException e) {
            throw new OntologyConfigReaderException(e);
        }
    }

    public CvSourceList read(InputStream is) throws OntologyConfigReaderException {
        try {
            return this.unmarshall(is);
        }
        catch (JAXBException e) {
            throw new OntologyConfigReaderException(e);
        }
    }

    public CvSourceList read(URL url) throws OntologyConfigReaderException {
        try {
            return this.unmarshall(url);
        }
        catch (JAXBException e) {
            throw new OntologyConfigReaderException(e);
        }
        catch (FileNotFoundException e) {
            throw new OntologyConfigReaderException(e);
        }
    }
}

