/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.dataadapter;

import java.io.IOException;
import java.util.Comparator;
import org.geneontology.oboedit.dataadapter.OBO_1_2_Serializer;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.NestedValue;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymCategory;

public class OBO_1_0_Serializer
extends OBO_1_2_Serializer {
    protected Comparator synonymComparator = new Comparator(){

        public int compare(Object a, Object b) {
            Synonym sa = (Synonym)a;
            Synonym sb = (Synonym)b;
            int compVal = sa.getScope() - sb.getScope();
            if (compVal == 0) {
                return Synonym.COMPARATOR.compare(a, b);
            }
            return compVal;
        }
    };

    public Comparator getSynonymComparator() {
        return this.synonymComparator;
    }

    public void writeFormatVersionHeaderTag() throws IOException {
        this.println("format-version: 1.0");
    }

    public void writeDataVersionHeaderTag(String dataVersion) throws IOException {
        this.println("version: " + dataVersion);
    }

    public void writeSynonymTypeDefHeaderTag(SynonymCategory category) throws IOException {
        this.print("!synonymtypedef: " + OBO_1_0_Serializer.escapeBeforeQuotes(category.getID()) + " \"" + OBO_1_0_Serializer.escapeQuoted(category.getName()) + "\"");
        if (category.getScope() != -1) {
            this.print(" " + OBO_1_0_Serializer.getScopeStr(category.getScope()));
        }
        this.print(" ! synonymtypedef not supported by OBO 1.0");
        this.println();
    }

    public void writeSynonymTag(Synonym syn, NestedValue nv) throws IOException {
        if (syn.getScope() == 1) {
            this.print("exact_synonym: ");
        } else if (syn.getScope() == 2) {
            this.print("narrow_synonym: ");
        } else if (syn.getScope() == 3) {
            this.print("broad_synonym: ");
        } else {
            this.print("related_synonym: ");
        }
        this.print("\"" + OBO_1_0_Serializer.escapeQuoted(syn.getText()) + "\"");
        this.writeDbxrefList(syn.getDbxrefs());
        this.writeNestedValue(nv);
        if (syn.getSynonymCategory() != null) {
            this.print(" ! belonged to category " + syn.getSynonymCategory().getID());
        }
        this.println();
    }

    public void writeXrefTag(Dbxref ref) throws IOException {
        this.print("xref_analog: ");
        this.writeDbxref(ref);
        this.println();
    }

    public String getID() {
        return "OBO 1.0";
    }
}

