/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.DefaultHistoryList;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.util.ObjectUtil;

public abstract class HistoryItem
implements Serializable {
    public static final int STRUCTURAL_MERGE = 1;
    public static final int STRUCTURAL_SPLIT = 2;
    public static final int STRUCTURAL_COPY = 3;
    public static final int STRUCTURAL_DELETE = 4;
    public static final int STRUCTURAL_MOVE = 5;
    public static final int STRUCTURAL_ADD = 6;
    public static final int STRUCTURAL_IMPORT = 16;
    public static final int STRUCTURAL_CATEGORY = 17;
    public static final int STRUCTURAL_USE_TERM = 18;
    public static final int STRUCTURAL_NAMESPACE = 19;
    public static final int STRUCTURAL_COMMITANDOBSOLETE = 7;
    public static final int MACRO = 8;
    public static final int STRUCTURAL_REBUILD = 9;
    public static final int TEXT_EDIT = 10;
    public static final int TEXT_TEXT = 11;
    public static final int TEXT_DBXREF = 12;
    public static final int TEXT_RELATED_SYNONYM = 13;
    public static final int TEXT_CATEGORY = 14;
    public static final int REL_CHANGE = 15;
    public static final int SECONDARY_ID = 16;
    public static final int REL_CHANGE_NECESSARY = 17;
    public static final int REL_CHANGE_INV_NECESSARY = 18;
    public static final int COMPLETE = 0;
    public static final int TERM_INPLACE = 1;
    public static final int REL_INPLACE = 2;
    public static final int ADD = 3;
    public static final int DEL = 4;
    public static final int RELOAD_BRANCH = 5;
    public static final int RELOAD_PARENT = 6;
    protected List defaultGraphlist = Collections.singletonList(new GraphOperation(0));
    protected int type = -1;
    protected String target;
    protected HashSet edited = new HashSet();
    protected boolean isUndoable = true;
    protected TreePath[] preselection;
    protected TreePath[] postselection;

    public static StringRelationship createStringRelationship(Link link) {
        if (link instanceof OBORestriction) {
            return new StringRelationship((OBORestriction)link);
        }
        return new StringRelationship(link.getParent(), link.getChild(), link.getType(), false, false, false, null, null, null, link.getNamespace().getID());
    }

    public static int getHash(boolean b) {
        if (b) {
            return Boolean.TRUE.hashCode();
        }
        return Boolean.FALSE.hashCode();
    }

    public static int getHash(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setPreSelection(TreePath[] preselection) {
        this.preselection = preselection;
    }

    public void setPostSelection(TreePath[] postselection) {
        this.postselection = postselection;
    }

    protected static Vector convertVector(Vector terms) {
        Vector<StringRelationship> out = new Vector<StringRelationship>();
        for (int i = 0; i < terms.size(); ++i) {
            if (terms.get(i) instanceof OBORestriction) {
                out.add(new StringRelationship((OBORestriction)terms.get(i)));
                continue;
            }
            out.add((StringRelationship)terms.get(i));
        }
        return out;
    }

    public TreePath[] getPreSelection() {
        return this.preselection;
    }

    public TreePath[] getPostSelection() {
        return this.postselection;
    }

    public String getTarget() {
        return this.target;
    }

    public int getType() {
        return this.type;
    }

    public List getGraphEditList() {
        return this.defaultGraphlist;
    }

    public boolean isUndoable() {
        return this.isUndoable;
    }

    public abstract String getShortName();

    public Set getEditedNodes() {
        return (Set)this.edited.clone();
    }

    public static HistoryList defaultForwardID(HistoryItem item, String oldID, Collection newIDs) {
        if (item.getTarget().equals(oldID)) {
            DefaultHistoryList out = new DefaultHistoryList();
            Iterator it = newIDs.iterator();
            while (it.hasNext()) {
                String id = it.next().toString();
                try {
                    HistoryItem newitem = (HistoryItem)item.clone();
                    newitem.setTarget(id);
                    out.addItem(newitem);
                }
                catch (CloneNotSupportedException e) {}
            }
            return out;
        }
        return null;
    }

    public abstract HistoryList forwardID(String var1, Collection var2);

    public static class StringRelationship
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        protected String parent;
        protected String child;
        protected String type;
        protected boolean completes;
        protected boolean necessary = true;
        protected boolean inverse_necessary;
        protected Integer cardinality;
        protected Integer minCardinality;
        protected Integer maxCardinality;
        protected String ns;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                return null;
            }
        }

        public String getNamespace() {
            return this.ns;
        }

        public void setCompletes(boolean completes) {
            this.completes = completes;
        }

        public boolean completes() {
            return this.completes;
        }

        public boolean isNecessary() {
            return this.necessary;
        }

        public boolean isInverseNecessary() {
            return this.inverse_necessary;
        }

        public Integer getCardinality() {
            return this.cardinality;
        }

        public Integer getMinCardinality() {
            return this.minCardinality;
        }

        public Integer getMaxCardinality() {
            return this.maxCardinality;
        }

        public StringRelationship() {
        }

        public StringRelationship(OBORestriction rel) {
            this(rel.getParent(), rel.getChild(), rel.getType(), rel.completes(), rel.isNecessarilyTrue(), rel.isInverseNecessarilyTrue(), rel.getCardinality(), rel.getMinCardinality(), rel.getMaxCardinality(), rel.getNamespace() == null ? null : rel.getNamespace().getID());
        }

        public StringRelationship(Link rel) {
            this(rel.getParent(), rel.getChild(), rel.getType(), false, false, false, null, null, null, rel.getNamespace() == null ? null : rel.getNamespace().getID());
        }

        public StringRelationship(LinkedObject parentTerm, LinkedObject childTerm, OBOProperty typeTerm) {
            this(parentTerm, childTerm, typeTerm, false, true, false, null, null, null, null);
        }

        public StringRelationship(LinkedObject parentTerm, LinkedObject childTerm, OBOProperty typeTerm, boolean completes, boolean necessary, boolean inverse_necessary, Integer cardinality, Integer minCardinality, Integer maxCardinality, String ns) {
            this(parentTerm == null ? null : parentTerm.getID(), childTerm == null ? null : childTerm.getID(), typeTerm == null ? null : typeTerm.getID(), completes, necessary, inverse_necessary, cardinality, minCardinality, maxCardinality, ns);
        }

        public StringRelationship(String parent, String child, String type) {
            this(parent, child, type, false, true, false, null, null, null, null);
        }

        public StringRelationship(String parent, String child, String type, boolean completes, boolean necessary, boolean inverse_necessary, Integer cardinality, Integer minCardinality, Integer maxCardinality, String ns) {
            this.parent = parent;
            this.child = child;
            this.type = type;
            this.completes = completes;
            this.necessary = necessary;
            this.inverse_necessary = inverse_necessary;
            this.cardinality = cardinality;
            this.minCardinality = minCardinality;
            this.maxCardinality = maxCardinality;
            this.ns = ns;
        }

        public boolean equals(Object o) {
            StringRelationship sr = (StringRelationship)o;
            return ObjectUtil.equals((Object)this.parent, (Object)sr.getParent()) && ObjectUtil.equals((Object)this.child, (Object)sr.getChild()) && ObjectUtil.equals((Object)this.type, (Object)sr.getType());
        }

        public int hashCode() {
            return (this.parent == null ? 0 : this.parent.hashCode()) ^ (this.child == null ? 0 : this.child.hashCode()) ^ (this.type == null ? 0 : this.type.hashCode());
        }

        public void setParent(String parent) {
            this.parent = parent;
        }

        public void setChild(String child) {
            this.child = child;
        }

        public void setType(String type) {
            this.type = type;
        }

        public StringRelationship(String parent) {
            this(null, parent, null, false, false, false, null, null, null, null);
        }

        public String getParent() {
            return this.parent;
        }

        public String getChild() {
            return this.child;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.child + " --" + this.type + "--> " + this.parent;
        }

        public boolean canForward(String oldID) {
            boolean forwarded = false;
            if (this.parent != null && this.parent.equals(oldID)) {
                forwarded = true;
            }
            if (this.child != null && this.child.equals(oldID)) {
                forwarded = true;
            }
            if (this.type != null && this.type.equals(oldID)) {
                forwarded = true;
            }
            return forwarded;
        }

        public boolean forwardID(String oldID, String newID) {
            boolean forwarded = false;
            if (this.parent != null && this.parent.equals(oldID)) {
                this.setParent(newID);
                forwarded = true;
            }
            if (this.child != null && this.child.equals(oldID)) {
                this.setChild(newID);
                forwarded = true;
            }
            if (this.type != null && this.type.equals(oldID)) {
                forwarded = true;
                this.setType(newID);
            }
            return forwarded;
        }
    }

    public static class GraphOperation
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        protected String id;
        protected StringRelationship rel;
        protected int type;

        public GraphOperation(int type) {
            this(type, null, null);
        }

        public GraphOperation(int type, String id) {
            this.type = type;
            this.id = id;
        }

        public GraphOperation(int type, StringRelationship rel) {
            this.type = type;
            this.rel = rel;
        }

        public GraphOperation(int type, String id, StringRelationship rel) {
            this.type = type;
            this.id = id;
            this.rel = rel;
        }

        public String toString() {
            return "type=" + this.type + ", id=" + this.id + ", rel=" + this.rel;
        }

        public static int invertType(int type) {
            if (type == 3) {
                return 4;
            }
            if (type == 4) {
                return 3;
            }
            return type;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception ex) {
                return null;
            }
        }

        public static Set invert(Set invertme) {
            HashSet<GraphOperation> out = new HashSet<GraphOperation>();
            Iterator it = invertme.iterator();
            while (it.hasNext()) {
                GraphOperation op = (GraphOperation)it.next();
                if (op.getType() == 3) {
                    op = (GraphOperation)op.clone();
                    op.type = 4;
                } else if (op.getType() == 4) {
                    op = (GraphOperation)op.clone();
                    op.type = 3;
                }
                out.add(op);
            }
            return out;
        }

        public boolean newSelectionNeeded() {
            return this.type != 2 && this.type != 1;
        }

        public boolean cachePathsNeeded() {
            return this.type == 0;
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.id;
        }

        public StringRelationship getRel() {
            return this.rel;
        }
    }
}

