/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.history;

import java.util.Collection;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymedObject;

public class ChangeSynScopeHistoryItem
extends HistoryItem {
    private static final long serialVersionUID = -869201134791523102L;
    protected String synonym;
    protected int oldScope;
    protected int newScope;

    public ChangeSynScopeHistoryItem() {
    }

    public ChangeSynScopeHistoryItem(SynonymedObject target, Synonym synonym, int newScope) {
        this(target.getID(), synonym.getText(), synonym.getScope(), newScope);
    }

    public ChangeSynScopeHistoryItem(String target, String synonym, int oldScope, int newScope) {
        this.target = target;
        this.synonym = synonym;
        this.oldScope = oldScope;
        this.newScope = newScope;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChangeSynScopeHistoryItem)) {
            return false;
        }
        ChangeSynScopeHistoryItem item = (ChangeSynScopeHistoryItem)o;
        return item.getTarget().equals(this.target) && item.getSynonym().equals(this.synonym) && item.getOldScope() == this.oldScope && item.getNewScope() == this.newScope;
    }

    public String toString() {
        return "Changed synonym scope of " + this.target + " from \"" + this.getScopeString(this.oldScope) + "\" to \"" + this.getScopeString(this.newScope) + "\"";
    }

    protected String getScopeString(int scope) {
        if (scope == -1) {
            return "Unknown";
        }
        if (scope == 0) {
            return "Related";
        }
        if (scope == 1) {
            return "Exact";
        }
        if (scope == 2) {
            return "Narrow";
        }
        if (scope == 3) {
            return "Broad";
        }
        return "!!ILLEGAL!!";
    }

    public String getSynonym() {
        return this.synonym;
    }

    public void setSynonym(String synonym) {
        this.synonym = synonym;
    }

    public void setNewScope(int newScope) {
        this.newScope = newScope;
    }

    public int getNewScope() {
        return this.newScope;
    }

    public void setOldScope(int oldScope) {
        this.oldScope = oldScope;
    }

    public int getOldScope() {
        return this.oldScope;
    }

    public String getShortName() {
        return "CHANGE_RELATED_SYNONYM_SCOPE";
    }

    public HistoryList forwardID(String oldID, Collection newIDs) {
        return ChangeSynScopeHistoryItem.defaultForwardID(this, oldID, newIDs);
    }
}

