/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.history;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.util.ObjectUtil;

public class CyclicHistoryItem
extends HistoryItem {
    private static final long serialVersionUID = -7013371178175196469L;
    protected boolean oldCyclic;

    public CyclicHistoryItem(OBOProperty target) {
        this(target.getID(), target.isCyclic());
    }

    public CyclicHistoryItem() {
        this(null, false);
    }

    public CyclicHistoryItem(String target, boolean oldCyclic) {
        this.target = target;
        this.oldCyclic = oldCyclic;
    }

    public List getGraphEditList() {
        return Collections.singletonList(new HistoryItem.GraphOperation(2, this.target));
    }

    public int hashCode() {
        return CyclicHistoryItem.getHash(this.target) ^ CyclicHistoryItem.getHash(this.oldCyclic);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CyclicHistoryItem)) {
            return false;
        }
        CyclicHistoryItem item = (CyclicHistoryItem)o;
        return ObjectUtil.equals((Object)this.target, (Object)item.getTarget()) && this.oldCyclic == item.getOldCyclic();
    }

    public void setOldCyclic(boolean oldCyclic) {
        this.oldCyclic = oldCyclic;
    }

    public boolean getOldCyclic() {
        return this.oldCyclic;
    }

    public String getShortName() {
        return "changed is cyclic";
    }

    public String toString() {
        return "changed \"is cyclic\" status of " + this.target + " to " + !this.oldCyclic;
    }

    public HistoryList forwardID(String oldID, Collection newIDs) {
        return null;
    }
}

