/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.geneontology.oboedit.datamodel.AnnotatedObject;
import org.geneontology.oboedit.datamodel.CategorizedObject;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.NestedValue;
import org.geneontology.oboedit.datamodel.ObsoletableObject;
import org.geneontology.oboedit.datamodel.PropertyValue;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.TermCategory;
import org.geneontology.util.TinySet;

public abstract class AnnotatedObjectImpl
implements AnnotatedObject,
CategorizedObject {
    protected static int internal_id_gen = 0;
    public int internal_id = internal_id_gen++;
    protected String id;
    protected boolean anonymous = false;
    protected boolean isObsolete = false;
    protected Set considerReplacements = new TinySet();
    protected Set replacements = new TinySet();
    protected Set categories = new TinySet();
    protected Set synonyms = new TinySet();
    protected Set dbxrefs = new TinySet();
    protected Set secondaryIDs = new TinySet();
    protected Set defReferences = new TinySet();
    protected Set propertyValues = new TinySet();
    protected HashMap categoryExtensionHash = new HashMap();
    protected NestedValue definitionExtension;
    protected String definition = "";
    protected Namespace namespace;
    protected String name;
    protected String comment = "";
    protected NestedValue idExtension;
    protected NestedValue nameExtension;
    protected NestedValue namespaceExtension;
    protected NestedValue commentExtension;
    protected NestedValue obsoleteExtension;
    protected NestedValue anonymousExtension;
    protected NestedValue typeExtension;
    protected HashMap secondaryIDExtensionMap;
    protected HashMap considerExtensionMap;
    protected HashMap replacedByExtensionMap;

    public String getID() {
        return this.id;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setIsAnonymous(boolean isAnonymous) {
        this.anonymous = isAnonymous;
    }

    public boolean isBuiltIn() {
        return false;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public void setObsolete(boolean isObsolete) {
        this.isObsolete = isObsolete;
    }

    public Set getReplacedBy() {
        return this.replacements;
    }

    public void addReplacedBy(ObsoletableObject replacedBy) {
        this.replacements.add(replacedBy);
    }

    public void removeReplacedBy(ObsoletableObject replacedBy) {
        this.replacements.remove(replacedBy);
    }

    public Set getConsiderReplacements() {
        return this.considerReplacements;
    }

    public void addConsiderReplacement(ObsoletableObject o) {
        this.considerReplacements.add(o);
    }

    public void removeConsiderReplacement(ObsoletableObject o) {
        this.considerReplacements.remove(o);
    }

    public Set getSynonyms() {
        return this.synonyms;
    }

    public void addSynonym(Synonym s) {
        this.synonyms.add(s);
    }

    public void removeSynonym(Synonym s) {
        this.synonyms.remove(s);
    }

    public Set getDbxrefs() {
        return this.dbxrefs;
    }

    public void addDbxref(Dbxref xref) {
        this.dbxrefs.add(xref);
    }

    public void removeDbxref(Dbxref xref) {
        Iterator it = this.dbxrefs.iterator();
        while (it.hasNext()) {
            Dbxref ref = (Dbxref)it.next();
            if (!ref.equals(xref)) continue;
            System.err.println("removing matching dbxref " + ref);
            it.remove();
            break;
        }
    }

    public void addSecondaryID(String secondaryID) {
        this.secondaryIDs.add(secondaryID);
    }

    public void removeSecondaryID(String secondaryID) {
        this.secondaryIDs.remove(secondaryID);
    }

    public Set getSecondaryIDs() {
        return this.secondaryIDs;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setIDExtension(NestedValue nv) {
        this.idExtension = nv;
    }

    public void setNameExtension(NestedValue nv) {
        this.nameExtension = nv;
    }

    public void setCommentExtension(NestedValue nv) {
        this.commentExtension = nv;
    }

    public void setObsoleteExtension(NestedValue nv) {
        this.obsoleteExtension = nv;
    }

    public void setAnonymousExtension(NestedValue nv) {
        this.anonymousExtension = nv;
    }

    public void setNamespaceExtension(NestedValue nv) {
        this.namespaceExtension = nv;
    }

    public void setTypeExtension(NestedValue nv) {
        this.typeExtension = nv;
    }

    public void addReplacedByExtension(ObsoletableObject oo, NestedValue nv) {
        if (this.replacedByExtensionMap == null) {
            this.replacedByExtensionMap = new HashMap();
        }
        this.replacedByExtensionMap.put(oo, nv);
    }

    public NestedValue getReplacedByExtension(ObsoletableObject oo) {
        if (this.replacedByExtensionMap == null) {
            return null;
        }
        return (NestedValue)this.replacedByExtensionMap.get(oo);
    }

    public void addSecondaryIDExtension(String id, NestedValue nv) {
        if (this.secondaryIDExtensionMap == null) {
            this.secondaryIDExtensionMap = new HashMap();
        }
        this.secondaryIDExtensionMap.put(id, nv);
    }

    public NestedValue getSecondaryIDExtension(String id) {
        if (this.secondaryIDExtensionMap == null) {
            return null;
        }
        return (NestedValue)this.secondaryIDExtensionMap.get(id);
    }

    public void addConsiderExtension(ObsoletableObject o, NestedValue nv) {
        if (this.considerExtensionMap == null) {
            this.considerExtensionMap = new HashMap();
        }
        this.considerExtensionMap.put(o, nv);
    }

    public NestedValue getConsiderExtension(ObsoletableObject o) {
        if (this.considerExtensionMap == null) {
            return null;
        }
        return (NestedValue)this.considerExtensionMap.get(o);
    }

    public NestedValue getIDExtension() {
        return this.idExtension;
    }

    public NestedValue getNameExtension() {
        return this.nameExtension;
    }

    public NestedValue getCommentExtension() {
        return this.commentExtension;
    }

    public NestedValue getObsoleteExtension() {
        return this.obsoleteExtension;
    }

    public NestedValue getAnonymousExtension() {
        return this.anonymousExtension;
    }

    public NestedValue getNamespaceExtension() {
        return this.namespaceExtension;
    }

    public NestedValue getTypeExtension() {
        return this.typeExtension;
    }

    public void addPropertyValue(PropertyValue pv) {
        if (this.propertyValues == null) {
            this.propertyValues = new TinySet();
        }
        this.propertyValues.add(pv);
    }

    public Set getDefDbxrefs() {
        return this.defReferences;
    }

    public void addDefDbxref(Dbxref ref) {
        if (ref.getType() != 2) {
            new Exception("adding non-definition dbxref " + ref + " as dbxref.").printStackTrace();
        }
        this.defReferences.add(ref);
    }

    public void removeDefDbxref(Dbxref ref) {
        this.defReferences.remove(ref);
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public void addCategoryExtension(TermCategory category, NestedValue nv) {
        if (this.categoryExtensionHash == null) {
            this.categoryExtensionHash = new HashMap();
        }
        this.categoryExtensionHash.put(category, nv);
    }

    public NestedValue getCategoryExtension(TermCategory category) {
        if (this.categoryExtensionHash == null) {
            return null;
        }
        return (NestedValue)this.categoryExtensionHash.get(category);
    }

    public void setDefinitionExtension(NestedValue definitionExtension) {
        this.definitionExtension = definitionExtension;
    }

    public NestedValue getDefinitionExtension() {
        return this.definitionExtension;
    }

    public Set getPropertyValues() {
        return this.propertyValues;
    }

    public void removePropertyValue(PropertyValue pv) {
        if (this.propertyValues != null) {
            this.propertyValues.remove(pv);
        }
    }

    public void addCategory(TermCategory category) {
        this.categories.add(category);
    }

    public void removeCategory(TermCategory category) {
        this.categories.remove(category);
    }

    public Set getCategories() {
        return this.categories;
    }

    public String toString() {
        return this.getName() + " (" + this.getID() + ")";
    }

    public boolean equals(Object o) {
        if (o instanceof AnnotatedObject) {
            AnnotatedObject io = (AnnotatedObject)o;
            return io.getID().equals(this.getID());
        }
        return false;
    }

    public Object clone() {
        try {
            AnnotatedObjectImpl out = (AnnotatedObjectImpl)super.clone();
            out.internal_id = internal_id_gen++;
            out.synonyms = new TinySet();
            Iterator it = this.synonyms.iterator();
            while (it.hasNext()) {
                Synonym s = (Synonym)it.next();
                out.addSynonym((Synonym)s.clone());
            }
            out.dbxrefs = new TinySet();
            it = this.getDbxrefs().iterator();
            while (it.hasNext()) {
                Dbxref d = (Dbxref)it.next();
                out.addDbxref((Dbxref)d.clone());
            }
            out.categories = new TinySet();
            it = this.categories.iterator();
            while (it.hasNext()) {
                out.addCategory((TermCategory)it.next());
            }
            out.secondaryIDs = new TinySet();
            it = this.secondaryIDs.iterator();
            while (it.hasNext()) {
                out.addSecondaryID((String)it.next());
            }
            return out;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public int hashCode() {
        return this.getID().hashCode();
    }
}

