/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.MutableLinkDatabase;

public class DefaultMutableLinkDatabase
implements MutableLinkDatabase {
    private static final long serialVersionUID = 3770486191021916503L;
    protected Map parentLinkMap = new HashMap();
    protected Map childLinkMap;
    protected Map objects = new HashMap();

    public DefaultMutableLinkDatabase() {
        this(false);
    }

    public DefaultMutableLinkDatabase(boolean cacheChildren) {
        if (cacheChildren) {
            this.childLinkMap = new HashMap();
        }
    }

    public Collection getObjects() {
        return this.objects.values();
    }

    public Collection getParents(LinkedObject lo) {
        Set s = (Set)this.parentLinkMap.get(lo);
        if (s == null) {
            s = Collections.EMPTY_SET;
        }
        return s;
    }

    public Collection getChildren(LinkedObject lo) {
        if (this.childLinkMap != null) {
            Set s = (Set)this.childLinkMap.get(lo);
            if (s == null) {
                s = Collections.EMPTY_SET;
            }
            return s;
        }
        HashSet<Link> s = new HashSet<Link>();
        Iterator it = this.parentLinkMap.values().iterator();
        while (it.hasNext()) {
            Set parents = (Set)it.next();
            Iterator it2 = parents.iterator();
            while (it2.hasNext()) {
                Link link = (Link)it.next();
                if (!link.getParent().equals(lo)) continue;
                s.add(link);
            }
        }
        return s;
    }

    public void addParent(Link link) {
        HashSet<Link> s = (HashSet<Link>)this.parentLinkMap.get(link.getChild());
        if (s == null) {
            s = new HashSet<Link>();
            this.parentLinkMap.put(link.getChild(), s);
        }
        s.add(link);
        if (this.childLinkMap != null) {
            HashSet<Link> children = (HashSet<Link>)this.childLinkMap.get(link.getParent());
            if (children == null) {
                children = new HashSet<Link>();
                this.childLinkMap.put(link.getParent(), children);
            }
            children.add(link);
        }
    }

    public void removeParent(Link link) {
        Set children;
        Set s = (Set)this.parentLinkMap.get(link.getChild());
        if (s != null) {
            s.remove(link);
            if (s.size() == 0) {
                this.parentLinkMap.remove(link.getChild());
            }
        }
        if (this.childLinkMap != null && (children = (Set)this.childLinkMap.get(link.getParent())) != null) {
            children.remove(link);
            if (children.size() == 0) {
                this.childLinkMap.remove(link.getParent());
            }
        }
    }

    public void clear() {
        this.parentLinkMap.clear();
        if (this.childLinkMap != null) {
            this.childLinkMap.clear();
        }
    }

    public void addObject(LinkedObject lo) {
        this.objects.put(lo.getID(), lo);
    }

    public void removeObject(LinkedObject lo) {
        this.objects.remove(lo.getID());
    }

    public IdentifiedObject getObject(String id) {
        return (IdentifiedObject)this.objects.get(id);
    }
}

