/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.util.Subset;
import org.geneontology.util.VectorFilter;

public class MaskedLinkDatabase
implements LinkDatabase {
    private static final long serialVersionUID = 7258651844551493906L;
    protected LinkDatabase linkDatabase;
    protected Set visibleObjects = new HashSet();
    protected VectorFilter parentFilter = new VectorFilter(){

        public boolean satisfies(Object in) {
            return MaskedLinkDatabase.this.visibleObjects.contains(((Link)in).getParent());
        }
    };
    protected VectorFilter childFilter = new VectorFilter(){

        public boolean satisfies(Object in) {
            return MaskedLinkDatabase.this.visibleObjects.contains(((Link)in).getChild());
        }
    };

    public MaskedLinkDatabase() {
    }

    public MaskedLinkDatabase(LinkDatabase linkDatabase) {
        this.linkDatabase = linkDatabase;
    }

    public void setVisible(IdentifiedObject io, boolean visible) {
        if (visible) {
            this.visibleObjects.add(io);
        } else {
            this.visibleObjects.remove(io);
        }
    }

    public Collection getObjects() {
        return this.visibleObjects;
    }

    public void recache() {
        this.visibleObjects.clear();
    }

    public Collection getParents(LinkedObject lo) {
        return new Subset(this.parentFilter, this.linkDatabase.getParents(lo));
    }

    public Collection getChildren(LinkedObject lo) {
        return new Subset(this.childFilter, this.linkDatabase.getChildren(lo));
    }

    public IdentifiedObject getObject(String id) {
        IdentifiedObject out = this.linkDatabase.getObject(id);
        if (this.visibleObjects.contains(out)) {
            return out;
        }
        return null;
    }
}

