/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.util.FastSuperset;

public class MergedLinkDatabase
implements LinkDatabase {
    private static final long serialVersionUID = -1566436832426439038L;
    protected Set databases = new LinkedHashSet();

    public Set getDatabases() {
        return this.databases;
    }

    public void addDatabase(LinkDatabase db) {
        this.databases.add(db);
    }

    public void removeDatabase(LinkDatabase db) {
        this.databases.remove(db);
    }

    public Collection getObjects() {
        if (this.databases.size() == 1) {
            LinkDatabase db = (LinkDatabase)this.databases.iterator().next();
            return db.getObjects();
        }
        FastSuperset out = new FastSuperset();
        Iterator it = this.databases.iterator();
        while (it.hasNext()) {
            LinkDatabase db = (LinkDatabase)it.next();
            out.addSubset(db.getObjects());
        }
        return out;
    }

    public Collection getParents(LinkedObject lo) {
        if (this.databases.size() == 1) {
            LinkDatabase db = (LinkDatabase)this.databases.iterator().next();
            return db.getParents(lo);
        }
        FastSuperset out = new FastSuperset();
        Iterator it = this.databases.iterator();
        while (it.hasNext()) {
            LinkDatabase db = (LinkDatabase)it.next();
            out.addSubset(db.getParents(lo));
        }
        return out;
    }

    public Collection getChildren(LinkedObject lo) {
        if (this.databases.size() == 1) {
            LinkDatabase db = (LinkDatabase)this.databases.iterator().next();
            return db.getChildren(lo);
        }
        FastSuperset out = new FastSuperset();
        Iterator it = this.databases.iterator();
        while (it.hasNext()) {
            LinkDatabase db = (LinkDatabase)it.next();
            out.addSubset(db.getChildren(lo));
        }
        return out;
    }

    public IdentifiedObject getObject(String id) {
        Iterator it = this.databases.iterator();
        while (it.hasNext()) {
            LinkDatabase linkDatabase = (LinkDatabase)it.next();
            IdentifiedObject io = linkDatabase.getObject(id);
            if (io == null) continue;
            return io;
        }
        return null;
    }
}

