/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.gui.InstanceEditor;
import org.geneontology.oboedit.gui.event.InstanceEditEvent;
import org.geneontology.oboedit.gui.event.InstanceEditListener;

public abstract class AbstractInstanceEditor
extends JPanel
implements InstanceEditor {
    protected List listeners = new LinkedList();

    public void addInstanceEditListener(InstanceEditListener listener) {
        this.listeners.add(listener);
    }

    public void removeInstanceEditListener(InstanceEditListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireEditOccurred(InstanceEditEvent event) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            InstanceEditListener listener = (InstanceEditListener)it.next();
            listener.editOccurred(event);
        }
    }

    public void reload() {
    }

    public void commit() {
        this.commit(this.getHistoryItem());
    }

    public void commit(HistoryItem item) {
        this.fireEditOccurred(new InstanceEditEvent(this, item));
        this.reload();
    }

    public abstract HistoryItem getHistoryItem();
}

