/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.SwingUtilities;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.FileAdapterConfiguration;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.oboedit.dataadapter.SerialAdapter;
import org.geneontology.oboedit.gui.Controller;

public class AutosaveThread
extends Thread {
    protected Controller controller;
    protected boolean halt = false;

    public AutosaveThread(Controller controller) {
        this.setDaemon(true);
        this.controller = controller;
    }

    protected static String getFileName(Calendar calendar) {
        return "oboedit-save-" + calendar.get(5) + "-" + calendar.get(2) + "-" + calendar.get(1) + "-" + calendar.get(11) + "-" + calendar.get(12) + ".autosave";
    }

    public void halt() {
        try {
            this.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.halt = true;
    }

    public void run() {
        this.halt = false;
        final SerialAdapter adapter = new SerialAdapter();
        try {
            while (!this.halt) {
                AutosaveThread.sleep(this.controller.getAutosaveWaitTime() * 60000);
                final GregorianCalendar calendar = new GregorianCalendar();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            if (!AutosaveThread.this.controller.getAutosavePath().exists() && !AutosaveThread.this.controller.getAutosavePath().mkdirs()) {
                                System.err.println("Couldn't create autosave directory. Autosave disabled.");
                                AutosaveThread.this.halt = true;
                                return;
                            }
                            String saveFile = new File(AutosaveThread.this.controller.getAutosavePath(), AutosaveThread.getFileName(calendar)).toString();
                            FileAdapterConfiguration config = new FileAdapterConfiguration();
                            config.setWritePath(saveFile);
                            adapter.doOperation(IOOperation.WRITE, (AdapterConfiguration)config, Controller.getController().getSession());
                            adapter.write(AutosaveThread.this.controller.getSession());
                        }
                        catch (Exception e) {
                            System.err.println("Couldn't autosave because of " + e.getMessage() + ". " + "Autosaved disabled. " + "Stack trace follows...");
                            e.printStackTrace();
                        }
                    }
                });
                if (this.controller.getAutosaveExpiration() <= 0) continue;
                GregorianCalendar expireFileCalendar = new GregorianCalendar();
                File[] files = this.controller.getAutosavePath().listFiles();
                for (int i = 0; i < files.length; ++i) {
                    expireFileCalendar.setTime(new Date(files[i].lastModified()));
                    expireFileCalendar.add(5, this.controller.getAutosaveExpiration());
                    if (!calendar.after(expireFileCalendar)) continue;
                    System.err.println("Deleting autosave file " + files[i] + "...");
                    if (files[i].delete()) continue;
                    System.err.println("Couldn't delete expired autosave file " + files[i]);
                }
            }
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

