/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Instance;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.ReasonedLinkDatabase;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.OntologyRecognizer;

public class ConfigurableRecognizer
implements OntologyRecognizer {
    protected Collection classes = new HashSet();

    public int getSuitability(OBOSession session) {
        int matches = 0;
        ReasonedLinkDatabase reasonerDatabase = Controller.getController().getFullReasoner();
        Iterator it = session.getInstances().iterator();
        block0: while (it.hasNext()) {
            Instance instance = (Instance)it.next();
            Iterator it2 = this.classes.iterator();
            while (it2.hasNext()) {
                String id = (String)it2.next();
                OBOClass matchClass = (OBOClass)session.getObject(id);
                if (matchClass == null) continue;
                if (reasonerDatabase == null && instance.getType().equals(matchClass)) {
                    ++matches;
                    continue block0;
                }
                if (reasonerDatabase == null || !TermUtil.isSubclass((LinkDatabase)reasonerDatabase, instance.getType(), (IdentifiedObject)matchClass)) continue;
                ++matches;
                continue block0;
            }
        }
        if (session.getInstances().size() == 0) {
            return 0;
        }
        return 100 * matches / session.getInstances().size();
    }

    public void addClass(String id) {
        this.classes.add(id);
    }

    public void removeClass(String id) {
        this.classes.remove(id);
    }

    public void setClasses(Collection classes) {
        this.classes = classes;
    }

    public Collection getClasses() {
        return this.classes;
    }
}

