/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.geneontology.io.IOUtil;
import org.geneontology.oboedit.gui.ComponentConfiguration;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.FilterBuilder;
import org.geneontology.oboedit.gui.FilterRenderEditor;
import org.geneontology.oboedit.gui.filters.CompoundFilter;
import org.geneontology.oboedit.gui.filters.CompoundFilterImpl;
import org.geneontology.oboedit.gui.filters.Filter;
import org.geneontology.oboedit.gui.filters.FilterPair;
import org.geneontology.oboedit.gui.filters.FilterPairImpl;
import org.geneontology.oboedit.gui.filters.KeywordFilterBuilder;
import org.geneontology.oboedit.gui.filters.LinkRenderSpec;
import org.geneontology.oboedit.gui.filters.ObjectRenderSpec;
import org.geneontology.oboedit.gui.filters.RenderStatusEvent;
import org.geneontology.oboedit.gui.filters.RenderStatusListener;

public class FilterPairEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected FilterPanelConfig config = new FilterPanelConfig();
    protected FilterRenderEditor objectFilterEditor = new FilterRenderEditor();
    protected FilterRenderEditor linkFilterEditor = new FilterRenderEditor(true);
    protected List renderStatusListeners = new ArrayList();
    protected JCheckBox compoundCheckBox = new JCheckBox("Compound filtering");
    protected JCheckBox renderCheckBox = new JCheckBox("Rendering controls");
    protected JCheckBox linkCheckBox = new JCheckBox("Link filtering");
    protected JCheckBox termCheckBox = new JCheckBox("Term filtering", true);
    protected JCheckBox keywordCheckBox = new JCheckBox("Keyword filtering", true);
    protected URL loadIconURL = this.getClass().getClassLoader().getResource("org/geneontology/oboedit/gui/resources/icons/folder.gif");
    protected URL diskIconURL = this.getClass().getClassLoader().getResource("org/geneontology/oboedit/gui/resources/icons/floppy.gif");
    protected URL fileIconURL = this.getClass().getClassLoader().getResource("org/geneontology/oboedit/gui/resources/icons/file.gif");
    protected URL customizeIconURL = this.getClass().getClassLoader().getResource("org/geneontology/oboedit/gui/resources/icons/customize.gif");
    protected URL simpleIconURL = this.getClass().getClassLoader().getResource("org/geneontology/oboedit/gui/resources/icons/customize_simple.gif");
    protected Icon customizeIcon = new ImageIcon(this.customizeIconURL);
    protected Icon simpleIcon = new ImageIcon(this.simpleIconURL);
    protected Icon diskIcon = new ImageIcon(this.diskIconURL);
    protected JButton newButton = new JButton(new ImageIcon(this.fileIconURL));
    protected JButton loadButton = new JButton(new ImageIcon(this.loadIconURL));
    protected JButton saveButton = new JButton(this.diskIcon);
    protected JPanel objectPanel = new JPanel();
    protected JPanel linkPanel = new JPanel();
    protected JPanel buttonPanel = new JPanel();
    protected JPanel advancedPanel = new JPanel();
    protected boolean advancedMode = true;
    JTabbedPane filtersPanel = new JTabbedPane();
    protected FilterPair filterPair;
    protected List extendedTabs = new ArrayList();
    protected boolean showAdvancedTab = true;
    protected boolean rendererOptionAllowed = true;
    protected boolean keywordOptionAllowed = true;

    public void addActionListener(ActionListener listener) {
        this.objectFilterEditor.addActionListener(listener);
        this.linkFilterEditor.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.objectFilterEditor.removeActionListener(listener);
        this.linkFilterEditor.removeActionListener(listener);
    }

    public void addRenderStatusListener(RenderStatusListener listener) {
        this.renderStatusListeners.add(listener);
    }

    public void removeRenderStatusListener(RenderStatusListener listener) {
        this.renderStatusListeners.remove(listener);
    }

    protected void fireRendererStatusChanged(RenderStatusEvent event) {
        Iterator it = this.renderStatusListeners.iterator();
        while (it.hasNext()) {
            RenderStatusListener listener = (RenderStatusListener)it.next();
            listener.statusChanged(event);
        }
    }

    public boolean getAdvancedMode() {
        return this.advancedMode;
    }

    public ComponentConfiguration getConfig() {
        this.acceptEdits();
        return this.config;
    }

    public void setShowAdvancedTab(boolean showAdvancedTab) {
        if (this.showAdvancedTab && !showAdvancedTab) {
            this.filtersPanel.removeTabAt(this.filtersPanel.getTabCount() - 1);
        }
        if (showAdvancedTab) {
            this.filtersPanel.addTab("Advanced Options", this.customizeIcon, this.advancedPanel);
        }
        this.showAdvancedTab = showAdvancedTab;
        this.validate();
        this.repaint();
    }

    public void setConfig(ComponentConfiguration c) {
        FilterPanelConfig cin = (FilterPanelConfig)c;
        this.setKeywordMode(cin.getKeywordMode());
        this.setShowCompoundFilter(cin.getCompoundFiltering());
        this.setLinkFilterVisible(cin.getLinkFilterVisible());
        this.setSpecEditorVisible(cin.getSpecEditorVisible());
        this.setTermFilterVisible(cin.getTermFilterVisible());
        this.setFilterPair(cin.getFilterPair());
        this.filtersPanel.setSelectedIndex(0);
        this.config = cin;
    }

    public void addExtendedTab(Component c, String name, Icon icon) {
        this.extendedTabs.add(new ExtendedTab(c, name));
        this.filtersPanel.addTab(name, icon, c);
        this.filtersPanel.setSelectedComponent(c);
    }

    public void setTabName(Component c, String name) {
        int index = this.filtersPanel.indexOfComponent(c);
        if (index > 0) {
            this.filtersPanel.setTitleAt(index, name);
        }
        Iterator it = this.extendedTabs.iterator();
        while (it.hasNext()) {
            ExtendedTab et = (ExtendedTab)it.next();
            if (!et.getComponent().equals(c)) continue;
            et.setName(name);
            break;
        }
    }

    public int getTabIndex(Component c) {
        return this.filtersPanel.indexOfComponent(c);
    }

    public void removeExtendedTab(Component c) {
        Iterator it = this.extendedTabs.iterator();
        while (it.hasNext()) {
            ExtendedTab tab = (ExtendedTab)it.next();
            if (!tab.getComponent().equals(c)) continue;
            it.remove();
            break;
        }
        this.filtersPanel.remove(c);
    }

    public void setAdvancedMode(boolean advancedMode) {
        this.advancedMode = advancedMode;
    }

    public void newFilter() {
        this.setFilterPair(new FilterPairImpl());
    }

    public void load() {
        FilterPair pair = FilterPairEditor.loadFilterPair();
        if (pair != null) {
            this.setFilterPair(pair);
        }
    }

    public void save() {
        FilterPairEditor.save(this.getFilterPair());
    }

    public static FilterPair loadFilterPair() {
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showOpenDialog(Controller.getController().getFrame());
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            try {
                return FilterPairEditor.loadFilterPair(file);
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public static FilterPair loadFilterPair(File file) throws IOException {
        return FilterPairEditor.loadFilterPair(file.toString());
    }

    public static FilterPair loadFilterPair(String path) throws IOException {
        XMLDecoder d = new XMLDecoder(new BufferedInputStream(IOUtil.getStream((String)path)));
        d.setExceptionListener(new ExceptionListener(){

            public void exceptionThrown(Exception ex) {
                ex.printStackTrace();
            }
        });
        FilterPair result = (FilterPair)d.readObject();
        System.err.println("LOADED filterpair: " + result + ", compoundfilterimpl.class = " + CompoundFilterImpl.class);
        d.close();
        return result;
    }

    public void load(File file) {
        try {
            this.setFilterPair(FilterPairEditor.loadFilterPair(file));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void load(String filename) {
        this.load(new File(filename));
    }

    public static void save(FilterPair filterPair) {
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showSaveDialog(Controller.getController().getFrame());
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            FilterPairEditor.save(file.toString(), filterPair);
        }
    }

    public static void save(String filename, FilterPair filterPair) {
        try {
            XMLEncoder e = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(filename)));
            e.writeObject(filterPair);
            e.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void save(String filename) {
        FilterPairEditor.save(filename, this.getFilterPair());
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.objectFilterEditor != null) {
            this.objectFilterEditor.setFont(font);
        }
        if (this.filtersPanel != null) {
            this.filtersPanel.setFont(font);
        }
        if (this.linkFilterEditor != null) {
            this.linkFilterEditor.setFont(font);
        }
        if (this.compoundCheckBox != null) {
            this.compoundCheckBox.setFont(font);
        }
        if (this.renderCheckBox != null) {
            this.renderCheckBox.setFont(font);
        }
        if (this.linkCheckBox != null) {
            this.linkCheckBox.setFont(font);
        }
        if (this.termCheckBox != null) {
            this.termCheckBox.setFont(font);
        }
        if (this.keywordCheckBox != null) {
            this.keywordCheckBox.setFont(font);
        }
        if (this.loadButton != null) {
            this.loadButton.setFont(font);
        }
        if (this.saveButton != null) {
            this.saveButton.setFont(font);
        }
    }

    public void setButtonColor(Color buttonColor) {
        this.objectFilterEditor.setButtonColor(buttonColor);
        this.linkFilterEditor.setButtonColor(buttonColor);
        this.compoundCheckBox.setBackground(buttonColor);
        this.renderCheckBox.setBackground(buttonColor);
        this.linkCheckBox.setBackground(buttonColor);
        this.termCheckBox.setBackground(buttonColor);
        this.keywordCheckBox.setBackground(buttonColor);
        this.newButton.setBackground(buttonColor);
        this.loadButton.setBackground(buttonColor);
        this.saveButton.setBackground(buttonColor);
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.filtersPanel != null) {
            this.filtersPanel.setBackground(background);
            this.objectPanel.setBackground(background);
            this.linkPanel.setBackground(background);
            this.advancedPanel.setBackground(background);
        }
    }

    public FilterPairEditor() {
        this.objectPanel.setLayout(new BorderLayout());
        this.objectPanel.add((Component)this.objectFilterEditor, "Center");
        this.linkPanel.setLayout(new BorderLayout());
        this.linkPanel.add((Component)this.linkFilterEditor, "Center");
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterPairEditor.this.newFilter();
            }
        });
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterPairEditor.this.load();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterPairEditor.this.save();
            }
        });
        this.compoundCheckBox.setOpaque(false);
        this.linkCheckBox.setOpaque(false);
        this.termCheckBox.setOpaque(false);
        this.keywordCheckBox.setOpaque(false);
        this.renderCheckBox.setOpaque(false);
        this.compoundCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterPairEditor.this.setShowCompoundFilter(FilterPairEditor.this.compoundCheckBox.isSelected());
            }
        });
        this.renderCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterPairEditor.this.setSpecEditorVisible(FilterPairEditor.this.renderCheckBox.isSelected());
            }
        });
        this.linkCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterPairEditor.this.setLinkFilterVisible(FilterPairEditor.this.linkCheckBox.isSelected());
            }
        });
        this.termCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterPairEditor.this.setTermFilterVisible(FilterPairEditor.this.termCheckBox.isSelected());
            }
        });
        this.keywordCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterPairEditor.this.setKeywordMode(FilterPairEditor.this.keywordCheckBox.isSelected());
            }
        });
        this.advancedPanel.setLayout(new BoxLayout(this.advancedPanel, 1));
        this.configureAdvancedPanel();
        Box leftButtons = new Box(0);
        leftButtons.add(this.newButton);
        leftButtons.add(Box.createHorizontalStrut(5));
        leftButtons.add(this.loadButton);
        leftButtons.add(Box.createHorizontalStrut(5));
        leftButtons.add(this.saveButton);
        leftButtons.add(Box.createHorizontalStrut(5));
        this.setLayout(new BorderLayout());
        this.add((Component)this.filtersPanel, "Center");
        this.setFilterPair(new FilterPairImpl());
        this.updateSplitPane();
        this.filtersPanel.setSelectedIndex(0);
    }

    public void setRendererOptionAllowed(boolean rendererOptionAllowed) {
        this.rendererOptionAllowed = rendererOptionAllowed;
        this.setSpecEditorVisible(rendererOptionAllowed && this.config.getSpecEditorVisible());
        this.configureAdvancedPanel();
    }

    public void setKeywordOptionAllowed(boolean keywordOptionAllowed) {
        this.keywordOptionAllowed = keywordOptionAllowed;
        this.setKeywordMode(keywordOptionAllowed && this.config.getKeywordMode());
        this.configureAdvancedPanel();
    }

    protected void configureAdvancedPanel() {
        this.advancedPanel.removeAll();
        this.advancedPanel.add(this.compoundCheckBox);
        if (this.rendererOptionAllowed) {
            this.advancedPanel.add(this.renderCheckBox);
        }
        this.advancedPanel.add(this.linkCheckBox);
        this.advancedPanel.add(this.termCheckBox);
        if (this.keywordOptionAllowed) {
            this.advancedPanel.add(this.keywordCheckBox);
        }
    }

    protected boolean isLinkFilterActive() {
        return this.config.getLinkFilterVisible();
    }

    protected boolean isObjectFilterActive() {
        return this.config.getTermFilterVisible();
    }

    public void acceptEdits() {
        this.objectFilterEditor.acceptEdits();
        this.linkFilterEditor.acceptEdits();
        if (this.isObjectFilterActive()) {
            this.filterPair.setObjectFilter(this.objectFilterEditor.getFilter());
            if (this.config.getSpecEditorVisible()) {
                this.filterPair.setObjectRenderSpec((ObjectRenderSpec)this.objectFilterEditor.getSpec());
            } else {
                this.filterPair.setObjectRenderSpec(null);
            }
        } else {
            this.filterPair.setObjectFilter(null);
            this.filterPair.setObjectRenderSpec(null);
        }
        if (this.isLinkFilterActive()) {
            this.filterPair.setLinkFilter(this.linkFilterEditor.getFilter());
            if (this.config.getSpecEditorVisible()) {
                this.filterPair.setLinkRenderSpec((LinkRenderSpec)this.linkFilterEditor.getSpec());
            } else {
                this.filterPair.setLinkRenderSpec(null);
            }
        } else {
            this.filterPair.setLinkFilter(null);
            this.filterPair.setLinkRenderSpec(null);
        }
    }

    public void reset() {
        this.newFilter();
        this.extendedTabs.clear();
        this.rebuildTabs();
    }

    protected void rebuildTabs() {
        this.filtersPanel.removeAll();
        if (this.config.getTermFilterVisible()) {
            this.filtersPanel.add((Component)this.objectPanel, "Term filter");
        }
        if (this.config.getLinkFilterVisible()) {
            this.filtersPanel.add((Component)this.linkPanel, "Link filter");
        }
        this.filtersPanel.addTab("Advanced Options", this.customizeIcon, this.advancedPanel);
        Iterator it = this.extendedTabs.iterator();
        while (it.hasNext()) {
            ExtendedTab tab = (ExtendedTab)it.next();
            this.filtersPanel.add(tab.getComponent(), tab.getName());
        }
        this.filtersPanel.validate();
    }

    protected void updateSplitPane() {
        this.rebuildTabs();
        this.filtersPanel.setSelectedComponent(this.advancedPanel);
    }

    protected void updateGUI() {
        this.objectFilterEditor.setFilter(this.filterPair.getObjectFilter());
        this.objectFilterEditor.setSpec(this.filterPair.getObjectRenderSpec());
        this.linkFilterEditor.setFilter(this.filterPair.getLinkFilter());
        this.linkFilterEditor.setSpec(this.filterPair.getLinkRenderSpec());
        boolean needAdvancedMode = false;
        boolean termVisible = false;
        boolean filterVisible = false;
        boolean specVisible = false;
        boolean compoundVisible = false;
        if (this.filterPair.getObjectFilter() != null) {
            termVisible = true;
        }
        if (this.filterPair.getLinkFilter() != null) {
            boolean bl = filterVisible = !this.config.getKeywordMode();
        }
        if (this.filterPair.getObjectRenderSpec() != null || this.filterPair.getLinkRenderSpec() != null) {
            specVisible = true;
        }
        if (this.isCompound(this.filterPair.getLinkFilter()) || this.isCompound(this.filterPair.getObjectFilter())) {
            compoundVisible = true;
        }
        if (termVisible) {
            this.setTermFilterVisible(termVisible);
        }
        if (filterVisible) {
            this.setLinkFilterVisible(filterVisible);
        }
        if (specVisible) {
            this.setSpecEditorVisible(specVisible);
        }
        if (compoundVisible && !this.config.getKeywordMode()) {
            this.setShowCompoundFilter(compoundVisible);
        }
        this.linkCheckBox.setEnabled(!this.config.getKeywordMode());
        this.compoundCheckBox.setEnabled(!this.config.getKeywordMode());
    }

    protected boolean isCompound(Filter f) {
        if (f == null) {
            return false;
        }
        if (!(f instanceof CompoundFilter)) {
            return false;
        }
        CompoundFilter filter = (CompoundFilter)f;
        return filter.getFilters().size() > 1 || filter.getFilters().size() == 1 && filter.getFilters().get(0) instanceof CompoundFilter;
    }

    public void setFilterPair(FilterPair filterPair) {
        this.filterPair = filterPair;
        this.config.setFilterPair(filterPair);
        this.updateGUI();
    }

    public FilterPair getFilterPair() {
        this.acceptEdits();
        return (FilterPair)this.filterPair.clone();
    }

    public void setTermFilterVisible(boolean termFilterVisible) {
        boolean doRedraw = this.config.getTermFilterVisible() != termFilterVisible;
        this.config.setTermFilterVisible(termFilterVisible);
        if (doRedraw) {
            this.updateSplitPane();
        }
        this.termCheckBox.setSelected(termFilterVisible);
    }

    public void setLinkFilterVisible(boolean linkFilterVisible) {
        boolean doRedraw = this.config.getLinkFilterVisible() != linkFilterVisible;
        this.config.setLinkFilterVisible(linkFilterVisible);
        if (doRedraw) {
            this.updateSplitPane();
        }
        this.linkCheckBox.setSelected(linkFilterVisible);
    }

    public void setShowCompoundFilter(boolean compoundVisible) {
        this.config.setCompoundFiltering(compoundVisible);
        this.linkFilterEditor.setShowCompoundFilter(compoundVisible);
        this.objectFilterEditor.setShowCompoundFilter(compoundVisible);
        this.compoundCheckBox.setSelected(compoundVisible);
    }

    public void setSpecEditorVisible(boolean specEditorVisible) {
        this.fireRendererStatusChanged(new RenderStatusEvent(this, specEditorVisible));
        this.config.setSpecEditorVisible(specEditorVisible);
        this.linkFilterEditor.setSpecEditorVisible(specEditorVisible);
        this.objectFilterEditor.setSpecEditorVisible(specEditorVisible);
        this.renderCheckBox.setSelected(specEditorVisible);
    }

    public void setKeywordMode(boolean keywordMode) {
        if (keywordMode != this.config.getKeywordMode()) {
            if (keywordMode) {
                this.objectFilterEditor.setFilterBuilder(new KeywordFilterBuilder());
                this.setShowCompoundFilter(false);
                this.setLinkFilterVisible(false);
                this.setTermFilterVisible(true);
                this.linkCheckBox.setEnabled(false);
                this.compoundCheckBox.setEnabled(false);
            } else {
                CompoundFilter f = (CompoundFilter)this.objectFilterEditor.getFilter();
                this.objectFilterEditor.setFilterBuilder(new FilterBuilder());
                this.linkCheckBox.setEnabled(true);
                this.compoundCheckBox.setEnabled(true);
                if (f.getFilters().size() > 1) {
                    this.setShowCompoundFilter(true);
                }
            }
            this.config.setKeywordMode(keywordMode);
            this.keywordCheckBox.setSelected(keywordMode);
            this.repaint();
        }
    }

    public boolean getSpecEditorVisible() {
        return this.config.getSpecEditorVisible();
    }

    protected class ExtendedTab {
        protected Component c;
        protected String name;

        public ExtendedTab(Component c, String name) {
            this.c = c;
            this.name = name;
        }

        public Component getComponent() {
            return this.c;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class FilterPanelConfig
    implements ComponentConfiguration {
        protected boolean linkFilterVisible = false;
        protected boolean termFilterVisible = true;
        protected boolean specEditorVisible = false;
        protected boolean compoundFiltering = false;
        protected boolean keywordMode = true;
        protected FilterPair filterPair = null;

        public void setKeywordMode(boolean keywordMode) {
            this.keywordMode = keywordMode;
        }

        public boolean getKeywordMode() {
            return this.keywordMode;
        }

        public void setFilterPair(FilterPair filterPair) {
            this.filterPair = filterPair;
        }

        public FilterPair getFilterPair() {
            return this.filterPair;
        }

        public void setCompoundFiltering(boolean compoundFiltering) {
            this.compoundFiltering = compoundFiltering;
        }

        public boolean getCompoundFiltering() {
            return this.compoundFiltering;
        }

        public void setTermFilterVisible(boolean termFilterVisible) {
            this.termFilterVisible = termFilterVisible;
        }

        public boolean getTermFilterVisible() {
            return this.termFilterVisible;
        }

        public void setSpecEditorVisible(boolean specEditorVisible) {
            this.specEditorVisible = specEditorVisible;
        }

        public boolean getSpecEditorVisible() {
            return this.specEditorVisible;
        }

        public boolean getLinkFilterVisible() {
            return this.linkFilterVisible;
        }

        public void setLinkFilterVisible(boolean linkFilterVisible) {
            this.linkFilterVisible = linkFilterVisible;
        }
    }
}

