/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.geneontology.oboedit.gui.filters.LinkRenderSpec;
import org.geneontology.oboedit.gui.filters.ObjectRenderSpec;
import org.geneontology.oboedit.gui.filters.RenderSpec;
import org.geneontology.oboedit.gui.filters.SpecEditor;

public class LinkSpecEditor
extends JPanel
implements SpecEditor {
    private static final long serialVersionUID = 1L;
    protected LinkRenderSpec spec = new LinkRenderSpec();
    protected JCheckBox colorBox = new JCheckBox();
    protected JCheckBox linkTypeBox = new JCheckBox();
    protected JCheckBox lineWidthBox = new JCheckBox();
    protected JLabel colorLabel = new JLabel("Change color");
    protected JLabel linkTypeLabel = new JLabel("Change line type");
    protected JLabel lineWidthLabel = new JLabel("Change line width");
    protected JPanel colorPanel = new JPanel();
    protected JPanel lineTypePanel = new JPanel();
    protected JPanel lineWidthPanel = new JPanel();
    protected JComboBox lineTypeSelector = new JComboBox();
    protected JTextField lineWidthField = new JTextField(3);
    protected JButton colorButton = new JButton();

    public void setFont(Font font) {
        super.setFont(font);
        if (this.colorLabel != null) {
            this.colorLabel.setFont(font);
        }
        if (this.linkTypeLabel != null) {
            this.linkTypeLabel.setFont(font);
        }
        if (this.lineWidthLabel != null) {
            this.lineWidthLabel.setFont(font);
        }
        if (this.lineTypeSelector != null) {
            this.lineTypeSelector.setFont(font);
        }
    }

    public RenderSpec createNewSpec() {
        return new ObjectRenderSpec();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.linkTypeBox.setEnabled(enabled);
        this.lineWidthBox.setEnabled(enabled);
        this.colorBox.setEnabled(enabled);
        this.colorLabel.setEnabled(enabled);
        this.linkTypeLabel.setEnabled(enabled);
        this.lineWidthLabel.setEnabled(enabled);
        this.lineTypeSelector.setEnabled(enabled);
        this.lineWidthField.setEnabled(enabled);
        this.colorButton.setEnabled(enabled);
    }

    protected void updatePanels() {
        if (this.colorBox.isSelected()) {
            this.colorPanel.add(this.colorButton);
        } else {
            this.colorPanel.remove(this.colorButton);
        }
        if (this.linkTypeBox.isSelected()) {
            this.lineTypePanel.add(this.lineTypeSelector);
        } else {
            this.lineTypePanel.remove(this.lineTypeSelector);
        }
        if (this.lineWidthBox.isSelected()) {
            this.lineWidthPanel.add(this.lineWidthField);
        } else {
            this.lineWidthPanel.remove(this.lineWidthField);
        }
        this.revalidate();
        this.repaint();
    }

    public void setButtonColor(Color buttonColor) {
        this.lineTypeSelector.setBackground(buttonColor);
    }

    public LinkSpecEditor() {
        this.setOpaque(false);
        this.colorBox.setOpaque(false);
        this.linkTypeBox.setOpaque(false);
        this.lineWidthBox.setOpaque(false);
        this.lineTypeSelector.addItem("Solid");
        this.lineTypeSelector.addItem("Wavy");
        this.lineTypeSelector.addItem("Dashed");
        this.colorBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LinkSpecEditor.this.updatePanels();
            }
        });
        this.linkTypeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LinkSpecEditor.this.updatePanels();
            }
        });
        this.lineWidthBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LinkSpecEditor.this.updatePanels();
            }
        });
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(LinkSpecEditor.this, "Choose a color", LinkSpecEditor.this.colorButton.getBackground());
                LinkSpecEditor.this.colorButton.setBackground(color);
            }
        });
        this.colorPanel.setOpaque(false);
        this.lineTypePanel.setOpaque(false);
        this.lineWidthPanel.setOpaque(false);
        this.colorPanel.setLayout(new BoxLayout(this.colorPanel, 0));
        this.lineTypePanel.setLayout(new BoxLayout(this.lineTypePanel, 0));
        this.lineWidthPanel.setLayout(new BoxLayout(this.lineWidthPanel, 0));
        this.colorPanel.add(this.colorLabel);
        this.colorPanel.add(Box.createHorizontalStrut(10));
        this.colorPanel.add(this.colorBox);
        this.colorPanel.add(Box.createHorizontalStrut(10));
        this.colorPanel.add(Box.createHorizontalGlue());
        this.lineTypePanel.add(this.linkTypeLabel);
        this.lineTypePanel.add(Box.createHorizontalStrut(10));
        this.lineTypePanel.add(this.linkTypeBox);
        this.lineTypePanel.add(Box.createHorizontalStrut(10));
        this.lineTypePanel.add(Box.createHorizontalGlue());
        this.lineWidthPanel.add(this.lineWidthLabel);
        this.lineWidthPanel.add(Box.createHorizontalStrut(10));
        this.lineWidthPanel.add(this.lineWidthBox);
        this.lineWidthPanel.add(Box.createHorizontalStrut(10));
        this.lineWidthPanel.add(Box.createHorizontalGlue());
        this.colorPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getLineHeight()));
        this.lineTypePanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getLineHeight()));
        this.lineWidthPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getLineHeight()));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.colorPanel);
        this.add(this.lineTypePanel);
        this.add(this.lineWidthPanel);
        this.add(Box.createVerticalGlue());
    }

    protected int getLineHeight() {
        return this.getFont().getSize() * 2;
    }

    public RenderSpec getSpec() {
        this.acceptEdits();
        return this.spec;
    }

    protected void acceptEdits() {
        if (this.colorBox.isSelected()) {
            this.spec.setLinkColor(this.colorButton.getBackground());
        } else {
            this.spec.setLinkColor(null);
        }
        if (this.linkTypeBox.isSelected()) {
            this.spec.setLineType(this.lineTypeSelector.getSelectedIndex());
        } else {
            this.spec.setLineType(-1);
        }
        if (this.lineWidthBox.isSelected()) {
            try {
                this.spec.setLineWidth(Integer.parseInt(this.lineWidthField.getText()));
            }
            catch (Exception ex) {
                this.spec.setLineWidth(-1);
            }
        } else {
            this.spec.setLineWidth(-1);
        }
    }

    protected void updateGUI() {
        this.colorBox.setSelected(this.spec.getLinkColor() != null);
        if (this.spec.getLinkColor() != null) {
            this.colorButton.setBackground(this.spec.getLinkColor());
        }
        this.linkTypeBox.setSelected(this.spec.getLineType() != -1);
        if (this.spec.getLineType() != -1) {
            this.lineTypeSelector.setSelectedIndex(this.spec.getLineType());
        }
        this.lineWidthBox.setSelected(this.spec.getLineWidth() != -1);
        if (this.spec.getLineWidth() != -1) {
            this.lineWidthField.setText(this.spec.getLineWidth() + "");
        }
        this.updatePanels();
    }

    public void setSpec(RenderSpec spec) {
        this.spec = spec != null ? (LinkRenderSpec)spec : new LinkRenderSpec();
        this.updateGUI();
    }
}

