/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComboBox;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.NamespaceHistoryItem;
import org.geneontology.oboedit.gui.AbstractTextEditComponent;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.util.ObjectUtil;

public class NamespaceEditorComponent
extends AbstractTextEditComponent {
    private static final long serialVersionUID = 8387517031428288469L;
    protected JComboBox namespaceList = new JComboBox();

    public Component resolveName(String id, Properties props, String xml) {
        if (id.equals("list")) {
            return this.namespaceList;
        }
        return new JButton("id");
    }

    public NamespaceEditorComponent() {
        this.namespaceList.setBackground(Preferences.defaultButtonColor());
    }

    protected boolean useSubLayout() {
        return true;
    }

    protected String getDefaultLayout() {
        return "<box orientation='HORZ'><label text='Namespace'/><spacer orientation='horz' size='10'/><component id='list'/></box>";
    }

    protected void loadGUI() {
        if (this.currentObject != null) {
            boolean enable = !TermUtil.isObsolete(this.currentObject);
            this.namespaceList.setEnabled(true);
            this.namespaceList.removeAllItems();
            ArrayList namespaces = new ArrayList();
            namespaces.addAll(Controller.getController().getSession().getNamespaces());
            Collections.sort(namespaces, Namespace.COMPARATOR);
            Iterator it = namespaces.iterator();
            while (it.hasNext()) {
                Namespace ns = (Namespace)it.next();
                this.namespaceList.addItem(ns);
            }
            this.namespaceList.setSelectedItem(this.currentObject.getNamespace());
            this.namespaceList.setEnabled(enable);
        } else {
            this.namespaceList.setEnabled(false);
            this.namespaceList.setSelectedItem(null);
        }
    }

    protected void initializeGUI() {
        this.namespaceList.setFont(Controller.getController().getDefaultFont());
        this.namespaceList.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)this.namespaceList.getPreferredSize().getHeight()));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)this.getPreferredSize().getHeight()));
        this.setMinimumSize(this.getPreferredSize());
    }

    public String getID() {
        return "NAMESPACE_EDITOR";
    }

    public void populateFields(IdentifiedObject io) {
        io.setNamespace((Namespace)this.namespaceList.getSelectedItem());
    }

    public List getChanges() {
        if (this.currentObject != null) {
            if (!ObjectUtil.equals((Object)this.namespaceList.getSelectedItem(), (Object)this.currentObject.getNamespace())) {
                NamespaceHistoryItem item = new NamespaceHistoryItem(this.currentObject, (Namespace)this.namespaceList.getSelectedItem());
                return Collections.singletonList(item);
            }
            return Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }
}

