/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.geneontology.oboedit.gui.ComponentConfiguration;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.FilterPairEditor;
import org.geneontology.oboedit.gui.OBOEditComponent;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.filters.FilterPair;

public class UserFilterButton
implements OBOEditComponent {
    private static final long serialVersionUID = 1L;
    public static final int MODIFY = 1;
    public static final int FILTER = 2;
    public static final int RENDER = 3;
    public static final int SEARCH = 4;
    protected int method = 4;
    protected FilterPair pair;
    protected String label;
    protected String iconPath;
    protected String tooltipText;
    protected boolean selected;
    protected AbstractButton component;
    protected ItemListener modifyActionListener = new ItemListener(){

        public void itemStateChanged(ItemEvent e) {
            UserFilterButton.this.selected = ((JToggleButton)UserFilterButton.this.component).isSelected();
            if (UserFilterButton.this.selected) {
                Controller.getController().addModifyFilter(UserFilterButton.this.pair);
                System.err.println("adding modify filter: " + UserFilterButton.this.pair);
            } else {
                Controller.getController().removeModifyFilter(UserFilterButton.this.pair);
                System.err.println("removing modify filter: " + UserFilterButton.this.pair);
            }
        }
    };
    protected ActionListener searchActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Controller.getController().getFindPanel().setFilterPair(UserFilterButton.this.pair);
            Controller.getController().getFindPanel().search();
        }
    };
    protected ActionListener filterActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Controller.getController().getFindPanel().setFilterPair(UserFilterButton.this.pair);
            Controller.getController().getFindPanel().filter();
        }
    };

    protected static String resolveFilterPath(String filterPath) {
        if (filterPath != null && filterPath.startsWith("resource:")) {
            return Controller.getController().getResourceURL("org/geneontology/oboedit/gui/resources/filters/" + filterPath.substring(9, filterPath.length())).toString();
        }
        return filterPath;
    }

    public UserFilterButton(int method, String filterPath, String label, boolean selected, String iconPath, String tooltipText, ButtonGroup group) {
        try {
            filterPath = UserFilterButton.resolveFilterPath(filterPath);
            this.method = method;
            this.pair = filterPath != null ? FilterPairEditor.loadFilterPair(filterPath) : FilterPair.ALWAYS_TRUE;
            this.label = label;
            this.iconPath = iconPath;
            this.tooltipText = tooltipText;
            this.selected = selected;
            if (method == 1) {
                this.component = group == null ? new JCheckBox() : new JRadioButton();
                this.component.addItemListener(this.modifyActionListener);
                if (group != null) {
                    group.add(this.component);
                }
                this.component.setOpaque(false);
                ((JToggleButton)this.component).setSelected(selected);
            } else {
                this.component = new JButton();
                this.component.addActionListener(this.searchActionListener);
            }
            if (tooltipText != null) {
                this.component.setToolTipText(tooltipText);
            }
            Icon icon = null;
            if (iconPath != null) {
                try {
                    URL url = new URL(iconPath);
                    icon = new ImageIcon(url);
                }
                catch (Exception ex) {
                    File file = new File(iconPath);
                    icon = file.exists() ? new ImageIcon(iconPath) : Preferences.loadLibraryIcon(iconPath);
                }
            }
            if (icon != null) {
                this.component.setIcon(icon);
            }
            if (label != null) {
                this.component.setText(label);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.component.setText("Could not load filter " + filterPath);
        }
    }

    public void init() {
        this.component.setBackground(Controller.getController().getPreferences().getButtonColor());
        this.component.setFont(Controller.getController().getPreferences().getFont());
        if (this.selected) {
            Controller.getController().addModifyFilter(this.pair);
        }
    }

    public void cleanup() {
        if (this.selected) {
            Controller.getController().removeModifyFilter(this.pair);
        }
    }

    public boolean isSingleton() {
        return false;
    }

    public ComponentConfiguration getConfiguration() {
        return null;
    }

    public void setConfiguration(ComponentConfiguration c) {
    }

    public String getID() {
        return "SEARCH_BUTTON";
    }

    public void setController(Controller controller) {
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setXML(String xml) {
    }
}

