/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.AddDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.CreateObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.DefinitionChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.NameChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.NamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.actions.AddAction;

public class AddRootAction
implements ClickMenuAction {
    protected List subActions = new Vector();
    protected Controller controller;

    public AddRootAction() {
        this.subActions.add(new TypedAddAction(false));
        this.subActions.add(new TypedAddAction(true));
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public KeyStroke getKeyStroke() {
        return null;
    }

    public String getName() {
        return "Add root";
    }

    public String getDesc() {
        return null;
    }

    public List getSubActions() {
        return this.subActions;
    }

    public void clickInit(TreePath[] paths, TreePath destItem) {
    }

    public boolean isLegal() {
        return true;
    }

    public HistoryItem execute() {
        return null;
    }

    protected class TypedAddAction
    extends AddAction {
        protected boolean isType;

        public TypedAddAction(boolean isType) {
            this.isType = isType;
        }

        public void clickInit(TreePath[] sourceItems, TreePath destItem) {
        }

        public String getName() {
            if (this.isType) {
                return "Add type root";
            }
            return "Add root";
        }

        public String getDesc() {
            return null;
        }

        public boolean isLegal() {
            return true;
        }

        public HistoryItem execute() {
            String id = null;
            id = this.isType ? this.getTypeID() : TermUtil.fetchID(this.controller, null);
            if (id == null) {
                return null;
            }
            TermMacroHistoryItem item = new TermMacroHistoryItem("Created new " + (this.isType ? "type " : "") + "root");
            String typeID = this.isType ? OBOClass.OBO_PROPERTY.getID() : OBOClass.OBO_CLASS.getID();
            item.addHistoryItem(new CreateObjectHistoryItem(id, typeID));
            Namespace ns = this.controller.getSession().getDefaultNamespace();
            if (ns != null) {
                item.addHistoryItem(new NamespaceHistoryItem(null, ns, id));
            }
            if (this.isType) {
                item.addHistoryItem(new NameChangeHistoryItem(id, "<new term>", id));
            }
            if (Controller.getController().getPreferences().getUsePersonalDefinition()) {
                item.addHistoryItem(new DefinitionChangeHistoryItem(null, Controller.getController().getPreferences().getPersonalDefinition(), id));
                Iterator it = Controller.getController().getPreferences().getPersonalDbxrefs().iterator();
                while (it.hasNext()) {
                    Dbxref ref = (Dbxref)it.next();
                    item.addHistoryItem(new AddDbxrefHistoryItem(id, ref, true, null));
                }
            }
            HistoryItem.StringRelationship sr = new HistoryItem.StringRelationship(id);
            TreePath path = this.isType ? TermUtil.convertPathToIDs(new TreePath(OBOSession.ROOT).pathByAddingChild(OBOSession.TYPES)).pathByAddingChild(sr) : new TreePath(sr);
            TreePath[] paths = new TreePath[]{path};
            item.setPostSelection(paths);
            return item;
        }
    }
}

