/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.DeleteLinkHistoryItem;
import org.geneontology.oboedit.datamodel.history.ObsoleteObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.Controller;

public class DeleteAction
implements ClickMenuAction {
    protected TreePath[] sources;
    protected TreePath destItem;
    protected boolean isLegal = false;
    protected Controller controller;
    protected static KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public KeyStroke getKeyStroke() {
        return keyStroke;
    }

    public String getName() {
        return "Delete";
    }

    public String getDesc() {
        return "Deleting";
    }

    public List getSubActions() {
        return null;
    }

    public void clickInit(TreePath[] paths, TreePath destItem) {
        this.isLegal = paths.length > 0;
        for (int i = 0; i < paths.length; ++i) {
            Link tr = (Link)paths[i].getLastPathComponent();
            LinkedObject parent = tr.getParent();
            LinkedObject child = tr.getChild();
            if (TermUtil.isFake(tr)) {
                this.isLegal = false;
                continue;
            }
            if (child.getParents().size() > 1) continue;
            if (child.getChildren().size() > 0 && !TermUtil.hasAncestor(child, child)) {
                this.isLegal = false;
            } else if (child.isBuiltIn()) {
                this.isLegal = false;
            } else if (TermUtil.isProperty(child)) {
                Iterator it = this.controller.getSession().getObjects().iterator();
                while (it.hasNext()) {
                    LinkedObject lo;
                    IdentifiedObject io = (IdentifiedObject)it.next();
                    if (!(io instanceof LinkedObject) || !TermUtil.usesType(lo = (LinkedObject)io, (OBOProperty)child)) continue;
                    this.isLegal = false;
                    break;
                }
            }
            if (!this.isLegal) break;
        }
        if (this.isLegal) {
            this.sources = paths;
            this.destItem = null;
        }
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public boolean isDropAllowed() {
        return false;
    }

    public boolean isClickAllowed() {
        return true;
    }

    public HistoryItem execute() {
        if (this.controller.warnBeforeDelete()) {
            int lastInstanceCount = 0;
            String instanceString = "";
            for (int i = 0; i < this.sources.length; ++i) {
                Link tr = (Link)this.sources[i].getLastPathComponent();
                LinkedObject parent = tr.getParent();
                LinkedObject child = tr.getChild();
                if (TermUtil.isObsolete(parent) || child.getParents().size() != 1) continue;
                ++lastInstanceCount;
                instanceString = instanceString + child.getName() + " (" + child.getID() + ")\n";
            }
            if (lastInstanceCount > 0 && JOptionPane.showConfirmDialog(Controller.getController().getFrame(), "These are the last appearances the following terms\n" + instanceString + "Are you sure you want to " + "permanently remove these terms from " + "the ontology?", "Delete warning", 0) != 0) {
                return null;
            }
        }
        HistoryItem item = null;
        Vector<HistoryItem> items = new Vector<HistoryItem>();
        Map temp = TermUtil.mallocMap();
        for (int i = 0; i < this.sources.length; ++i) {
            Link tr = (Link)this.sources[i].getLastPathComponent();
            Set trackedParents = (Set)temp.get(tr.getChild());
            if (trackedParents == null) {
                trackedParents = tr.getChild().getParents();
                if (trackedParents.size() == 0) {
                    items.add(new ObsoleteObjectHistoryItem(tr.getChild()));
                    continue;
                }
                temp.put(tr.getChild(), trackedParents);
            }
            items.add(new DeleteLinkHistoryItem(tr));
            trackedParents.remove(tr);
        }
        Iterator it = temp.keySet().iterator();
        while (it.hasNext()) {
            LinkedObject lo = (LinkedObject)it.next();
            Set parents = (Set)temp.get(lo);
            if (parents.size() != 0) continue;
            items.add(new ObsoleteObjectHistoryItem(lo));
        }
        TermUtil.freeMap(temp);
        if (items.size() > 1) {
            item = new TermMacroHistoryItem("Deleted multiple relationships");
            ((TermMacroHistoryItem)item).setSources(this.sources);
            for (int i = 0; i < items.size(); ++i) {
                ((TermMacroHistoryItem)item).addHistoryItem((HistoryItem)items.get(i));
            }
        } else {
            item = (HistoryItem)items.get(0);
        }
        item.setPreSelection(TermUtil.convertPathsToIDs(this.sources));
        item.setPostSelection(new TreePath[0]);
        return item;
    }
}

