/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.DeleteLinkHistoryItem;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.Controller;

public class RerootAction
implements ClickMenuAction {
    protected TreePath[] sources;
    protected boolean isLegal = false;
    protected Controller controller;

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public KeyStroke getKeyStroke() {
        return null;
    }

    public String getName() {
        return "Reroot";
    }

    public String getDesc() {
        return "Reroot";
    }

    public List getSubActions() {
        return null;
    }

    public void clickInit(TreePath[] sources, TreePath destItem) {
        this.isLegal = true;
        this.sources = sources;
        if (sources.length != 1) {
            this.isLegal = false;
            return;
        }
        Link tr = (Link)sources[0].getLastPathComponent();
        LinkedObject term = tr.getChild();
        if (term.isRoot()) {
            this.isLegal = false;
            return;
        }
        if (term.getParents().size() != 1) {
            this.isLegal = false;
            return;
        }
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public HistoryItem execute() {
        Link tr = (Link)this.sources[0].getLastPathComponent();
        LinkedObject term = tr.getChild();
        OBORestrictionImpl roottr = new OBORestrictionImpl(term);
        Object[] os = new Object[TermUtil.isProperty(term) ? 3 : 2];
        int index = 0;
        os[index++] = OBOSession.ROOT;
        if (TermUtil.isProperty(term)) {
            os[index++] = OBOSession.TYPES;
        }
        os[index++] = roottr;
        TreePath[] paths = new TreePath[]{new TreePath(os)};
        DeleteLinkHistoryItem item = new DeleteLinkHistoryItem(tr);
        item.setPreSelection(TermUtil.convertPathsToIDs(this.sources));
        item.setPostSelection(TermUtil.convertPathsToIDs(paths));
        return item;
    }
}

