/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.filters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geneontology.expression.JexlContext;
import org.geneontology.oboedit.gui.filters.CompoundFilter;
import org.geneontology.oboedit.gui.filters.Filter;

public class CompoundFilterImpl
implements CompoundFilter {
    private static final long serialVersionUID = -1115133463692494529L;
    protected List filters = new ArrayList();
    protected int booleanOperation = 0;
    protected JexlContext context;

    public CompoundFilterImpl() {
    }

    public CompoundFilterImpl(int booleanOperation) {
        this();
        this.setBooleanOperation(booleanOperation);
    }

    public boolean satisfies(Object o) {
        if (this.filters.size() == 0) {
            return true;
        }
        Iterator it = this.filters.iterator();
        while (it.hasNext()) {
            Filter f = (Filter)it.next();
            boolean result = f.satisfies(o);
            if (this.booleanOperation == 0 && !result) {
                return false;
            }
            if (this.booleanOperation != 1 || !result) continue;
            return true;
        }
        return this.booleanOperation == 0;
    }

    public void setContext(JexlContext context) {
        this.context = context;
        Iterator it = this.filters.iterator();
        while (it.hasNext()) {
            Filter f = (Filter)it.next();
            f.setContext(context);
        }
    }

    public void lock() {
        Iterator it = this.filters.iterator();
        while (it.hasNext()) {
            Filter f = (Filter)it.next();
            f.lock();
        }
    }

    public void clear() {
        this.filters.clear();
    }

    public Object clone() {
        CompoundFilterImpl out = new CompoundFilterImpl();
        out.booleanOperation = this.booleanOperation;
        Iterator it = this.filters.iterator();
        while (it.hasNext()) {
            Filter filter = (Filter)((Filter)it.next()).clone();
            filter.setContext(this.context);
            out.filters.add(filter);
        }
        return out;
    }

    public void addFilter(Filter f) {
        this.filters.add(f);
        f.setContext(this.context);
    }

    public void removeFilter(Filter f) {
        this.filters.remove(f);
    }

    public List getFilters() {
        return this.filters;
    }

    public void setFilters(List filters) {
        this.filters = filters;
    }

    public void setBooleanOperation(int booleanOperation) {
        if (booleanOperation != 0 && booleanOperation != 1) {
            throw new IllegalArgumentException("Only CompoundFilter.AND or CompoundFilter.OR are allowed as boolean operations");
        }
        this.booleanOperation = booleanOperation;
    }

    public int getBooleanOperation() {
        return this.booleanOperation;
    }

    public String toString() {
        String op = this.booleanOperation == 0 ? "AND" : (this.booleanOperation == 1 ? "OR" : "?");
        if (this.filters.size() == 0) {
            return op;
        }
        if (this.filters.size() == 1) {
            return this.filters.get(0).toString();
        }
        StringBuffer out = new StringBuffer();
        out.append(this.filters.get(0));
        for (int i = 1; i < this.filters.size(); ++i) {
            out.append(" ");
            out.append(op);
            out.append(" ");
            Filter f = (Filter)this.filters.get(i);
            if (f instanceof CompoundFilter) {
                out.append("(");
            }
            out.append(this.filters.get(i).toString());
            if (!(f instanceof CompoundFilter)) continue;
            out.append(")");
        }
        return out.toString();
    }
}

