/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.filters;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.geneontology.expression.ExpressionException;
import org.geneontology.expression.ExpressionUtil;
import org.geneontology.expression.JexlContext;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.filters.AllTextFieldsCriterion;
import org.geneontology.oboedit.gui.filters.BooleanCriterion;
import org.geneontology.oboedit.gui.filters.ContainsComparison;
import org.geneontology.oboedit.gui.filters.ObjectFilter;
import org.geneontology.oboedit.gui.filters.SearchAspect;
import org.geneontology.oboedit.gui.filters.SearchComparison;
import org.geneontology.oboedit.gui.filters.SearchCriterion;
import org.geneontology.oboedit.gui.filters.SelfSearchAspect;

public class ObjectFilterImpl
implements ObjectFilter {
    private static final long serialVersionUID = 1L;
    protected JexlContext context;
    protected boolean negate = false;
    protected SearchAspect aspect = new SelfSearchAspect();
    protected SearchCriterion criterion = new AllTextFieldsCriterion();
    protected SearchComparison comparison = new ContainsComparison();
    protected String value = "";
    public static long allocTime = 0L;

    public int hashCode() {
        return this.aspect.hashCode() + this.criterion.hashCode() + this.comparison.hashCode() + this.value.hashCode() + (this.negate ? 1 : 0);
    }

    public void setContext(JexlContext context) {
        this.context = context;
    }

    public void lock() {
        try {
            this.value = ExpressionUtil.resolveBacktickExpression((String)this.value, (JexlContext)this.context);
        }
        catch (ExpressionException ex) {
            ex.printStackTrace();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ObjectFilter) {
            ObjectFilter filter = (ObjectFilter)o;
            return filter.getAspect().getClass().equals(this.aspect.getClass()) && filter.getCriterion().getClass().equals(this.criterion.getClass()) && filter.getComparison().getClass().equals(this.comparison.getClass()) && filter.getValue().equals(this.value);
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean satisfies(Object object) {
        if (!this.criterion.getInputType().isAssignableFrom(object.getClass())) {
            return false;
        }
        String matchVal = this.value;
        try {
            matchVal = ExpressionUtil.resolveBacktickExpression((String)this.value, (JexlContext)this.context);
        }
        catch (ExpressionException e) {
            // empty catch block
        }
        List os = TermUtil.mallocList();
        this.aspect.getObjects(os, object);
        boolean matches = this.negate;
        Iterator it = os.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (this.criterion instanceof BooleanCriterion) {
                if (!((BooleanCriterion)this.criterion).matches(o)) continue;
                matches = !this.negate;
                break;
            }
            List c = TermUtil.mallocList();
            boolean b = false;
            try {
                Collection values = this.criterion.getValues(c, o);
                b = this.comparison.matches(values, matchVal);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            TermUtil.freeList(c);
            if (!b) continue;
            matches = !this.negate;
            break;
        }
        TermUtil.freeList(os);
        return matches;
    }

    public String toString() {
        if (this.criterion instanceof BooleanCriterion) {
            return (this.negate ? "NOT " : "") + (this.aspect instanceof SelfSearchAspect ? "" : this.aspect.toString() + " ") + this.criterion;
        }
        return (this.negate ? "NOT " : "") + (this.aspect instanceof SelfSearchAspect ? "" : this.aspect.toString() + " ") + this.criterion + " " + this.comparison + " \"" + this.value + "\"";
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SearchComparison getComparison() {
        return this.comparison;
    }

    public void setComparison(SearchComparison comparison) {
        this.comparison = comparison;
    }

    public SearchAspect getAspect() {
        return this.aspect;
    }

    public void setAspect(SearchAspect aspect) {
        this.aspect = aspect;
    }

    public SearchCriterion getCriterion() {
        return this.criterion;
    }

    public void setCriterion(SearchCriterion criterion) {
        this.criterion = criterion;
    }

    public boolean getNegate() {
        return this.negate;
    }

    public void setNegate(boolean negate) {
        this.negate = negate;
    }
}

