/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.filters;

import java.awt.Color;
import org.geneontology.oboedit.gui.filters.RenderSpec;

public class ObjectRenderSpec
implements RenderSpec {
    protected Color foregroundColor;
    protected String fontName;
    protected int fontSize;
    protected boolean isBold;
    protected boolean isItalic;
    protected boolean isUnderlined;

    public ObjectRenderSpec() {
        this.clear();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void clear() {
        this.foregroundColor = null;
        this.fontName = null;
        this.fontSize = -1;
        this.isBold = false;
        this.isItalic = false;
        this.isUnderlined = false;
    }

    public void setUnderlined(boolean isUnderlined) {
        this.isUnderlined = isUnderlined;
    }

    public boolean getUnderlined() {
        return this.isUnderlined;
    }

    public boolean getItalic() {
        return this.isItalic;
    }

    public void setItalic(boolean isItalic) {
        this.isItalic = isItalic;
    }

    public boolean getBold() {
        return this.isBold;
    }

    public void setBold(boolean isBold) {
        this.isBold = isBold;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public String toString() {
        String out = "";
        if (this.foregroundColor != null) {
            out = out + "foreground = " + this.foregroundColor;
        }
        if (this.fontName != null) {
            if (!out.equals("")) {
                out = out + ", ";
            }
            out = out + "font = " + this.fontName;
        }
        if (this.fontSize >= 0) {
            if (!out.equals("")) {
                out = out + ", ";
            }
            out = out + "font size = " + this.fontSize;
        }
        if (this.isUnderlined) {
            if (!out.equals("")) {
                out = out + ", ";
            }
            out = out + "underline";
        }
        if (this.isItalic) {
            if (!out.equals("")) {
                out = out + ", ";
            }
            out = out + "italic";
        }
        if (this.isBold) {
            if (!out.equals("")) {
                out = out + ", ";
            }
            out = out + "bold";
        }
        return out;
    }

    public void merge(RenderSpec s) {
        if (s == null) {
            return;
        }
        if (!(s instanceof ObjectRenderSpec)) {
            throw new IllegalArgumentException();
        }
        ObjectRenderSpec spec = (ObjectRenderSpec)s;
        if (!this.getUnderlined()) {
            this.setUnderlined(spec.getUnderlined());
        }
        if (!this.getBold()) {
            this.setBold(spec.getBold());
        }
        if (!this.getItalic()) {
            this.setItalic(spec.getItalic());
        }
        if (this.getFontSize() < 0) {
            this.setFontSize(spec.getFontSize());
        }
        if (this.getFontName() == null) {
            this.setFontName(spec.getFontName());
        }
        if (this.getForegroundColor() == null) {
            this.setForegroundColor(spec.getForegroundColor());
        }
    }
}

