/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.TermCategory;
import org.geneontology.oboedit.datamodel.history.TermCategoryHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.event.RefreshEvent;
import org.geneontology.oboedit.gui.event.RefreshListener;
import org.geneontology.oboedit.gui.event.RootChangeEvent;
import org.geneontology.oboedit.gui.event.RootChangeListener;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;

public class CategoryManagerPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 1L;
    protected ListEditor catList;
    protected JLabel noCategoryLabel = new JLabel("Click a category to edit it.");
    protected JButton commitButton = new JButton("Save Changes");
    protected JButton revertButton = new JButton("Revert");
    protected RefreshListener reloadListener = new RefreshListener(){

        public void reload(RefreshEvent e) {
            CategoryManagerPlugin.this.loadCategories();
        }
    };
    protected RootChangeListener rootListener = new RootChangeListener(){

        public void changeRoot(RootChangeEvent e) {
            CategoryManagerPlugin.this.loadCategories();
        }
    };

    public CategoryManagerPlugin() {
        this.commitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CategoryManagerPlugin.this.saveCategories();
            }
        });
        this.revertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CategoryManagerPlugin.this.loadCategories();
            }
        });
    }

    public String getName() {
        return "Category Manager Plugin";
    }

    public void init() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setPreferredSize(new Dimension(400, 300));
        this.catList = new ListEditor((GenericEditorComponent)new CategoryEditor(), (Component)this.noCategoryLabel, new Vector(), true, true, true, true, false);
        Box commitBox = new Box(0);
        commitBox.add(Box.createHorizontalGlue());
        commitBox.add(this.commitButton);
        commitBox.add(Box.createHorizontalStrut(10));
        commitBox.add(this.revertButton);
        commitBox.add(Box.createHorizontalGlue());
        this.commitButton.setFont(this.controller.getDefaultFont());
        this.revertButton.setFont(this.controller.getDefaultFont());
        this.noCategoryLabel.setFont(this.controller.getDefaultFont());
        this.removeAll();
        this.add((Component)this.catList);
        this.add(commitBox);
        this.validate();
        this.catList.setFont(this.controller.getDefaultFont());
        this.controller.addListener(this.reloadListener);
        this.controller.addListener(this.rootListener);
        this.loadCategories();
    }

    public void cleanup() {
        this.controller.removeListener(this.reloadListener);
        this.controller.removeListener(this.rootListener);
    }

    protected void loadCategories() {
        new Exception("Called loadCategories()").printStackTrace();
        Vector<CategoryWrapper> v = new Vector<CategoryWrapper>();
        Iterator it = this.controller.getSession().getCategories().iterator();
        while (it.hasNext()) {
            TermCategory cat = (TermCategory)it.next();
            Iterator it2 = this.controller.getSession().getTerms().iterator();
            boolean inUse = false;
            while (it2.hasNext()) {
                OBOClass term = (OBOClass)it2.next();
                if (!term.getCategories().contains(cat)) continue;
                inUse = true;
                break;
            }
            v.add(new CategoryWrapper(cat));
        }
        this.catList.setData(v);
    }

    protected void saveCategories() {
        int i;
        new Exception("Called saveCategories()").printStackTrace();
        HashSet<TermCategory> v = new HashSet<TermCategory>();
        Vector data = this.catList.getData();
        HashSet<String> names = new HashSet<String>();
        for (int i2 = 0; i2 < data.size(); ++i2) {
            CategoryWrapper rtw = (CategoryWrapper)data.get(i2);
            if (names.contains(rtw.getName())) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Could not commit changes because multiple categories are using the name " + rtw.getName());
                return;
            }
            v.add(rtw.getCategory());
            names.add(rtw.getName());
        }
        Iterator it = this.controller.getSession().getTerms().iterator();
        while (it.hasNext()) {
            OBOClass term = (OBOClass)it.next();
            Iterator it2 = term.getCategories().iterator();
            while (it2.hasNext()) {
                TermCategory cat = (TermCategory)it2.next();
                if (v.contains(cat)) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), "Could not commit changes because " + cat + " " + "is still in use in the " + "ontology");
                return;
            }
        }
        Vector oldcats = new Vector(this.controller.getSession().getCategories());
        TermMacroHistoryItem item = new TermMacroHistoryItem("Category edits");
        Vector newcats = (Vector)data.clone();
        for (i = 0; i < oldcats.size(); ++i) {
            TermCategory cat = (TermCategory)oldcats.get(i);
            boolean found = false;
            for (int j = 0; j < data.size(); ++j) {
                CategoryWrapper tw = (CategoryWrapper)data.get(j);
                if (tw.getCategory() != cat) continue;
                newcats.remove(tw);
                if (tw.isChanged()) {
                    TermCategory tc = this.controller.getSession().getObjectFactory().createCategory("NEWCAT", "<new term category>");
                    TermCategoryHistoryItem catitem = new TermCategoryHistoryItem(tw.getCategory(), tc, false, false);
                    item.addHistoryItem(catitem);
                }
                found = true;
                break;
            }
            if (found) continue;
            TermCategoryHistoryItem catitem = new TermCategoryHistoryItem(cat, null, false, true);
            item.addHistoryItem(catitem);
        }
        for (i = 0; i < newcats.size(); ++i) {
            CategoryWrapper cw = (CategoryWrapper)newcats.get(i);
            TermCategoryHistoryItem catitem = new TermCategoryHistoryItem(null, this.controller.getSession().getObjectFactory().createCategory(cw.getName(), cw.getDesc()), true, false);
            item.addHistoryItem(catitem);
        }
        item.setPreSelection(this.controller.getSelectedPaths());
        item.setPostSelection(this.controller.getSelectedPaths());
        this.controller.apply(item);
    }

    protected static class CategoryWrapper {
        protected String name;
        protected String desc;
        protected TermCategory oldcat;

        public CategoryWrapper(TermCategory cat) {
            this.name = cat.getName();
            this.desc = cat.getDesc();
            this.oldcat = cat;
        }

        public boolean isChanged() {
            return !this.oldcat.getName().equals(this.name) || !this.oldcat.getDesc().equals(this.desc);
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public TermCategory getCategory() {
            return this.oldcat;
        }

        public String toString() {
            return this.desc + " (" + this.name + ")";
        }
    }

    private class CategoryEditor
    extends JPanel
    implements GenericEditorComponent {
        private static final long serialVersionUID = 1L;
        private JTextField nameField;
        private JTextField descField;
        protected ListEditor editor;

        public void setMasterComponent(Component c) {
            if (c instanceof ListEditor) {
                this.editor = (ListEditor)c;
            }
        }

        public CategoryEditor() {
            JLabel nameLabel = new JLabel("Category name");
            JLabel descLabel = new JLabel("Category description");
            FocusListener listener = new FocusListener(){

                public void focusLost(FocusEvent e) {
                    ((CategoryEditor)CategoryEditor.this).CategoryManagerPlugin.this.catList.commit();
                }

                public void focusGained(FocusEvent e) {
                }
            };
            this.nameField = new JTextField(10);
            this.descField = new JTextField();
            this.nameField.addFocusListener(listener);
            this.descField.addFocusListener(listener);
            this.nameField.setFont(CategoryManagerPlugin.this.controller.getDefaultFont());
            nameLabel.setFont(CategoryManagerPlugin.this.controller.getDefaultFont());
            descLabel.setFont(CategoryManagerPlugin.this.controller.getDefaultFont());
            this.descField.setFont(CategoryManagerPlugin.this.controller.getDefaultFont());
            this.setLayout(new BoxLayout(this, 1));
            this.add(nameLabel);
            this.add(this.nameField);
            this.add(Box.createVerticalStrut(10));
            this.add(descLabel);
            this.add(this.descField);
            this.add(Box.createVerticalGlue());
        }

        public void load(Object o) {
            CategoryWrapper rtw = (CategoryWrapper)o;
            this.nameField.setText(rtw.getName());
            this.descField.setText(rtw.getDesc());
        }

        public void store(Object o) {
            CategoryWrapper rtw = (CategoryWrapper)o;
            rtw.setName(this.nameField.getText());
            rtw.setDesc(this.descField.getText());
        }

        public Object createNewValue() {
            return new CategoryWrapper(CategoryManagerPlugin.this.controller.getSession().getObjectFactory().createCategory("NEWCAT", "<new term category>"));
        }
    }
}

