/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.ComponentConfiguration;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.event.SelectionEvent;
import org.geneontology.oboedit.gui.event.SelectionListener;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;
import org.geneontology.swing.widget.FontChooser;

public class GraphPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 1L;
    protected static final String BACKGROUND_COLOR = "Background color";
    protected static final String TERM_BACKGROUND_COLOR = "Term background color";
    protected static final String TERM_TEXT_COLOR = "Term text color";
    protected static final String TERM_STROKE_COLOR = "Term stroke color";
    protected static final String TYPE_STROKE_COLOR = "Type stroke color";
    protected static final String TYPE_BACKGROUND_COLOR = "Type background color";
    protected static final String TYPE_TEXT_COLOR = "Type text color";
    protected static final String OBSOLETE_STROKE_COLOR = "Obsolete stroke color";
    protected static final String OBSOLETE_BACKGROUND_COLOR = "Obsolete background color";
    protected static final String OBSOLETE_TEXT_COLOR = "Obsolete text color";
    protected static final String SELECTED_ONLY = "selected only";
    protected static final String SELECTED_TO_ROOT = "selected to root";
    protected static final String MINIMAL_SELECTION_GRAPH = "minimal connected graph";
    protected static final int MAX_LINE_LENGTH = 25;
    protected GraphConfiguration graphConfiguration = new GraphConfiguration();
    protected float ranksep = 0.1f;
    protected float nodesep = 0.1f;
    protected Object[] modes = new Object[]{"selected only", "selected to root", "minimal connected graph"};
    protected JComboBox modeList = new JComboBox<Object>(this.modes);
    protected Object[] shapeArr = new Object[]{"box", "ellipse", "egg", "triangle", "diamond", "parallelogram", "house", "pentagon", "hexagon", "septagon", "octagon", "invtriangle"};
    protected JComboBox nodeShapeList = new JComboBox<Object>(this.shapeArr);
    protected JComboBox typeShapeList = new JComboBox<Object>(this.shapeArr);
    protected JComboBox obsoleteShapeList = new JComboBox<Object>(this.shapeArr);
    protected JCheckBox flipoverBox = new JCheckBox("Draw graph with root on top");
    protected JCheckBox showIDsBox = new JCheckBox("Show ids");
    protected static final ColorPair defaultLabelColors = new ColorPair(Color.blue, Color.blue);
    protected static final ColorPair defaultRedundantColors = new ColorPair(Color.red, Color.red);
    protected static final String[] formatList = new String[]{"jpg", "gif"};
    JComboBox formatBox = new JComboBox<String>(formatList);
    protected JTabbedPane optionsPane = new JTabbedPane();
    protected LinkDatabase linkDatabase;
    LinkListener linkListener = new LinkListener();
    protected SelectionListener selectionListener = new SelectionListener(){

        public void select(SelectionEvent e) {
            GraphPlugin.this.reloadImage();
        }
    };
    static int idgen = 0;
    JPanel imagePanel = new JPanel();
    JLabel imageLabel = new JLabel();
    JEditorPane htmlPane = new JEditorPane();
    JScrollPane pane = new JScrollPane(this.htmlPane, 20, 30);
    JButton optionButton = new JButton("Options");
    JButton saveButton = new JButton("Save");
    protected String mode = "selected to root";
    public JCheckBox primaryFiltersCheckbox = new JCheckBox("Use primary filters", false);

    public String getName() {
        return "Graph Viewer";
    }

    public GraphPlugin() {
        this.formatBox.setBackground(Preferences.defaultButtonColor());
        this.imagePanel.setLayout(new BorderLayout());
        this.imagePanel.add((Component)this.imageLabel, "Center");
        this.setLayout(new BorderLayout());
        this.htmlPane.setContentType("text/html");
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(this.linkListener);
        this.optionButton.setBackground(Preferences.defaultButtonColor());
        this.saveButton.setBackground(Preferences.defaultButtonColor());
        Box buttonBox = new Box(0);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(this.optionButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.modeList);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.primaryFiltersCheckbox);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.saveButton);
        buttonBox.add(Box.createHorizontalGlue());
        this.add(buttonBox, "South");
        this.add(this.pane, "Center");
        this.primaryFiltersCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphPlugin.this.setDoFiltering(GraphPlugin.this.primaryFiltersCheckbox.isSelected());
            }
        });
        this.modeList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphPlugin.this.mode = (String)GraphPlugin.this.modeList.getSelectedItem();
                GraphPlugin.this.reloadImage();
            }
        });
        this.optionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphPlugin.this.showOptions();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphPlugin.this.storeImage();
            }
        });
    }

    protected void setDoFiltering(boolean doFiltering) {
        this.graphConfiguration.setDoFiltering(doFiltering);
        this.primaryFiltersCheckbox.setSelected(doFiltering);
        this.linkDatabase = !doFiltering ? Controller.getController().getSession().getLinkDatabase() : Controller.getController().getPrimarySelector().getLinkDatabase();
        this.reloadImage();
    }

    protected String getColorString(Color color) {
        float[] floats = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return floats[0] + " " + floats[1] + " " + floats[2];
    }

    protected void showOptions() {
        JPanel panel = new JPanel();
        panel.setBackground(Preferences.defaultBackgroundColor());
        panel.setLayout(new BorderLayout());
        final FontChooser linkFontChooser = new FontChooser();
        final FontChooser nodeFontChooser = new FontChooser();
        JButton commitButton = new JButton("Save Options");
        final JTextField appPathField = new JTextField(this.graphConfiguration.getDotPath());
        commitButton.setBackground(Preferences.defaultButtonColor());
        commitButton.setFont(this.controller.getDefaultFont());
        linkFontChooser.setFont(this.controller.getDefaultFont());
        nodeFontChooser.setFont(this.controller.getDefaultFont());
        linkFontChooser.setChosenFont(this.graphConfiguration.getLabelFont());
        nodeFontChooser.setChosenFont(this.graphConfiguration.getNodeFont());
        this.nodeShapeList.setSelectedItem(this.graphConfiguration.getNodeShape());
        this.typeShapeList.setSelectedItem(this.graphConfiguration.getTypeShape());
        this.obsoleteShapeList.setSelectedItem(this.graphConfiguration.getObsoleteShape());
        this.flipoverBox.setSelected(this.graphConfiguration.getFlipOver());
        this.showIDsBox.setSelected(this.graphConfiguration.getShowIDs());
        this.formatBox.setSelectedItem(this.graphConfiguration.getViewerFormat());
        TitledBorder linkFontBorder = new TitledBorder("Relationship type font");
        TitledBorder nodeFontBorder = new TitledBorder("Term name font");
        linkFontChooser.setBorder((Border)linkFontBorder);
        nodeFontChooser.setBorder((Border)nodeFontBorder);
        linkFontChooser.setOpaque(false);
        nodeFontChooser.setOpaque(false);
        JLabel noTypeLabel = new JLabel("no type selected");
        Vector data = this.graphConfiguration.getNamedColorList();
        final ListEditor typeColorList = new ListEditor((GenericEditorComponent)new ColorEditor(), (Component)noTypeLabel, new Vector(), true, true, false, true, false);
        typeColorList.setData(data);
        typeColorList.setVectorEditable(false);
        JPanel fontPanel = new JPanel();
        fontPanel.setOpaque(false);
        fontPanel.setLayout(new BoxLayout(fontPanel, 1));
        fontPanel.add((Component)linkFontChooser);
        fontPanel.add((Component)nodeFontChooser);
        JPanel outerFontPanel = new JPanel();
        outerFontPanel.setBackground(Preferences.defaultBackgroundColor());
        outerFontPanel.setLayout(new BorderLayout());
        outerFontPanel.add((Component)fontPanel, "North");
        JPanel shapePanel = new JPanel();
        shapePanel.setBackground(Preferences.defaultBackgroundColor());
        shapePanel.setLayout(new BoxLayout(shapePanel, 1));
        TitledBorder nodeBorder = new TitledBorder("Term shape");
        TitledBorder obsoleteBorder = new TitledBorder("Obsolete shape");
        TitledBorder typeBorder = new TitledBorder("Type shape");
        nodeBorder.setTitleFont(this.controller.getDefaultFont());
        obsoleteBorder.setTitleFont(this.controller.getDefaultFont());
        typeBorder.setTitleFont(this.controller.getDefaultFont());
        JPanel nodeShapePanel = new JPanel();
        nodeShapePanel.setOpaque(false);
        nodeShapePanel.setLayout(new BorderLayout());
        nodeShapePanel.add((Component)this.nodeShapeList, "Center");
        this.nodeShapeList.setBackground(Preferences.defaultButtonColor());
        nodeShapePanel.setBorder(nodeBorder);
        JPanel obsoleteShapePanel = new JPanel();
        obsoleteShapePanel.setOpaque(false);
        obsoleteShapePanel.setLayout(new BorderLayout());
        obsoleteShapePanel.add((Component)this.obsoleteShapeList, "Center");
        this.obsoleteShapeList.setBackground(Preferences.defaultButtonColor());
        obsoleteShapePanel.setBorder(obsoleteBorder);
        JPanel typeShapePanel = new JPanel();
        typeShapePanel.setOpaque(false);
        typeShapePanel.setLayout(new BorderLayout());
        typeShapePanel.add((Component)this.typeShapeList, "Center");
        this.typeShapeList.setBackground(Preferences.defaultButtonColor());
        typeShapePanel.setBorder(typeBorder);
        this.nodeShapeList.setFont(this.controller.getDefaultFont());
        this.typeShapeList.setFont(this.controller.getDefaultFont());
        this.obsoleteShapeList.setFont(this.controller.getDefaultFont());
        shapePanel.add(nodeShapePanel);
        shapePanel.add(Box.createVerticalStrut(5));
        shapePanel.add(obsoleteShapePanel);
        shapePanel.add(Box.createVerticalStrut(5));
        shapePanel.add(typeShapePanel);
        JTextArea messageArea = new JTextArea("This should contain the path to the \"dot\" or \"dot.exe\" file included with the GraphViz software package. The package can be obtained from http://www.research.att.com/sw/tools/graphviz/download.html", 3, 20);
        messageArea.setEditable(false);
        messageArea.setBorder(null);
        messageArea.setOpaque(false);
        messageArea.setLineWrap(true);
        messageArea.setWrapStyleWord(true);
        JButton browseButton = new JButton("Browse...");
        browseButton.setFont(this.controller.getDefaultFont());
        browseButton.setBackground(Preferences.defaultButtonColor());
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showOpenDialog((Component)((Object)GraphPlugin.this)) == 0) {
                    File file = chooser.getSelectedFile();
                    File macPath = new File(file, "Contents/MacOS/dot");
                    if (!file.getName().equals("dot") && file.isDirectory() && macPath.exists()) {
                        appPathField.setText(macPath.toString());
                    } else {
                        appPathField.setText(file.toString());
                    }
                }
            }
        });
        JPanel outerShapePanel = new JPanel();
        outerShapePanel.setBackground(Preferences.defaultBackgroundColor());
        outerShapePanel.setLayout(new BorderLayout());
        outerShapePanel.add((Component)shapePanel, "North");
        JLabel appLabel = new JLabel("Application path");
        appLabel.setFont(this.controller.getDefaultFont());
        Box horzBox = new Box(0);
        horzBox.add(Box.createHorizontalStrut(5));
        horzBox.add(appPathField);
        horzBox.add(Box.createHorizontalStrut(5));
        JPanel appLine = new JPanel();
        appLine.setLayout(new BorderLayout());
        appLine.add((Component)appLabel, "West");
        appLine.add((Component)horzBox, "Center");
        appLine.add((Component)browseButton, "East");
        appLine.setOpaque(false);
        this.flipoverBox.setOpaque(false);
        this.showIDsBox.setOpaque(false);
        JLabel formatLabel = new JLabel("Default display format");
        formatLabel.setFont(this.controller.getDefaultFont());
        JPanel viewerFormatLine = new JPanel();
        viewerFormatLine.setOpaque(false);
        viewerFormatLine.setLayout(new BorderLayout());
        viewerFormatLine.add((Component)formatLabel, "West");
        viewerFormatLine.add(Box.createHorizontalStrut(5));
        viewerFormatLine.add(this.formatBox);
        JPanel appPanel = new JPanel();
        appPanel.setBackground(Preferences.defaultBackgroundColor());
        appPanel.setLayout(new BoxLayout(appPanel, 1));
        appPanel.add(Box.createVerticalStrut(10));
        appPanel.add(viewerFormatLine);
        appPanel.add(Box.createVerticalStrut(10));
        appPanel.add(this.flipoverBox);
        appPanel.add(Box.createVerticalStrut(10));
        appPanel.add(this.showIDsBox);
        appPanel.add(Box.createVerticalStrut(10));
        appPanel.add(appLine);
        appPanel.add(Box.createVerticalStrut(10));
        appPanel.add(messageArea);
        JPanel outerAppPanel = new JPanel();
        outerAppPanel.setBackground(Preferences.defaultBackgroundColor());
        outerAppPanel.setLayout(new BorderLayout());
        outerAppPanel.add((Component)appPanel, "North");
        this.optionsPane.removeAll();
        this.optionsPane.addTab("Fonts", outerFontPanel);
        this.optionsPane.addTab("Colors", (Component)typeColorList);
        this.optionsPane.addTab("Shapes", outerShapePanel);
        this.optionsPane.addTab("Behavior", outerAppPanel);
        panel.add((Component)this.optionsPane, "Center");
        panel.add((Component)commitButton, "South");
        final JDialog pane = new JDialog((Frame)null, true);
        pane.setContentPane(panel);
        commitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                pane.setVisible(false);
                GraphPlugin.this.graphConfiguration.setDotPath(appPathField.getText());
                GraphPlugin.this.graphConfiguration.setLabelFont(linkFontChooser.getChosenFont());
                GraphPlugin.this.graphConfiguration.setNodeFont(nodeFontChooser.getChosenFont());
                GraphPlugin.this.graphConfiguration.setTypeShape((String)GraphPlugin.this.typeShapeList.getSelectedItem());
                GraphPlugin.this.graphConfiguration.setNodeShape((String)GraphPlugin.this.nodeShapeList.getSelectedItem());
                GraphPlugin.this.graphConfiguration.setObsoleteShape((String)GraphPlugin.this.obsoleteShapeList.getSelectedItem());
                GraphPlugin.this.graphConfiguration.setFlipOver(GraphPlugin.this.flipoverBox.isSelected());
                GraphPlugin.this.graphConfiguration.setShowIDs(GraphPlugin.this.showIDsBox.isSelected());
                for (int i = 0; i < typeColorList.getData().size(); ++i) {
                    Object o = typeColorList.getData().get(i);
                    if (o instanceof TypeColorPair) {
                        TypeColorPair tc = (TypeColorPair)o;
                        GraphPlugin.this.graphConfiguration.getColorMap().put(tc.getTypeID(), tc.getPair());
                        continue;
                    }
                    if (!(o instanceof NamedColor)) continue;
                    NamedColor nc = (NamedColor)o;
                    GraphPlugin.this.graphConfiguration.setNamedColor(nc.getName(), nc.getColor());
                }
                GraphPlugin.this.graphConfiguration.setViewerFormat((String)GraphPlugin.this.formatBox.getSelectedItem());
                pane.dispose();
                GraphPlugin.this.reloadImage();
            }
        });
        pane.pack();
        pane.setSize(600, 400);
        pane.show();
    }

    protected void storeImage() {
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.addChoosableFileFilter(new ExtensionFilter(".jpg", ".jpg - JPEG Format"));
            chooser.addChoosableFileFilter(new ExtensionFilter(".png", ".png - PNG Format"));
            chooser.addChoosableFileFilter(new ExtensionFilter(".ps", ".ps - Postscript Format"));
            chooser.addChoosableFileFilter(new ExtensionFilter(".dot", ".dot - GraphViz DOT Format"));
            chooser.addChoosableFileFilter(new ExtensionFilter(".xdot", ".xdot - GraphViz extended DOT format"));
            chooser.addChoosableFileFilter(new ExtensionFilter(".gif", ".gif - GIF Format"));
            if (chooser.showSaveDialog((Component)((Object)this)) == 0) {
                File textFile = File.createTempFile("graphtext", ".txt");
                this.outputFile(textFile);
                ExtensionFilter ef = (ExtensionFilter)chooser.getFileFilter();
                String outputFile = chooser.getSelectedFile().getPath();
                if (!outputFile.endsWith(ef.getExt())) {
                    outputFile = outputFile + ef.getExt();
                }
                Process p = Runtime.getRuntime().exec(this.graphConfiguration.getDotPath() + " -T" + ef.getExtNoDot() + " -o " + outputFile + " " + textFile.getPath());
                p.waitFor();
                textFile.delete();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void reloadImage() {
        try {
            String line;
            File imageFile = File.createTempFile("graphimage", "." + this.graphConfiguration.getViewerFormat());
            File textFile = File.createTempFile("graphtext", ".txt");
            this.outputFile(textFile);
            Process p = Runtime.getRuntime().exec(this.graphConfiguration.getDotPath() + " -T" + this.graphConfiguration.getViewerFormat() + " -o " + imageFile.getPath() + " " + textFile.getPath());
            p.waitFor();
            p = Runtime.getRuntime().exec(this.graphConfiguration.getDotPath() + " -Tcmapx " + textFile.getPath());
            StringBuffer buffer = new StringBuffer();
            buffer.append("<html>\n");
            buffer.append("<head>\n");
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (line.endsWith(" />")) {
                    line = line.substring(0, line.length() - 3) + ">";
                }
                buffer.append(line + "\n");
            }
            p.waitFor();
            this.htmlPane.setBackground(this.graphConfiguration.getBGColor());
            buffer.append("</head>\n");
            buffer.append("<body>\n");
            buffer.append("<img src='file:" + imageFile + "' usemap='#G'>\n");
            buffer.append("</body>\n");
            buffer.append("</html>\n");
            this.htmlPane.setText(buffer.toString());
            imageFile.deleteOnExit();
            textFile.deleteOnExit();
        }
        catch (Exception ex) {
            String failureHTML = "<html><center>Could not load GraphViz package.<br>Make sure your properly obtained and installed GraphViz from<br><b>http://www.research.att.com/sw/tools/graphviz/download.html</b><br>and be sure that the correct path to the executable file<br>is specified in the options window.</center></html>";
            this.imageLabel.setIcon(null);
            this.imageLabel.setText(failureHTML);
            ex.printStackTrace();
        }
    }

    protected ColorPair getColor(Link tr) {
        ColorPair c = (ColorPair)this.graphConfiguration.getColorMap().get(tr.getType().getID());
        if (c == null) {
            c = defaultLabelColors;
        }
        if (TermUtil.isRedundant(tr)) {
            c = defaultRedundantColors;
        }
        return c;
    }

    protected String getShape(OBOClass t) {
        if (t.isObsolete()) {
            return this.graphConfiguration.getObsoleteShape();
        }
        if (TermUtil.isProperty(t)) {
            return this.graphConfiguration.getTypeShape();
        }
        return this.graphConfiguration.getNodeShape();
    }

    protected String getOptions(OBOClass t) {
        Color fontColor = this.graphConfiguration.getTermFontColor();
        if (t.isObsolete()) {
            fontColor = this.graphConfiguration.getObsoleteFontColor();
        } else if (TermUtil.isProperty(t)) {
            fontColor = this.graphConfiguration.getTypeFontColor();
        }
        Color strokeColor = this.graphConfiguration.getTermStrokeColor();
        if (t.isObsolete()) {
            strokeColor = this.graphConfiguration.getObsoleteStrokeColor();
        } else if (TermUtil.isProperty(t)) {
            strokeColor = this.graphConfiguration.getTypeStrokeColor();
        }
        String s = "label=\"" + this.formatLabel(t.getName()) + (this.graphConfiguration.getShowIDs() ? "\\n\\n" + t.getID() : "") + "\", " + "shape=" + this.getShape(t) + ", fontsize=" + this.graphConfiguration.getNodeFont().getSize() + ", " + "fontname=\"" + this.graphConfiguration.getNodeFont().getFontName() + "\", " + "fillcolor=\"" + this.getColorString(this.graphConfiguration.getTermBoxColor()) + "\"" + ", color=\"" + this.getColorString(strokeColor) + "\"" + ", fontcolor=\"" + this.getColorString(fontColor) + "\", " + "style=filled, URL=\"file:" + t.getID() + "\"";
        return s;
    }

    protected String getOptions(Link tr) {
        return "label=\"" + this.formatLabel(tr.getType().getName()) + "\", " + "dir=" + (this.graphConfiguration.getFlipOver() ? "back" : "forward") + ", " + (TermUtil.isImplied(tr) ? "style=dotted," : "") + "fontsize=" + this.graphConfiguration.getLabelFont().getSize() + ", fontname=\"" + this.graphConfiguration.getLabelFont().getFontName() + "\", " + "color=\"" + this.getColorString(this.getColor((Link)tr).edge) + "\", " + "fontcolor=\"" + this.getColorString(this.getColor((Link)tr).label) + "\"";
    }

    protected String formatLabel(String name) {
        StringBuffer out = new StringBuffer();
        String spacerTokens = "-_, \t";
        StringTokenizer tokenizer = new StringTokenizer(name, spacerTokens, true);
        int linelength = 0;
        boolean first = true;
        while (tokenizer.hasMoreElements()) {
            String str = (String)tokenizer.nextElement();
            out.append(str);
            if (!first && spacerTokens.indexOf(str) != -1 && (linelength += str.length()) + str.length() > 25) {
                out.append("\\n");
                linelength = 0;
            }
            first = false;
        }
        return out.toString();
    }

    protected String convertID(String id) {
        return id.replace(':', '_');
    }

    protected void populateSet(Set relationshipSet) {
        if (this.mode.equals(SELECTED_ONLY)) {
            this.populateSelectedOnly(relationshipSet);
        } else if (this.mode.equals(SELECTED_TO_ROOT)) {
            this.populateSelectedToRoot(relationshipSet);
        } else if (this.mode.equals(MINIMAL_SELECTION_GRAPH)) {
            this.populateMinimalSelectionGraph(relationshipSet);
        }
    }

    protected void populateMinimalSelectionGraph(Set set) {
        this.populateSelectedToRoot(set);
        this.trimSet(set);
    }

    protected void trimSet(Set set) {
        HashSet<LinkedObject> roots = new HashSet<LinkedObject>();
        HashSet trash = new HashSet();
        HashSet<Link> inUse = new HashSet<Link>();
        do {
            Iterator it2;
            Iterator it = set.iterator();
            roots.clear();
            trash.clear();
            while (it.hasNext()) {
                Link tr = (Link)it.next();
                it2 = set.iterator();
                boolean found = false;
                while (it2.hasNext()) {
                    Link tr2 = (Link)it2.next();
                    if (tr.getParent() == null || !tr.getParent().equals(tr2.getChild())) continue;
                    found = true;
                    break;
                }
                if (found || tr.getParent() == null) continue;
                roots.add(tr.getParent());
            }
            it = roots.iterator();
            while (it.hasNext()) {
                OBOClass root = (OBOClass)it.next();
                it2 = set.iterator();
                inUse.clear();
                while (it2.hasNext()) {
                    Link tr2 = (Link)it2.next();
                    if (tr2.getParent() == null || !tr2.getParent().equals(root) || this.controller.getSelectedTerms().contains(tr2)) continue;
                    inUse.add(tr2);
                }
                if (inUse.size() >= 2) continue;
                trash.addAll(inUse);
            }
            set.removeAll(trash);
        } while (trash.size() > 0);
    }

    protected void populateSelectedToRoot(Set set) {
        Iterator it = this.controller.getSelectedTerms().iterator();
        HashSet lookedAt = new HashSet();
        while (it.hasNext()) {
            Object o = it.next();
            Link tr = (Link)o;
            if (TermUtil.containsLink(this.linkDatabase, tr)) {
                set.add(tr);
            }
            LinkedObject t = tr.getChild();
            this.populateSelectedToRoot(set, t, lookedAt);
        }
    }

    protected void populateSelectedToRoot(Set set, LinkedObject term, HashSet lookedAt) {
        if (lookedAt.contains(term)) {
            return;
        }
        lookedAt.add(term);
        Iterator it = this.linkDatabase.getParents(term).iterator();
        while (it.hasNext()) {
            Link tr = (Link)it.next();
            set.add(tr);
            this.populateSelectedToRoot(set, tr.getParent(), lookedAt);
        }
    }

    protected void populateSelectedOnly(Set set) {
        set.addAll(this.controller.getSelectedTerms());
    }

    protected void outputFile(File textFile) throws IOException {
        PrintWriter writer = new PrintWriter(new FileOutputStream(textFile));
        writer.println("digraph G {");
        writer.println("bgcolor=\"" + this.getColorString(this.graphConfiguration.getBGColor()) + "\";");
        writer.println("ranksep=\"" + this.ranksep + "\";");
        writer.println("nodesep=\"" + this.nodesep + "\";");
        HashSet relationshipSet = new HashSet();
        this.populateSet(relationshipSet);
        Iterator it = relationshipSet.iterator();
        HashSet<LinkedObject> termSet = new HashSet<LinkedObject>();
        while (it.hasNext()) {
            Link tr = (Link)it.next();
            if (tr.getParent() != null) {
                if (this.graphConfiguration.getFlipOver()) {
                    writer.println(this.convertID(tr.getParent().getID()) + " -> " + this.convertID(tr.getChild().getID()) + " [" + this.getOptions(tr) + "];");
                } else {
                    writer.println(this.convertID(tr.getChild().getID()) + " -> " + this.convertID(tr.getParent().getID()) + " [" + this.getOptions(tr) + "];");
                }
                termSet.add(tr.getParent());
            }
            termSet.add(tr.getChild());
        }
        it = termSet.iterator();
        while (it.hasNext()) {
            OBOClass t = (OBOClass)it.next();
            writer.println(this.convertID(t.getID()) + " [" + this.getOptions(t) + "];");
        }
        writer.println("}");
        writer.close();
    }

    protected Color getColor(String s) {
        if (s == null) {
            return null;
        }
        try {
            return new Color(Integer.parseInt(s));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void setConfiguration(ComponentConfiguration graphConfiguration) {
        if (graphConfiguration instanceof GraphConfiguration && graphConfiguration != null) {
            this.graphConfiguration = (GraphConfiguration)graphConfiguration;
        }
        this.setDoFiltering(this.graphConfiguration.getDoFiltering());
        this.reloadImage();
    }

    public ComponentConfiguration getConfiguration() {
        return this.graphConfiguration;
    }

    public void init() {
        this.linkDatabase = Controller.getController().getSession().getLinkDatabase();
        this.setPreferredSize(new Dimension(200, 200));
        this.formatBox.setFont(this.controller.getDefaultFont());
        this.modeList.setFont(this.controller.getDefaultFont());
        this.imageLabel.setFont(this.controller.getDefaultFont());
        this.optionButton.setFont(this.controller.getDefaultFont());
        this.saveButton.setFont(this.controller.getDefaultFont());
        this.flipoverBox.setFont(this.controller.getDefaultFont());
        this.showIDsBox.setFont(this.controller.getDefaultFont());
        this.primaryFiltersCheckbox.setFont(this.controller.getDefaultFont());
        this.modeList.setBackground(Preferences.defaultButtonColor());
        this.controller.addListener(this.selectionListener);
        this.modeList.setSelectedItem(this.mode);
        this.reloadImage();
    }

    public void cleanup() {
        this.controller.removeListener(this.selectionListener);
    }

    protected class ExtensionFilter
    extends FileFilter {
        protected String ext;
        protected String desc;

        public ExtensionFilter(String ext, String desc) {
            this.ext = ext;
            this.desc = desc;
        }

        public String getExt() {
            return this.ext;
        }

        public String getExtNoDot() {
            return this.ext.substring(1, this.ext.length());
        }

        public boolean accept(File f) {
            return f.getName().endsWith(this.ext);
        }

        public String getDescription() {
            return this.desc;
        }
    }

    private class ColorEditor
    extends JPanel
    implements GenericEditorComponent {
        private static final long serialVersionUID = 1L;
        JColorChooser textColorChooser = new JColorChooser();
        JColorChooser lineColorChooser = new JColorChooser();
        JTabbedPane tabbedPane = new JTabbedPane();
        protected ListEditor editor;
        protected ChangeListener cl = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ColorEditor.this.editor.commit();
            }
        };

        public void setMasterComponent(Component c) {
            if (c instanceof ListEditor) {
                this.editor = (ListEditor)c;
            }
        }

        public ColorEditor() {
            this.lineColorChooser.setFont(GraphPlugin.this.controller.getDefaultFont());
            this.textColorChooser.setFont(GraphPlugin.this.controller.getDefaultFont());
            this.setLayout(new BoxLayout(this, 1));
            this.attachListeners();
        }

        protected void attachListeners() {
            this.textColorChooser.getSelectionModel().addChangeListener(this.cl);
            this.lineColorChooser.getSelectionModel().addChangeListener(this.cl);
        }

        protected void removeListeners() {
            this.textColorChooser.getSelectionModel().removeChangeListener(this.cl);
            this.lineColorChooser.getSelectionModel().removeChangeListener(this.cl);
        }

        public void load(Object o) {
            this.removeAll();
            this.removeListeners();
            if (o instanceof TypeColorPair) {
                this.tabbedPane.removeAll();
                this.tabbedPane.addTab("Type label color", this.textColorChooser);
                this.tabbedPane.addTab("Type line color", this.lineColorChooser);
                TypeColorPair cp = (TypeColorPair)o;
                this.textColorChooser.setColor(cp.getPair().label);
                this.lineColorChooser.setColor(cp.getPair().edge);
                this.add(this.tabbedPane);
            } else if (o instanceof NamedColor) {
                this.tabbedPane.removeAll();
                NamedColor nc = (NamedColor)o;
                this.textColorChooser.setColor(nc.getColor());
                this.add(this.textColorChooser);
            }
            this.attachListeners();
        }

        public void store(Object o) {
            if (o instanceof TypeColorPair) {
                TypeColorPair cp = (TypeColorPair)o;
                cp.getPair().label = this.textColorChooser.getColor();
                cp.getPair().edge = this.lineColorChooser.getColor();
            } else if (o instanceof NamedColor) {
                NamedColor nc = (NamedColor)o;
                nc.color = this.textColorChooser.getColor();
            }
        }

        public Object createNewValue() {
            return null;
        }
    }

    public static class TypeColorPair
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        ColorPair pair;
        String typeid;

        public TypeColorPair(ColorPair pair, String typeid) {
            this.pair = pair;
            this.typeid = typeid;
        }

        public TypeColorPair() {
        }

        public void setPair(ColorPair pair) {
            this.pair = pair;
        }

        public void setTypeID(String typeid) {
            this.typeid = typeid;
        }

        public ColorPair getPair() {
            return this.pair;
        }

        public String getTypeID() {
            return this.typeid;
        }

        public String toString() {
            return "Link color: " + this.typeid + ", pair=" + this.pair;
        }
    }

    public static class NamedColor
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        protected String name;
        protected Color color;

        public NamedColor() {
        }

        public NamedColor(String name, Color color) {
            this.name = name;
            this.color = color;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public Color getColor() {
            return this.color;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ColorPair
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 1L;
        Color edge;
        Color label;
        int id = idgen++;

        public ColorPair() {
        }

        public void setEdgeColor(Color edge) {
            this.edge = edge;
        }

        public void setLabelColor(Color label) {
            this.label = label;
        }

        public Color getEdgeColor() {
            return this.edge;
        }

        public Color getLabelColor() {
            return this.label;
        }

        public ColorPair(Color edge, Color label) {
            this.edge = edge;
            this.label = label;
        }

        public String toString() {
            return "edgeColor = " + this.edge + ", labelColor = " + this.label;
        }

        public Object clone() {
            try {
                ColorPair out = (ColorPair)super.clone();
                out.id = idgen++;
                return out;
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    public static class GraphConfiguration
    implements ComponentConfiguration {
        protected Map colorMap = new HashMap();
        protected Color bgcolor = Color.black;
        protected Color termBoxColor = Color.white;
        protected Color termStrokeColor = Color.black;
        protected Color termFontColor = Color.black;
        protected Color typeBoxColor = Color.white;
        protected Color typeStrokeColor = Color.blue;
        protected Color typeFontColor = Color.blue;
        protected Color obsoleteBoxColor = Color.white;
        protected Color obsoleteStrokeColor = Color.red;
        protected Color obsoleteFontColor = Color.red;
        protected String typeShape = "box";
        protected String nodeShape = "ellipse";
        protected String obsoleteShape = "egg";
        protected boolean flipover = true;
        protected boolean showIDs = false;
        protected Font nodeFont = new Font("Arial", 0, 10);
        protected Font labelFont = new Font("Arial", 0, 18);
        protected String viewerFormat = "jpg";
        protected String dotPath = "/usr/bin/dot";
        protected boolean doFiltering = false;

        public boolean getDoFiltering() {
            return this.doFiltering;
        }

        public void setDoFiltering(boolean doFiltering) {
            this.doFiltering = doFiltering;
        }

        public Vector getNamedColorList() {
            Vector<Cloneable> data = new Vector<Cloneable>();
            data.add(new NamedColor(GraphPlugin.BACKGROUND_COLOR, this.bgcolor));
            data.add(new NamedColor(GraphPlugin.TERM_BACKGROUND_COLOR, this.termBoxColor));
            data.add(new NamedColor(GraphPlugin.TERM_TEXT_COLOR, this.termFontColor));
            data.add(new NamedColor(GraphPlugin.TERM_STROKE_COLOR, this.termStrokeColor));
            data.add(new NamedColor(GraphPlugin.TYPE_BACKGROUND_COLOR, this.typeBoxColor));
            data.add(new NamedColor(GraphPlugin.TYPE_STROKE_COLOR, this.typeStrokeColor));
            data.add(new NamedColor(GraphPlugin.TYPE_TEXT_COLOR, this.typeFontColor));
            data.add(new NamedColor(GraphPlugin.OBSOLETE_BACKGROUND_COLOR, this.obsoleteBoxColor));
            data.add(new NamedColor(GraphPlugin.OBSOLETE_STROKE_COLOR, this.obsoleteStrokeColor));
            data.add(new NamedColor(GraphPlugin.OBSOLETE_TEXT_COLOR, this.obsoleteFontColor));
            Iterator it = Controller.getController().getSession().getRelationshipTypes().iterator();
            while (it.hasNext()) {
                OBOProperty type = (OBOProperty)it.next();
                ColorPair pair = (ColorPair)this.colorMap.get(type.getID());
                if (pair == null) {
                    pair = (ColorPair)defaultLabelColors.clone();
                }
                TypeColorPair tcp = new TypeColorPair(pair, type.getID());
                data.add(tcp);
            }
            return data;
        }

        public void setNamedColor(String name, Color color) {
            if (name.equals(GraphPlugin.BACKGROUND_COLOR)) {
                this.bgcolor = color;
            } else if (name.equals(GraphPlugin.TERM_BACKGROUND_COLOR)) {
                this.termBoxColor = color;
            } else if (name.equals(GraphPlugin.TERM_TEXT_COLOR)) {
                this.termFontColor = color;
            } else if (name.equals(GraphPlugin.TERM_STROKE_COLOR)) {
                this.termStrokeColor = color;
            } else if (name.equals(GraphPlugin.TYPE_BACKGROUND_COLOR)) {
                this.typeBoxColor = color;
            } else if (name.equals(GraphPlugin.TYPE_STROKE_COLOR)) {
                this.typeStrokeColor = color;
            } else if (name.equals(GraphPlugin.TYPE_TEXT_COLOR)) {
                this.typeFontColor = color;
            } else if (name.equals(GraphPlugin.OBSOLETE_BACKGROUND_COLOR)) {
                this.obsoleteBoxColor = color;
            } else if (name.equals(GraphPlugin.OBSOLETE_STROKE_COLOR)) {
                this.obsoleteStrokeColor = color;
            } else if (name.equals(GraphPlugin.OBSOLETE_TEXT_COLOR)) {
                this.obsoleteFontColor = color;
            }
        }

        public void setDotPath(String dotPath) {
            this.dotPath = dotPath;
        }

        public String getDotPath() {
            return this.dotPath;
        }

        public String getViewerFormat() {
            return this.viewerFormat;
        }

        public void setViewerFormat(String viewerFormat) {
            this.viewerFormat = viewerFormat;
        }

        public void setFlipOver(boolean flipover) {
            this.flipover = flipover;
        }

        public boolean getFlipOver() {
            return this.flipover;
        }

        public boolean getShowIDs() {
            return this.showIDs;
        }

        public void setShowIDs(boolean showIDs) {
            this.showIDs = showIDs;
        }

        public void setLabelFont(Font labelFont) {
            this.labelFont = labelFont;
        }

        public Font getLabelFont() {
            return this.labelFont;
        }

        public Font getNodeFont() {
            return this.nodeFont;
        }

        public void setNodeFont(Font nodeFont) {
            this.nodeFont = nodeFont;
        }

        public void setObsoleteShape(String obsoleteShape) {
            this.obsoleteShape = obsoleteShape;
        }

        public String getObsoleteShape() {
            return this.obsoleteShape;
        }

        public void setNodeShape(String nodeShape) {
            this.nodeShape = nodeShape;
        }

        public String getNodeShape() {
            return this.nodeShape;
        }

        public void setTypeShape(String typeShape) {
            this.typeShape = typeShape;
        }

        public String getTypeShape() {
            return this.typeShape;
        }

        public Color getTermFontColor() {
            return this.termFontColor;
        }

        public void setTermFontColor(Color termFontColor) {
            this.termFontColor = termFontColor;
        }

        public void setTermStrokeColor(Color termStrokeColor) {
            this.termStrokeColor = termStrokeColor;
        }

        public Color getTermStrokeColor() {
            return this.termStrokeColor;
        }

        public Color getTermBoxColor() {
            return this.termBoxColor;
        }

        public void setTermBoxColor(Color termBoxColor) {
            this.termBoxColor = termBoxColor;
        }

        public Color getObsoleteFontColor() {
            return this.obsoleteFontColor;
        }

        public void setObsoleteFontColor(Color obsoleteFontColor) {
            this.obsoleteFontColor = obsoleteFontColor;
        }

        public void setObsoleteStrokeColor(Color obsoleteStrokeColor) {
            this.obsoleteStrokeColor = obsoleteStrokeColor;
        }

        public Color getObsoleteStrokeColor() {
            return this.obsoleteStrokeColor;
        }

        public Color getObsoleteBoxColor() {
            return this.obsoleteBoxColor;
        }

        public void setObsoleteBoxColor(Color obsoleteBoxColor) {
            this.obsoleteBoxColor = obsoleteBoxColor;
        }

        public Color getTypeFontColor() {
            return this.typeFontColor;
        }

        public void setTypeFontColor(Color typeFontColor) {
            this.typeFontColor = typeFontColor;
        }

        public void setTypeStrokeColor(Color typeStrokeColor) {
            this.typeStrokeColor = typeStrokeColor;
        }

        public Color getTypeStrokeColor() {
            return this.typeStrokeColor;
        }

        public Color getTypeBoxColor() {
            return this.typeBoxColor;
        }

        public void setTypeBoxColor(Color typeBoxColor) {
            this.typeBoxColor = typeBoxColor;
        }

        public void setBGColor(Color bgcolor) {
            this.bgcolor = bgcolor;
        }

        public Color getBGColor() {
            return this.bgcolor;
        }

        public void setColorMap(Map colorMap) {
            this.colorMap = colorMap;
        }

        public Map getColorMap() {
            return this.colorMap;
        }
    }

    protected class LinkListener
    implements HyperlinkListener {
        protected LinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                OBOClass term = GraphPlugin.this.controller.getSession().getTerm(e.getURL().getPath());
                Vector v = new Vector();
                Iterator it = term.getParents().iterator();
                while (it.hasNext()) {
                    v.add(it.next());
                }
                GraphPlugin.this.controller.select(v);
            }
        }
    }
}

