/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.geneontology.dataadapter.DataAdapterRegistry;
import org.geneontology.dataadapter.GraphicalAdapterChooser;
import org.geneontology.oboedit.dataadapter.HTMLHistoryDumper;
import org.geneontology.oboedit.dataadapter.OBOEditAdapter;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.HistoryTreeModel;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.event.RefreshEvent;
import org.geneontology.oboedit.gui.event.RefreshListener;
import org.geneontology.oboedit.gui.event.RootChangeEvent;
import org.geneontology.oboedit.gui.event.RootChangeListener;
import org.geneontology.swing.SwingUtil;
import org.geneontology.util.StringUtil;

public class HistoryPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 2066665063180432495L;
    public static final int TAB_SIZE = 3;
    Vector histories;
    JTree sessionList;
    HistoryTreeModel model;
    RefreshListener reloadListener;
    RootChangeListener rootListener;
    TreeSelectionListener selectListener;
    JButton saveButton = new JButton("Save History");
    Component lastGUI = null;
    HTMLHistoryDumper htmlDumper = new HTMLHistoryDumper();

    public HistoryPlugin() {
        this.sessionList = new JTree();
        this.sessionList.setFont(new Font("Dialog", 0, 10));
        this.sessionList.putClientProperty("JTree.lineStyle", "Angled");
        this.sessionList.getSelectionModel().setSelectionMode(1);
        HistoryRenderer rend = new HistoryRenderer();
        rend.setLeafIcon(null);
        rend.setClosedIcon(null);
        rend.setOpenIcon(null);
        this.sessionList.setCellRenderer(rend);
    }

    public String getName() {
        return "History plugin";
    }

    public void init() {
        this.histories = new Vector();
        this.saveButton.setFont(this.controller.getDefaultFont());
        this.saveButton.setBackground(Preferences.defaultButtonColor());
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.layoutPlugin();
        this.attachListeners();
    }

    protected void saveHistory() {
        HistoryList historyList = (HistoryList)this.sessionList.getSelectionPath().getLastPathComponent();
        if (!Controller.getController().getTextEditManager().checkUncommittedEdits()) {
            return;
        }
        try {
            DataAdapterRegistry registry = this.controller.getAdapterRegistry();
            GraphicalAdapterChooser gac = new GraphicalAdapterChooser(registry, OBOEditAdapter.WRITE_HISTORY, (Object)historyList);
            gac.setButtonColor(Preferences.defaultButtonColor(), Color.black);
            gac.setBackground(Preferences.defaultBackgroundColor());
            gac.setHistoryPath(this.controller.getHistoryFilePath());
            gac.setFont(this.controller.getDefaultFont());
            gac.showDialog("Save history", null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void printHistory(PrintWriter writer, int indent, Object obj) {
        String str = StringUtil.repeat((String)" ", (int)indent);
        writer.println(str + "* " + obj.toString());
        int childCount = this.model.getChildCount(obj);
        for (int i = 0; i < childCount; ++i) {
            Object child = this.model.getChild(obj, i);
            this.printHistory(writer, indent + 3, child);
        }
    }

    private void attachListeners() {
        this.rootListener = new RootChangeListener(){

            public void changeRoot(RootChangeEvent e) {
                HistoryPlugin.this.layoutPlugin();
                HistoryPlugin.this.sessionList.expandPath(HistoryPlugin.this.model.getActiveHistoryPath());
            }
        };
        this.reloadListener = new RefreshListener(){

            public void reload(RefreshEvent e) {
                HistoryPlugin.this.model.reloadActiveHistory();
                HistoryPlugin.this.sessionList.expandPath(HistoryPlugin.this.model.getActiveHistoryPath());
                HistoryPlugin.this.resize();
            }
        };
        this.selectListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                HistoryPlugin.this.updateGUI();
            }
        };
        this.sessionList.addTreeSelectionListener(this.selectListener);
        this.controller.addListener(this.rootListener);
        this.controller.addListener(this.reloadListener);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HistoryPlugin.this.saveHistory();
            }
        });
    }

    protected void updateGUI() {
        if (this.lastGUI != null) {
            this.remove(this.lastGUI);
        }
        if (this.sessionList.getSelectionPath() != null) {
            this.lastGUI = this.getComponentForItem(this.sessionList.getSelectionPath());
            this.add(this.lastGUI, "South");
        } else {
            this.lastGUI = null;
        }
        this.resize();
        this.repaint();
    }

    protected Component getComponentForItem(TreePath path) {
        Object object = path.getLastPathComponent();
        if (object instanceof HistoryList) {
            JPanel panel = new JPanel();
            panel.setBackground(Color.white);
            panel.setLayout(new BoxLayout(panel, 1));
            JLabel label = new JLabel();
            JLabel commentLabel = new JLabel("Comment");
            commentLabel.setFont(this.controller.getDefaultFont());
            JTextArea descTextArea = new JTextArea(5, 30);
            descTextArea.setEditable(false);
            descTextArea.setWrapStyleWord(true);
            descTextArea.setLineWrap(true);
            descTextArea.setFont(this.controller.getDefaultFont());
            JScrollPane descPane = new JScrollPane(descTextArea, 20, 31);
            label.setText(((HistoryList)object).getTitle());
            descTextArea.setText(((HistoryList)object).getComment());
            label.setAlignmentX(0.0f);
            commentLabel.setAlignmentX(0.0f);
            descPane.setAlignmentX(0.0f);
            JPanel buttonBox = new JPanel();
            buttonBox.setLayout(new BoxLayout(buttonBox, 0));
            buttonBox.add(Box.createHorizontalGlue());
            buttonBox.add(this.saveButton);
            buttonBox.add(Box.createHorizontalGlue());
            buttonBox.setAlignmentX(0.0f);
            buttonBox.setOpaque(false);
            panel.add(label);
            panel.add(Box.createVerticalStrut(10));
            panel.add(commentLabel);
            panel.add(descPane);
            panel.add(buttonBox);
            return panel;
        }
        if (object instanceof HistoryItem) {
            HistoryList history = null;
            while (path != null) {
                if (path.getLastPathComponent() instanceof HistoryList) {
                    history = (HistoryList)path.getLastPathComponent();
                }
                path = path.getParentPath();
            }
            JEditorPane editorPane = new JEditorPane("text/html", "<html></html>");
            editorPane.setEditable(false);
            editorPane.setFont(this.controller.getDefaultFont());
            editorPane.setPreferredSize(new Dimension(300, 100));
            editorPane.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        HistoryPlugin.this.selectTerm(e.getURL(), HistoryPlugin.this.controller.getSession());
                    }
                }
            });
            JScrollPane descPane = new JScrollPane(editorPane, 20, 31);
            editorPane.setText(this.htmlDumper.getItemDesc((HistoryItem)object, this.controller.getSession()));
            return descPane;
        }
        JEditorPane editorPane = new JEditorPane("text/html", "<html></html>");
        editorPane.setEditable(false);
        editorPane.setFont(this.controller.getDefaultFont());
        editorPane.setPreferredSize(new Dimension(300, 100));
        JScrollPane descPane = new JScrollPane(editorPane, 20, 31);
        editorPane.setText(object.toString());
        return descPane;
    }

    public void selectTerm(URL url, OBOSession history) {
        String id = url.getPath();
        OBOClass t = history.getTerm(id);
        Vector<OBOClass> terms = new Vector<OBOClass>();
        terms.add(t);
        this.controller.select(terms);
    }

    public void cleanup() {
        this.controller.removeListener(this.rootListener);
        this.controller.removeListener(this.reloadListener);
    }

    protected void layoutPlugin() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.model = new HistoryTreeModel(this.controller.getSession(), this.controller);
        this.sessionList.setModel(this.model);
        JScrollPane pane = new JScrollPane(this.sessionList, 20, 30);
        SwingUtil.setPreferredWidth((JComponent)pane, (int)200);
        this.add(pane, "Center");
        this.validate();
    }

    protected class HistoryRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -7969060810210949236L;

        protected HistoryRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (HistoryPlugin.this.controller != null && HistoryPlugin.this.controller.getSession() != null && value instanceof HistoryList && value.equals(HistoryPlugin.this.controller.getSession().getCurrentHistory())) {
                this.setForeground(Color.blue);
                this.setText("Current session");
            } else {
                this.setForeground(Color.black);
                this.setText(value.toString());
            }
            return c;
        }
    }
}

