/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.Color;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.geneontology.dataadapter.DataAdapterRegistry;
import org.geneontology.dataadapter.GraphicalAdapterChooser;
import org.geneontology.oboedit.dataadapter.OBOEditAdapter;
import org.geneontology.oboedit.datamodel.HistoryGenerator;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.HistoryTreeModel;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.swing.SwingUtil;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;

public class TermChangeTrackerPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 1L;
    protected OBOSession oldHistory = null;
    protected OBOSession newHistory = null;
    protected HistoryList generatedHistory = null;
    protected boolean loadedOld = false;
    protected boolean loadedNew = false;
    protected JButton loadOldRootButton = new JButton("Load ontology...");
    protected JButton currentOldRootButton = new JButton("Use current ontology");
    protected JButton loadNewRootButton = new JButton("Load ontology...");
    protected JButton currentNewRootButton = new JButton("Use current ontology");
    protected JLabel oldRootLabel = new JLabel();
    protected JLabel newRootLabel = new JLabel();
    protected JButton findChangeButton = new JButton("Find Changes");
    protected JButton saveChangesButton = new JButton("Save Changes");
    protected JTree changeTree = new JTree(new DefaultMutableTreeNode("No changes loaded"));
    protected Box progressBox = Box.createVerticalBox();
    protected JProgressBar progressBar = new JProgressBar(0, 100);
    protected ProgressListener progressListener = new ProgressListener(){

        public void progressMade(ProgressEvent e) {
            int progress = (int)e.getValue().doubleValue();
            TermChangeTrackerPlugin.this.progressBar.setValue(progress);
            TermChangeTrackerPlugin.this.progressBar.setString(e.getDescription() + " " + progress + "%");
            TermChangeTrackerPlugin.this.progressBar.paintImmediately(new Rectangle(0, 0, TermChangeTrackerPlugin.this.progressBar.getWidth(), TermChangeTrackerPlugin.this.progressBar.getHeight()));
        }
    };
    protected Runnable comparisonRunnable = new Runnable(){

        public void run() {
            Runnable dispatcher = new Runnable(){

                public void run() {
                    TermChangeTrackerPlugin.this.add((this).TermChangeTrackerPlugin.this.progressBox);
                    TermChangeTrackerPlugin.this.revalidate();
                    (this).TermChangeTrackerPlugin.this.loadOldRootButton.setEnabled(false);
                    (this).TermChangeTrackerPlugin.this.currentOldRootButton.setEnabled(false);
                    (this).TermChangeTrackerPlugin.this.loadNewRootButton.setEnabled(false);
                    (this).TermChangeTrackerPlugin.this.currentNewRootButton.setEnabled(false);
                    (this).TermChangeTrackerPlugin.this.findChangeButton.setEnabled(false);
                    (this).TermChangeTrackerPlugin.this.saveChangesButton.setEnabled(false);
                    (this).TermChangeTrackerPlugin.this.changeTree.setEnabled(false);
                    TermChangeTrackerPlugin.this.paintImmediately(new Rectangle(0, 0, TermChangeTrackerPlugin.this.getWidth(), TermChangeTrackerPlugin.this.getHeight()));
                    TermChangeTrackerPlugin.this.resize();
                }
            };
            try {
                SwingUtilities.invokeLater(dispatcher);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            TermChangeTrackerPlugin.this.generatedHistory = HistoryGenerator.getHistory(TermChangeTrackerPlugin.this.oldHistory, TermChangeTrackerPlugin.this.newHistory, TermChangeTrackerPlugin.this.progressListener);
            final HistoryTreeModel model = new HistoryTreeModel(TermChangeTrackerPlugin.this.generatedHistory, TermChangeTrackerPlugin.this.controller);
            dispatcher = new Runnable(){

                public void run() {
                    (this).TermChangeTrackerPlugin.this.changeTree.setModel(model);
                    (this).TermChangeTrackerPlugin.this.loadOldRootButton.setEnabled(true);
                    (this).TermChangeTrackerPlugin.this.currentOldRootButton.setEnabled(true);
                    (this).TermChangeTrackerPlugin.this.loadNewRootButton.setEnabled(true);
                    (this).TermChangeTrackerPlugin.this.currentNewRootButton.setEnabled(true);
                    (this).TermChangeTrackerPlugin.this.findChangeButton.setEnabled(true);
                    (this).TermChangeTrackerPlugin.this.saveChangesButton.setEnabled(true);
                    (this).TermChangeTrackerPlugin.this.changeTree.setEnabled(true);
                    TermChangeTrackerPlugin.this.remove((this).TermChangeTrackerPlugin.this.progressBox);
                    TermChangeTrackerPlugin.this.resize();
                }
            };
            try {
                SwingUtilities.invokeLater(dispatcher);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };

    public TermChangeTrackerPlugin() {
        this.attachListeners();
    }

    public void init() {
        this.buildGUI();
        this.setFont(this.controller.getDefaultFont());
        this.update();
    }

    public void buildGUI() {
        this.setBackground(Preferences.defaultBackgroundColor());
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.saveChangesButton.setEnabled(false);
        JScrollPane changeTreePane = new JScrollPane(this.changeTree, 20, 30);
        this.changeTree.setEnabled(false);
        this.changeTree.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeCellRenderer rend = new DefaultTreeCellRenderer();
        rend.setLeafIcon(null);
        rend.setClosedIcon(null);
        rend.setOpenIcon(null);
        this.changeTree.setCellRenderer(rend);
        SwingUtil.setPreferredHeight((JComponent)changeTreePane, (int)200);
        TitledBorder oldRootBorder = new TitledBorder("Old Ontology");
        TitledBorder newRootBorder = new TitledBorder("New Ontology");
        oldRootBorder.setTitleFont(this.controller.getDefaultFont());
        newRootBorder.setTitleFont(this.controller.getDefaultFont());
        this.progressBar.setStringPainted(true);
        this.progressBar.setFont(this.controller.getDefaultFont());
        this.changeTree.setFont(this.controller.getDefaultFont());
        this.loadOldRootButton.setFont(this.controller.getDefaultFont());
        this.currentOldRootButton.setFont(this.controller.getDefaultFont());
        this.loadNewRootButton.setFont(this.controller.getDefaultFont());
        this.currentNewRootButton.setFont(this.controller.getDefaultFont());
        this.oldRootLabel.setFont(this.controller.getDefaultFont());
        this.newRootLabel.setFont(this.controller.getDefaultFont());
        this.findChangeButton.setFont(this.controller.getDefaultFont());
        this.saveChangesButton.setFont(this.controller.getDefaultFont());
        this.findChangeButton.setAlignmentX(0.0f);
        this.saveChangesButton.setAlignmentX(0.0f);
        Box rootBox = Box.createHorizontalBox();
        JPanel oldRootPanel = this.getButtonPanel(this.loadOldRootButton, this.currentOldRootButton, this.oldRootLabel);
        JPanel newRootPanel = this.getButtonPanel(this.loadNewRootButton, this.currentNewRootButton, this.newRootLabel);
        oldRootPanel.setBorder(oldRootBorder);
        newRootPanel.setBorder(newRootBorder);
        rootBox.add(oldRootPanel);
        rootBox.add(newRootPanel);
        Box findChangeBox = Box.createHorizontalBox();
        findChangeBox.add(Box.createHorizontalGlue());
        findChangeBox.add(this.findChangeButton);
        findChangeBox.add(Box.createHorizontalStrut(10));
        findChangeBox.add(this.saveChangesButton);
        findChangeBox.add(Box.createHorizontalGlue());
        this.findChangeButton.setBackground(Preferences.defaultButtonColor());
        this.saveChangesButton.setBackground(Preferences.defaultButtonColor());
        this.progressBar.setValue(0);
        this.progressBox.add(Box.createVerticalStrut(5));
        this.progressBox.add(this.progressBar);
        this.progressBox.add(Box.createVerticalStrut(5));
        this.removeAll();
        this.add(rootBox);
        this.add(changeTreePane);
        this.add(findChangeBox);
        this.validate();
    }

    public void doComparison() {
        Thread comparisonThread = new Thread(this.comparisonRunnable);
        comparisonThread.start();
    }

    protected void saveHistory() {
        if (this.generatedHistory != null) {
            try {
                DataAdapterRegistry registry = this.controller.getAdapterRegistry();
                GraphicalAdapterChooser gac = new GraphicalAdapterChooser(registry, OBOEditAdapter.WRITE_HISTORY, (Object)this.generatedHistory);
                gac.setButtonColor(Preferences.defaultButtonColor(), Color.black);
                gac.setBackground(Preferences.defaultBackgroundColor());
                gac.setHistoryPath(this.controller.getHistoryFilePath());
                gac.setFont(this.controller.getDefaultFont());
                boolean bl = gac.showDialog("Save history", null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(Controller.getController().getFrame(), "You cannot save until you've clicked the \"Find Changes\" button.");
        }
    }

    protected void attachListeners() {
        this.findChangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TermChangeTrackerPlugin.this.doComparison();
            }
        });
        this.saveChangesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TermChangeTrackerPlugin.this.saveHistory();
            }
        });
        this.currentOldRootButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TermChangeTrackerPlugin.this.oldHistory = TermChangeTrackerPlugin.this.controller.getSession();
                TermChangeTrackerPlugin.this.loadedOld = false;
                TermChangeTrackerPlugin.this.update();
            }
        });
        this.currentNewRootButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TermChangeTrackerPlugin.this.newHistory = TermChangeTrackerPlugin.this.controller.getSession();
                TermChangeTrackerPlugin.this.loadedNew = false;
                TermChangeTrackerPlugin.this.update();
            }
        });
        this.loadOldRootButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OBOSession session = TermChangeTrackerPlugin.this.getTerm();
                if (session != null) {
                    TermChangeTrackerPlugin.this.oldHistory = session;
                    TermChangeTrackerPlugin.this.loadedOld = true;
                    TermChangeTrackerPlugin.this.update();
                }
            }
        });
        this.loadNewRootButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OBOSession session = TermChangeTrackerPlugin.this.getTerm();
                if (session != null) {
                    TermChangeTrackerPlugin.this.newHistory = session;
                    TermChangeTrackerPlugin.this.loadedNew = true;
                    TermChangeTrackerPlugin.this.update();
                }
            }
        });
    }

    protected OBOSession getTerm() {
        OBOSession history = Controller.getController().showLoadDialog();
        if (history == null) {
            return null;
        }
        return history;
    }

    protected void update() {
        if (this.oldHistory == null) {
            this.oldRootLabel.setText("<no root chosen>");
        } else if (this.oldHistory.getLoadRemark() != null) {
            this.oldRootLabel.setText(this.oldHistory.getLoadRemark());
        } else if (!this.loadedOld) {
            this.oldRootLabel.setText("using current root");
        } else {
            this.oldRootLabel.setText("root loaded from adapter");
        }
        if (this.newHistory == null) {
            this.newRootLabel.setText("<no root chosen>");
        } else if (this.newHistory.getLoadRemark() != null) {
            this.newRootLabel.setText(this.newHistory.getLoadRemark());
        } else if (!this.loadedNew) {
            this.newRootLabel.setText("using current root");
        } else {
            this.newRootLabel.setText("root loaded from adapter");
        }
        this.findChangeButton.setEnabled(this.oldHistory != null && this.newHistory != null);
    }

    private JPanel getButtonPanel(JButton loadButton, JButton currentButton, JLabel label) {
        loadButton.setBackground(Preferences.defaultButtonColor());
        currentButton.setBackground(Preferences.defaultButtonColor());
        loadButton.setAlignmentX(0.0f);
        currentButton.setAlignmentX(0.0f);
        label.setAlignmentX(0.0f);
        Box labels = Box.createHorizontalBox();
        Box buttons = Box.createHorizontalBox();
        buttons.add(Box.createHorizontalGlue());
        buttons.add(loadButton);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(Box.createHorizontalStrut(10));
        buttons.add(Box.createHorizontalGlue());
        buttons.add(currentButton);
        buttons.add(Box.createHorizontalGlue());
        labels.add(label);
        labels.add(Box.createHorizontalGlue());
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(labels);
        panel.add(buttons);
        return panel;
    }

    public String getName() {
        return "Term Change Tracker Plugin";
    }
}

