/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.gui.CheckWarningComponent;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.event.VerificationEvent;
import org.geneontology.oboedit.gui.event.VerificationListener;
import org.geneontology.oboedit.verify.Check;
import org.geneontology.oboedit.verify.CheckConfiguration;
import org.geneontology.oboedit.verify.UserCheck;
import org.geneontology.oboedit.verify.UserFilterCheck;
import org.geneontology.oboedit.verify.VerificationEngine;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;

public class VerificationPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 1L;
    protected JTable table = new JTable(){

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }
    };
    protected JButton checkButton = new JButton("Run Manual Check");
    protected JButton addCheckButton = new JButton("Add check");
    protected JButton removeCheckButton = new JButton("Remove check");
    protected JTabbedPane tabbedPane = new JTabbedPane();
    protected JPanel configPanel = new JPanel();
    protected CheckWarningComponent warningComponent = new CheckWarningComponent();
    protected JScrollPane warningScroller = new JScrollPane(this.warningComponent, 20, 31);
    protected JProgressBar progressBar = new JProgressBar();
    protected JPanel progressPanel = new JPanel();
    protected List checkList = new ArrayList();
    protected VerificationListener verificationListener = new VerificationListener(){

        public void verificationComplete(VerificationEvent e) {
            VerificationPlugin.this.setLastResults(e.getWarnings(), e.getSession(), e.getCurrentObject(), e.getCondition());
        }

        public void verificationStarting(VerificationEvent e) {
            VerificationPlugin.this.showProgressBar();
        }
    };
    protected ProgressListener progressListener = new ProgressListener(){

        public void progressMade(ProgressEvent e) {
            Double v = e.getValue();
            if (v == null) {
                VerificationPlugin.this.progressBar.setIndeterminate(true);
            } else {
                VerificationPlugin.this.progressBar.setIndeterminate(false);
                VerificationPlugin.this.progressBar.setValue(v.intValue());
            }
            VerificationPlugin.this.progressBar.setString(e.getDescription());
        }
    };
    protected ButtonRenderer buttonRenderer = new ButtonRenderer();
    protected ButtonEditor buttonEditor = new ButtonEditor();
    protected VerificationTableModel tableModel = new VerificationTableModel();
    protected JCheckBox textEditWarningCheckbox = new JCheckBox("On text edits?");
    protected JCheckBox reasonerWarningCheckbox = new JCheckBox("On reasoner?");
    protected JCheckBox saveWarningCheckbox = new JCheckBox("On save?");
    protected JCheckBox checkObsoletesCheckbox = new JCheckBox("Check obsoletes?");
    protected JCheckBox loadWarningCheckbox = new JCheckBox("On load?");
    protected JCheckBox manualWarningCheckbox = new JCheckBox("On manual?");
    protected ActionListener warningCheckboxListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            VerificationPlugin.this.updateEngineSettings();
        }
    };
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    public VerificationPlugin() {
        this.setLayout(new GridLayout(1, 1));
        this.warningComponent.setHyperlinksEnabled(true);
        this.tabbedPane.addTab("Configuration", this.configPanel);
        this.tabbedPane.addTab("Verification Results", this.warningScroller);
        this.table.setModel(this.tableModel);
        TableColumn column = null;
        for (int i = 0; i < 5; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            if (i > 0) {
                column.setPreferredWidth(20);
            }
            column.setHeaderValue(this.tableModel.getColumnName(i));
        }
        this.checkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VerificationPlugin.this.runChecks();
            }
        });
        this.addCheckButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VerificationPlugin.this.addCheck();
            }
        });
        this.removeCheckButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VerificationPlugin.this.removeCheck();
            }
        });
        this.textEditWarningCheckbox.addActionListener(this.warningCheckboxListener);
        this.reasonerWarningCheckbox.addActionListener(this.warningCheckboxListener);
        this.saveWarningCheckbox.addActionListener(this.warningCheckboxListener);
        this.checkObsoletesCheckbox.addActionListener(this.warningCheckboxListener);
        this.loadWarningCheckbox.addActionListener(this.warningCheckboxListener);
        this.manualWarningCheckbox.addActionListener(this.warningCheckboxListener);
        this.progressPanel.setLayout(new BorderLayout());
        this.progressPanel.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        this.progressBar.setStringPainted(true);
        this.progressPanel.add((Component)this.progressBar, "North");
        Box commitButtonBox = new Box(0);
        commitButtonBox.add(this.checkButton);
        Box buttonBox = new Box(0);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(this.addCheckButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.removeCheckButton);
        buttonBox.add(Box.createHorizontalGlue());
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.add(this.textEditWarningCheckbox);
        checkboxPanel.add(this.reasonerWarningCheckbox);
        checkboxPanel.add(this.saveWarningCheckbox);
        checkboxPanel.add(this.loadWarningCheckbox);
        checkboxPanel.add(this.manualWarningCheckbox);
        TitledBorder titledBorder = new TitledBorder("Show warnings");
        titledBorder.setTitleFont(Controller.getController().getPreferences().getFont());
        checkboxPanel.setBorder(titledBorder);
        Box otherOptionsPanel = new Box(0);
        otherOptionsPanel.add(Box.createHorizontalGlue());
        otherOptionsPanel.add(this.checkObsoletesCheckbox);
        otherOptionsPanel.add(Box.createHorizontalGlue());
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 1));
        southPanel.setOpaque(false);
        southPanel.add(checkboxPanel);
        southPanel.add(otherOptionsPanel);
        southPanel.add(buttonBox);
        southPanel.add(commitButtonBox);
        this.packColumns(this.table, 0);
        this.packRows(this.table, 0);
        System.err.println("table preferred size = " + this.table.getPreferredSize());
        this.configPanel.setLayout(new BorderLayout());
        this.configPanel.add((Component)new JScrollPane(this.table, 20, 31), "Center");
        this.configPanel.add((Component)southPanel, "South");
        this.add(this.tabbedPane);
        this.table.setSelectionMode(0);
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                VerificationPlugin.this.updateButtonStates();
            }
        });
    }

    public void packColumns(JTable table, int margin) {
        for (int c = 0; c < table.getColumnCount(); ++c) {
            this.packColumn(table, c, margin);
        }
    }

    public void packColumn(JTable table, int vColIndex, int margin) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn col = colModel.getColumn(vColIndex);
        int width = 0;
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        width = comp.getPreferredSize().width;
        for (int r = 0; r < table.getRowCount(); ++r) {
            renderer = table.getCellRenderer(r, vColIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        col.setPreferredWidth(width += 2 * margin);
    }

    public int getPreferredRowHeight(JTable table, int rowIndex, int margin) {
        int height = table.getRowHeight();
        for (int c = 0; c < table.getColumnCount(); ++c) {
            TableCellRenderer renderer = table.getCellRenderer(rowIndex, c);
            Component comp = table.prepareRenderer(renderer, rowIndex, c);
            int h = comp.getPreferredSize().height + 2 * margin;
            height = Math.max(height, h);
        }
        return height;
    }

    public void packRows(JTable table, int margin) {
        this.packRows(table, 0, table.getRowCount(), margin);
    }

    public void packRows(JTable table, int start, int end, int margin) {
        for (int r = 0; r < table.getRowCount(); ++r) {
            int h = this.getPreferredRowHeight(table, r, margin);
            if (table.getRowHeight(r) == h) continue;
            table.setRowHeight(r, h);
        }
    }

    protected void updateButtonStates() {
        int selectedRow = this.table.getSelectedRow();
        Check check = null;
        if (selectedRow != -1) {
            check = this.tableModel.getCheck(selectedRow);
        }
        this.removeCheckButton.setEnabled(check != null && check instanceof UserCheck);
    }

    protected void showProgressBar() {
        this.tabbedPane.setComponentAt(1, this.progressPanel);
        this.tabbedPane.setEnabledAt(1, true);
        this.tabbedPane.setSelectedIndex(1);
    }

    protected void setLastResults(Collection c, OBOSession session, IdentifiedObject currentObject, byte condition) {
        boolean showCondition = VerificationEngine.getConditionAtField(Controller.getController().getVerificationEngine().getWarningConditions(), condition);
        this.warningComponent.setRerunInfo(session, currentObject, condition);
        this.warningComponent.setWarnings(c, null, null, true, showCondition, true);
        this.tabbedPane.setComponentAt(1, this.warningScroller);
        this.tabbedPane.revalidate();
        this.tabbedPane.repaint();
    }

    protected void runChecks() {
        Runnable r = new Runnable(){

            public void run() {
                Controller.getController().getVerificationEngine().runChecks(Controller.getController().getSession(), null, (byte)8);
            }
        };
        Thread thread = new Thread(r);
        thread.start();
    }

    protected void addCheck() {
        UserFilterCheck check = new UserFilterCheck();
        Controller.getController().getVerificationEngine().installCheck(check);
        this.tableModel.setData(Controller.getController().getVerificationEngine().getChecks());
        this.configureCheck(check);
    }

    protected void removeCheck() {
        int selectedRow = this.table.getSelectedRow();
        Check check = this.tableModel.getCheck(selectedRow);
        Controller.getController().getVerificationEngine().removeCheck(check);
        this.tableModel.setData(Controller.getController().getVerificationEngine().getChecks());
    }

    protected void updateEngineSettings() {
        byte warningCondition = 0;
        if (this.textEditWarningCheckbox.isSelected()) {
            warningCondition = (byte)(warningCondition ^ 1);
        }
        if (this.reasonerWarningCheckbox.isSelected()) {
            warningCondition = (byte)(warningCondition ^ 2);
        }
        if (this.saveWarningCheckbox.isSelected()) {
            warningCondition = (byte)(warningCondition ^ 4);
        }
        if (this.loadWarningCheckbox.isSelected()) {
            warningCondition = (byte)(warningCondition ^ 0x10);
        }
        if (this.manualWarningCheckbox.isSelected()) {
            warningCondition = (byte)(warningCondition ^ 8);
        }
        Controller.getController().getVerificationEngine().setWarningConditions(warningCondition);
        Controller.getController().getVerificationEngine().setCheckObsoletes(this.checkObsoletesCheckbox.isSelected());
    }

    protected void configureCheck(Check check) {
        final JDialog dialog = new JDialog(Controller.getController().getFrame(), "Configuring check \"" + check.getDescription() + "\"", true);
        JComponent configurationPanel = check.getConfigurationPanel();
        JPanel panel = new JPanel();
        panel.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        panel.setLayout(new BorderLayout());
        JButton okButton = new JButton("Ok");
        okButton.setBackground(Controller.getController().getPreferences().getButtonColor());
        okButton.setFont(Controller.getController().getPreferences().getFont());
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        if (configurationPanel instanceof ActionListener) {
            okButton.addActionListener((ActionListener)((Object)configurationPanel));
        }
        dialog.setContentPane(panel);
        panel.add((Component)configurationPanel, "Center");
        panel.add((Component)okButton, "South");
        dialog.pack();
        dialog.show();
    }

    public void init() {
        Controller.getController().addListener(this.verificationListener);
        Controller.getController().getVerificationEngine().addProgressListener(this.progressListener);
        Font font = Controller.getController().getPreferences().getFont();
        this.progressBar.setFont(font);
        this.checkButton.setFont(font);
        this.checkButton.setBackground(Controller.getController().getPreferences().getButtonColor());
        this.addCheckButton.setFont(font);
        this.addCheckButton.setBackground(Controller.getController().getPreferences().getButtonColor());
        this.removeCheckButton.setFont(font);
        this.removeCheckButton.setBackground(Controller.getController().getPreferences().getButtonColor());
        this.buttonRenderer.setFont(font);
        this.buttonRenderer.setBackground(Controller.getController().getPreferences().getButtonColor());
        this.tableModel.setData(Controller.getController().getVerificationEngine().getChecks());
        System.err.println("checks = " + Controller.getController().getVerificationEngine().getChecks());
        byte warningCondition = Controller.getController().getVerificationEngine().getWarningConditions();
        this.textEditWarningCheckbox.setSelected(VerificationEngine.getConditionAtField(warningCondition, (byte)1));
        this.reasonerWarningCheckbox.setSelected(VerificationEngine.getConditionAtField(warningCondition, (byte)2));
        this.saveWarningCheckbox.setSelected(VerificationEngine.getConditionAtField(warningCondition, (byte)4));
        this.loadWarningCheckbox.setSelected(VerificationEngine.getConditionAtField(warningCondition, (byte)16));
        this.manualWarningCheckbox.setSelected(VerificationEngine.getConditionAtField(warningCondition, (byte)8));
        this.checkObsoletesCheckbox.setSelected(Controller.getController().getVerificationEngine().getCheckObsoletes());
        this.table.setDefaultRenderer(CheckConfiguration.class, this.buttonRenderer);
        this.table.setDefaultEditor(CheckConfiguration.class, this.buttonEditor);
        this.tabbedPane.setFont(font);
        this.tabbedPane.setBackgroundAt(0, Controller.getController().getPreferences().getBackgroundColor());
        this.tabbedPane.setBackgroundAt(1, Controller.getController().getPreferences().getBackgroundColor());
        this.tabbedPane.setEnabledAt(1, false);
        this.textEditWarningCheckbox.setFont(font);
        this.reasonerWarningCheckbox.setFont(font);
        this.saveWarningCheckbox.setFont(font);
        this.checkObsoletesCheckbox.setFont(font);
        this.loadWarningCheckbox.setFont(font);
        this.manualWarningCheckbox.setFont(font);
    }

    public void cleanup() {
        Controller.getController().removeListener(this.verificationListener);
        Controller.getController().getVerificationEngine().removeProgressListener(this.progressListener);
    }

    public String getName() {
        return "Verification Plugin";
    }

    protected class ButtonEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;

        protected ButtonEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            final Check check = (Check)VerificationPlugin.this.checkList.get(row);
            JButton configButton = new JButton("Configure");
            configButton.setFont(Controller.getController().getPreferences().getFont());
            configButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VerificationPlugin.this.configureCheck(check);
                }
            });
            configButton.setEnabled(check.getConfigurationPanel() != null);
            configButton.setBackground(Controller.getController().getPreferences().getButtonColor());
            return configButton;
        }

        public Object getCellEditorValue() {
            return null;
        }
    }

    protected class ButtonRenderer
    extends JButton
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public ButtonRenderer() {
            super("Configure");
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Check check = (Check)VerificationPlugin.this.checkList.get(row);
            this.setEnabled(check.getConfigurationPanel() != null);
            return this;
        }
    }

    protected class VerificationTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        protected int sortCol = 0;
        protected boolean reverseOrder = false;
        protected Comparator comparator = new Comparator(){

            public int compare(Object a, Object b) {
                Object aval = VerificationTableModel.this.getValue((Check)a, VerificationTableModel.this.sortCol);
                Object bval = VerificationTableModel.this.getValue((Check)b, VerificationTableModel.this.sortCol);
                int compVal = 0;
                if (aval instanceof Comparable && bval instanceof Comparable) {
                    compVal = ((Comparable)aval).compareTo(bval);
                }
                if (VerificationTableModel.this.reverseOrder) {
                    compVal *= -1;
                }
                return compVal;
            }
        };

        public void setData(Collection checks) {
            VerificationPlugin.this.checkList.clear();
            VerificationPlugin.this.checkList.addAll(checks);
            this.doSort();
            this.fireTableStructureChanged();
        }

        public Check getCheck(int row) {
            return (Check)VerificationPlugin.this.checkList.get(row);
        }

        public void removeCheck(int row) {
            VerificationPlugin.this.checkList.remove(row);
            this.fireTableStructureChanged();
        }

        public void setSortColumn(int sortCol) {
            if (this.sortCol == sortCol) {
                this.reverseOrder = !this.reverseOrder;
            } else {
                this.sortCol = sortCol;
                this.reverseOrder = true;
            }
            this.doSort();
        }

        protected void doSort() {
            Collections.sort(VerificationPlugin.this.checkList, this.comparator);
        }

        protected Object getValue(Check check, int col) {
            if (col == 0) {
                return check.getDescription();
            }
            if (col == 1) {
                return this.wrapBoolean(VerificationEngine.isTextCommitCondition(check));
            }
            if (col == 2) {
                return this.wrapBoolean(VerificationEngine.isReasonerActivatedCondition(check));
            }
            if (col == 3) {
                return this.wrapBoolean(VerificationEngine.isSaveCondition(check));
            }
            if (col == 4) {
                return this.wrapBoolean(VerificationEngine.isLoadCondition(check));
            }
            if (col == 5) {
                return this.wrapBoolean(VerificationEngine.isManualCondition(check));
            }
            if (col == 6) {
                return check.getConfiguration();
            }
            return null;
        }

        protected void setValue(Check check, int col, Object o) {
            if (col == 1) {
                VerificationEngine.setConditionAtField(check, (byte)1, (Boolean)o);
            } else if (col == 2) {
                VerificationEngine.setConditionAtField(check, (byte)2, (Boolean)o);
            } else if (col == 3) {
                VerificationEngine.setConditionAtField(check, (byte)4, (Boolean)o);
            } else if (col == 4) {
                VerificationEngine.setConditionAtField(check, (byte)16, (Boolean)o);
            } else if (col == 5) {
                VerificationEngine.setConditionAtField(check, (byte)8, (Boolean)o);
            }
        }

        protected Boolean wrapBoolean(boolean b) {
            if (b) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return class$java$lang$String == null ? (class$java$lang$String = VerificationPlugin.class$("java.lang.String")) : class$java$lang$String;
            }
            if (col == 1) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = VerificationPlugin.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (col == 2) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = VerificationPlugin.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (col == 3) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = VerificationPlugin.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (col == 4) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = VerificationPlugin.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (col == 5) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = VerificationPlugin.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (col == 6) {
                return class$org$geneontology$oboedit$verify$CheckConfiguration == null ? (class$org$geneontology$oboedit$verify$CheckConfiguration = VerificationPlugin.class$("org.geneontology.oboedit.verify.CheckConfiguration")) : class$org$geneontology$oboedit$verify$CheckConfiguration;
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = VerificationPlugin.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public int getColumnCount() {
            return 7;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Check Name";
            }
            if (col == 1) {
                return "On text edit?";
            }
            if (col == 2) {
                return "On reasoner?";
            }
            if (col == 3) {
                return "On save?";
            }
            if (col == 4) {
                return "On load?";
            }
            if (col == 5) {
                return "On manual?";
            }
            if (col == 6) {
                return "Configure";
            }
            return "";
        }

        public int getRowCount() {
            return VerificationPlugin.this.checkList.size();
        }

        public Object getValueAt(int row, int column) {
            Check check = (Check)VerificationPlugin.this.checkList.get(row);
            return this.getValue(check, column);
        }

        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        public void setValueAt(Object val, int row, int col) {
            Check check = (Check)VerificationPlugin.this.checkList.get(row);
            this.setValue(check, col, val);
        }
    }
}

