/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.tree.TreePath;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.DataAdapterException;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.oboedit.dataadapter.OBOFileAdapter;
import org.geneontology.oboedit.datamodel.HistoryGenerator;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.OperationModel;
import org.geneontology.oboedit.datamodel.OperationWarning;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.impl.DefaultOperationModel;

public class TestUtil
extends TestCase {
    protected OBOSession session;
    protected OperationModel operationModel;

    public TestUtil(OBOSession session) {
        this.session = session;
        this.operationModel = new DefaultOperationModel();
        this.operationModel.setHistory(session);
    }

    public static String getRandomString(int length) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            out.append(TestUtil.getRandomChar());
        }
        return out.toString();
    }

    public static String getRandomID() {
        StringBuffer out = new StringBuffer();
        out.append("ID:");
        for (int i = 0; i < 7; ++i) {
            out.append((int)Math.floor(Math.random() * 10.0));
        }
        return out.toString();
    }

    public void apply(HistoryList historyList) {
        Iterator it = historyList.getHistoryItems();
        while (it.hasNext()) {
            HistoryItem item = (HistoryItem)it.next();
            OperationWarning warning = this.apply(item);
            TestUtil.assertNull((String)("No operation should generate a warning. Got " + warning + " from " + item), (Object)warning);
        }
    }

    public OperationWarning apply(HistoryItem item) {
        OperationWarning warn = this.operationModel.apply(item);
        if (warn != null) {
            System.err.println("WARNING WHILE TESTING: " + warn + " on " + item);
        }
        return warn;
    }

    public OperationWarning reverse(HistoryItem item) {
        return this.operationModel.reverse(item);
    }

    protected static char getRandomChar() {
        int val = (int)(Math.random() * 100.0);
        if (val < 20) {
            return ' ';
        }
        if (val > 98) {
            return TestUtil.getRandomExtendedChar();
        }
        return TestUtil.getRandomBasicChar();
    }

    protected static char getRandomBasicChar() {
        return (char)(33.0 + Math.random() * 93.0);
    }

    protected static char getRandomExtendedChar() {
        return (char)(2.0 + Math.random() * 126.0);
    }

    public static TestUtil getInstance() {
        return new TestUtil(TestUtil.createSession());
    }

    public static OBOSession createSession() {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.getReadPaths().add("lib/resources/testfile.1.0.obo");
        try {
            OBOSession session = (OBOSession)adapter.doOperation(IOOperation.READ, (AdapterConfiguration)config, null);
            return session;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public OBOSession getSession() {
        return this.session;
    }

    public OBOClass getRandomClass() {
        return (OBOClass)this.getRandomObject(OBOClass.class);
    }

    public OBOProperty getRandomProperty() {
        return (OBOProperty)this.getRandomObject(OBOProperty.class);
    }

    public Namespace getRandomNamespace(Namespace notThis) {
        Namespace ns;
        if (this.session.getNamespaces().size() < 1 || notThis != null && this.session.getNamespaces().size() < 2) {
            return null;
        }
        do {
            ns = this.getRandomNamespace();
            System.err.println("randomns = " + ns + ", notThis = " + notThis);
        } while (notThis != null && ns.equals(notThis));
        return ns;
    }

    public TreePath getRandomTermPath() {
        OBOClass oboClass = this.getRandomClass();
        TreePath[] paths = TermUtil.getPaths(oboClass);
        int index = (int)Math.floor(Math.random() * (double)paths.length);
        return paths[index];
    }

    public Namespace getRandomNamespace() {
        Iterator it = this.session.getNamespaces().iterator();
        int index = (int)(Math.random() * (double)this.session.getNamespaces().size());
        System.err.println("random_index = " + index);
        Namespace o = null;
        for (int i = 0; it.hasNext() && (i < index || o == null); ++i) {
            o = (Namespace)it.next();
        }
        return o;
    }

    public IdentifiedObject getRandomObject(Class c) {
        Iterator it = this.session.getObjects().iterator();
        int index = (int)(Math.random() * (double)this.session.getObjects().size());
        IdentifiedObject o = null;
        for (int i = 0; it.hasNext() && (i < index || o == null); ++i) {
            IdentifiedObject temp = (IdentifiedObject)it.next();
            if (TermUtil.isObsolete(temp) || !c.isInstance(temp)) continue;
            o = temp;
        }
        return o;
    }

    public Link getRandomLink() {
        int count = 0;
        Iterator it = this.session.getObjects().iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof LinkedObject)) continue;
            count += ((LinkedObject)io).getParents().size();
        }
        int index = (int)(Math.random() * (double)count);
        it = this.session.getObjects().iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof LinkedObject)) continue;
            Iterator it2 = ((LinkedObject)io).getParents().iterator();
            while (it2.hasNext()) {
                Link link = (Link)it2.next();
                if (index == 0) {
                    return link;
                }
                --index;
            }
        }
        return null;
    }

    public static OBOSession getSession(String path) throws DataAdapterException {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.getReadPaths().add(path);
        OBOSession session = (OBOSession)adapter.doOperation(IOOperation.READ, (AdapterConfiguration)config, null);
        return session;
    }

    public static void sessionCheck(TestCase test, OBOSession a, OBOSession b) {
        HistoryList allChanges = HistoryGenerator.getHistory(a, b);
        TestCase.assertTrue((String)("Differences found in sessions " + a + " and " + b), (allChanges.size() == 0 ? 1 : 0) != 0);
    }

    public static void fileCheck(TestCase test, File a, File b) throws IOException {
        String bstr;
        String astr;
        BufferedReader readera = new BufferedReader(new FileReader(a));
        BufferedReader readerb = new BufferedReader(new FileReader(b));
        do {
            astr = readera.readLine();
            bstr = readerb.readLine();
            if (astr == null || bstr == null) {
                if (astr == bstr) break;
                TestCase.fail((String)"Different numbers of lines in files to compare");
            }
            if ((astr.startsWith("date") || astr.startsWith("saved-by") || astr.startsWith("auto-generated-by") || astr.startsWith("format-version") || astr.startsWith("remark") || astr.startsWith("!")) && (!astr.startsWith("!") || !astr.startsWith("type"))) continue;
            TestCase.assertTrue((String)("Lines '" + astr + "' & '" + bstr + "' don't match"), (boolean)astr.equals(bstr));
        } while (astr != null && bstr != null);
    }

    public static Test createSuite(TestCase test, int count) {
        TestSuite suite = new TestSuite();
        for (int i = 0; i < count; ++i) {
            suite.addTest((Test)test);
        }
        return suite;
    }
}

