/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.verify;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.FilterPairEditor;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.filters.FilterPair;
import org.geneontology.oboedit.gui.filters.FilterPairImpl;
import org.geneontology.oboedit.verify.AbstractCheck;
import org.geneontology.oboedit.verify.CheckConfiguration;
import org.geneontology.oboedit.verify.CheckWarning;
import org.geneontology.oboedit.verify.ObjectCheck;
import org.geneontology.oboedit.verify.UserCheck;

public class UserFilterCheck
extends AbstractCheck
implements ObjectCheck,
UserCheck {
    protected ConfigurationPanel configurationPanel = new ConfigurationPanel();

    protected CheckConfiguration createConfiguration() {
        return new UserFilterConfiguration();
    }

    public String getDescription() {
        return ((UserFilterConfiguration)this.configuration).getDescription();
    }

    public FilterPair getFilter() {
        return ((UserFilterConfiguration)this.configuration).getFilter();
    }

    public String getMessage() {
        return ((UserFilterConfiguration)this.configuration).getMessage();
    }

    public boolean isFatal() {
        return ((UserFilterConfiguration)this.configuration).isFatal();
    }

    public Collection check(OBOSession session, IdentifiedObject currentObject, byte condition, boolean checkObsoletes) {
        LinkedList<CheckWarning> out = new LinkedList<CheckWarning>();
        if (this.getFilter().getLinkFilter() != null && currentObject instanceof LinkedObject) {
            Iterator it = ((LinkedObject)currentObject).getParents().iterator();
            while (it.hasNext()) {
                Link link = (Link)it.next();
                if (!this.getFilter().getLinkFilter().satisfies(link)) continue;
                out.add(new CheckWarning("Link " + link + " " + this.getMessage(), this.isFatal(), this, currentObject));
                break;
            }
        }
        if (this.getFilter().getObjectFilter() != null && this.getFilter().getObjectFilter().satisfies(currentObject)) {
            out.add(new CheckWarning("Term " + currentObject.getName() + " (" + currentObject.getID() + ") " + this.getMessage(), this.isFatal(), this, currentObject));
        }
        return out;
    }

    public JComponent getConfigurationPanel() {
        this.configurationPanel.loadConfiguration();
        return this.configurationPanel;
    }

    public String getID() {
        return "USER_FILTER_CHECK";
    }

    protected class ConfigurationPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        protected FilterPairEditor filterPairEditor = new FilterPairEditor();
        protected JTextField messageField = new JTextField("contains errors");
        protected JTextField descField = new JTextField(30);
        protected JCheckBox fatalCheckBox = new JCheckBox("Is fatal");

        public ConfigurationPanel() {
            JLabel messageLabel = new JLabel("Message suffix (message will begin with \"Term <term name> \")");
            JLabel descriptionLabel = new JLabel("Check name");
            Box northPanel = new Box(0);
            northPanel.add(descriptionLabel);
            northPanel.add(Box.createHorizontalStrut(10));
            northPanel.add(this.descField);
            this.fatalCheckBox.setOpaque(false);
            messageLabel.setFont(Preferences.getPreferences().getFont());
            descriptionLabel.setFont(Preferences.getPreferences().getFont());
            this.messageField.setFont(Preferences.getPreferences().getFont());
            this.fatalCheckBox.setFont(Preferences.getPreferences().getFont());
            Box southPanel = new Box(1);
            southPanel.add(messageLabel);
            southPanel.add(this.messageField);
            southPanel.add(this.fatalCheckBox);
            this.setBackground(Controller.getController().getPreferences().getBackgroundColor());
            this.filterPairEditor.setBackground(Controller.getController().getPreferences().getBackgroundColor());
            this.filterPairEditor.setButtonColor(Controller.getController().getPreferences().getButtonColor());
            this.filterPairEditor.setFont(Controller.getController().getPreferences().getFont());
            this.filterPairEditor.setRendererOptionAllowed(false);
            this.filterPairEditor.setKeywordOptionAllowed(false);
            this.setLayout(new BorderLayout());
            this.add((Component)northPanel, "North");
            this.add((Component)this.filterPairEditor, "Center");
            this.add((Component)southPanel, "South");
            this.validate();
            this.repaint();
        }

        public void actionPerformed(ActionEvent e) {
            this.updateConfiguration();
        }

        protected void updateConfiguration() {
            ((UserFilterConfiguration)UserFilterCheck.this.configuration).setFilter(this.filterPairEditor.getFilterPair());
            ((UserFilterConfiguration)UserFilterCheck.this.configuration).setDescription(this.descField.getText());
            ((UserFilterConfiguration)UserFilterCheck.this.configuration).setMessage(this.messageField.getText());
            ((UserFilterConfiguration)UserFilterCheck.this.configuration).setIsFatal(this.fatalCheckBox.isSelected());
        }

        protected void loadConfiguration() {
            this.filterPairEditor.setFilterPair(((UserFilterConfiguration)UserFilterCheck.this.configuration).getFilter());
            this.messageField.setText(((UserFilterConfiguration)UserFilterCheck.this.configuration).getMessage());
            this.descField.setText(((UserFilterConfiguration)UserFilterCheck.this.configuration).getDescription());
            this.fatalCheckBox.setSelected(((UserFilterConfiguration)UserFilterCheck.this.configuration).isFatal());
        }
    }

    public static class UserFilterConfiguration
    extends CheckConfiguration {
        protected FilterPair filter = new FilterPairImpl();
        protected String message = "";
        protected boolean isFatal = false;
        protected String desc = "<new filter>";

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setFilter(FilterPair filter) {
            this.filter = filter;
        }

        public FilterPair getFilter() {
            return this.filter;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isFatal() {
            return this.isFatal;
        }

        public void setIsFatal(boolean isFatal) {
            this.isFatal = isFatal;
        }
    }
}

