/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.impl.level2.Level2FactoryImpl;
import org.biopax.paxtools.io.jena.JenaIOHandler;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.Level2Factory;
import org.biopax.paxtools.model.level2.XReferrable;
import org.biopax.paxtools.model.level2.relationshipXref;
import org.biopax.paxtools.model.level2.unificationXref;

public class GOUnificationXREFtoRelationshipXREFConverter {
    private static Log log = LogFactory.getLog(GOUnificationXREFtoRelationshipXREFConverter.class);
    static Level2Factory factory = new Level2FactoryImpl();
    static JenaIOHandler jenaIOHandler = new JenaIOHandler(factory, BioPAXLevel.L2);

    public static void main(String[] args) throws IllegalAccessException, InvocationTargetException {
        for (String arg : args) {
            log.info((Object)arg);
            if (!arg.toLowerCase().endsWith("owl")) continue;
            try {
                GOUnificationXREFtoRelationshipXREFConverter.processXrefs(arg);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static void processXrefs(String arg) throws FileNotFoundException, IllegalAccessException, InvocationTargetException {
        FileInputStream in = new FileInputStream(new File(arg));
        Model level2 = jenaIOHandler.convertFromOWL(in);
        Set<unificationXref> unis = level2.getObjects(unificationXref.class);
        HashSet<unificationXref> gos = new HashSet<unificationXref>();
        for (unificationXref uni : unis) {
            log.trace((Object)uni.getDB());
            if (!uni.getDB().equalsIgnoreCase("GO")) continue;
            log.info((Object)("scheduling " + uni.getRDFId()));
            gos.add(uni);
        }
        for (unificationXref go : gos) {
            GOUnificationXREFtoRelationshipXREFConverter.convert(go, level2);
        }
        jenaIOHandler.convertToOWL(level2, new FileOutputStream(arg.substring(0, arg.lastIndexOf(46)) + "-converted.owl"));
    }

    private static void convert(unificationXref uni, Model level2) {
        HashSet<XReferrable> referrables = new HashSet<XReferrable>(uni.isXREFof());
        level2.remove(uni);
        relationshipXref relationshipXref2 = factory.createRelationshipXref();
        relationshipXref2.setRDFId(uni.getRDFId());
        relationshipXref2.setCOMMENT(uni.getCOMMENT());
        relationshipXref2.setDB(uni.getDB());
        relationshipXref2.setDB_VERSION(uni.getDB_VERSION());
        relationshipXref2.setID(uni.getID());
        relationshipXref2.setID_VERSION(uni.getID_VERSION());
        relationshipXref2.setRELATIONSHIP_TYPE("http://www.biopax.org/paxtools/convertedGOUnificationXREF");
        level2.add(relationshipXref2);
        for (XReferrable referrable : referrables) {
            referrable.addXREF(relationshipXref2);
        }
    }
}

