/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.io.jena.JenaIOHandler;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.unificationXref;
import org.biopax.paxtools.util.ClassFilterSet;

public class UnificationIDtoRDFIDLister {
    private static Log log = LogFactory.getLog(UnificationIDtoRDFIDLister.class);
    static JenaIOHandler jenaIOHandler = new JenaIOHandler(null, BioPAXLevel.L2);

    public static void main(String[] args) throws IllegalAccessException, InvocationTargetException {
        for (String arg : args) {
            log.info((Object)arg);
            if (!arg.toLowerCase().endsWith("owl")) continue;
            try {
                UnificationIDtoRDFIDLister.processXrefs(arg);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static void processXrefs(String arg) throws FileNotFoundException, IllegalAccessException, InvocationTargetException {
        FileInputStream in = new FileInputStream(new File(arg));
        Model level2 = jenaIOHandler.convertFromOWL(in);
        Set<unificationXref> unis = level2.getObjects(unificationXref.class);
        for (unificationXref uni : unis) {
            ClassFilterSet<physicalEntity> referrables = new ClassFilterSet<physicalEntity>(uni.isXREFof(), physicalEntity.class);
            for (Object e : referrables) {
                System.out.print(uni.getDB() + " : " + uni.getID() + " refers to " + ((physicalEntity)e).getRDFId());
            }
        }
    }
}

