/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.impl.level3.EntityImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.util.BidirectionalLinkViolationException;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PhysicalEntityImpl
extends EntityImpl
implements PhysicalEntity {
    Set<PhysicalEntity> bindsTo = new HashSet<PhysicalEntity>();
    private CellularLocationVocabulary cellularLocation;
    private Complex ownerComplex;
    private Set<EntityFeature> feature = new HashSet<EntityFeature>();
    private Set<EntityFeature> noFeature = new HashSet<EntityFeature>();
    private EntityReference entityReference;

    @Override
    public Class<? extends BioPAXElement> getModelInterface() {
        return PhysicalEntity.class;
    }

    private boolean checkPartner(PhysicalEntity physicalEntity2) {
        return physicalEntity2.getBindsTo().contains(this);
    }

    @Override
    public void removeBindsTo(PhysicalEntity physicalEntity2) {
        this.bindsTo.remove(physicalEntity2);
        if (this.checkPartner(physicalEntity2)) {
            physicalEntity2.removeBindsTo(physicalEntity2);
        }
    }

    @Override
    public void setBindsTo(Set<PhysicalEntity> bindsTo) {
        this.bindsTo = bindsTo;
    }

    @Override
    public Set<PhysicalEntity> getBindsTo() {
        return this.bindsTo;
    }

    @Override
    public void addBindsTo(PhysicalEntity bindsTo) {
        this.bindsTo.add(bindsTo);
        if (!this.checkPartner(bindsTo)) {
            bindsTo.addBindsTo(this);
        }
    }

    @Override
    public Complex isComponentOf() {
        return this.ownerComplex;
    }

    @Override
    public void setComponentOf(Complex newComplex) {
        if (this.ownerComplex != null && (this.ownerComplex.getComponent().contains(this) || newComplex != null && !newComplex.getComponent().contains(this))) {
            throw new BidirectionalLinkViolationException(this, newComplex);
        }
        this.ownerComplex = newComplex;
    }

    @Override
    public CellularLocationVocabulary getCellularLocation() {
        return this.cellularLocation;
    }

    @Override
    public void setCellularLocation(CellularLocationVocabulary location) {
        this.cellularLocation = location;
    }

    @Override
    public Set<EntityFeature> getFeature() {
        return this.feature;
    }

    @Override
    public void addFeature(EntityFeature feature) {
        this.checkAndAddFeature(feature, feature.isFeatureOf());
        this.feature.add(feature);
    }

    @Override
    public void removeFeature(EntityFeature feature) {
        this.checkAndRemoveFeature(feature, feature.isFeatureOf());
        this.feature.remove(feature);
    }

    @Override
    public void setFeature(Set<EntityFeature> feature) {
        this.feature = feature;
    }

    @Override
    public Set<EntityFeature> getNotFeature() {
        return this.noFeature;
    }

    @Override
    public void addNotFeature(EntityFeature feature) {
        this.checkAndAddFeature(feature, feature.isNoFeatureOf());
        this.noFeature.add(feature);
    }

    @Override
    public void removeNotFeature(EntityFeature feature) {
        this.checkAndRemoveFeature(feature, feature.isNoFeatureOf());
        this.noFeature.remove(feature);
    }

    @Override
    public void setNotFeature(Set<EntityFeature> featureSet) {
        this.noFeature = featureSet;
    }

    private void checkAndAddFeature(EntityFeature feature, Set<PhysicalEntity> target) {
        if (feature.isFeatureOf().contains(this) || feature.isNoFeatureOf().contains(this)) {
            throw new IllegalBioPAXArgumentException("Illegal attempt to set the inverse link!");
        }
        target.add(this);
    }

    private void checkAndRemoveFeature(EntityFeature feature, Set<PhysicalEntity> target) {
        assert (feature.isFeatureOf().contains(this) ^ feature.isNoFeatureOf().contains(this));
        target.remove(this);
    }

    @Override
    public EntityReference getEntityReference() {
        return this.entityReference;
    }

    @Override
    public void setEntityReference(EntityReference entityReference) {
        this.entityReference.isReferenceEntityOf().remove(this);
        this.entityReference = entityReference;
        this.entityReference.isReferenceEntityOf().add(this);
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        PhysicalEntity that = (PhysicalEntity)element;
        return this.getEntityReference().isEquivalent(that.getEntityReference()) && (this.cellularLocation != null ? !this.cellularLocation.isEquivalent(that.getCellularLocation()) : that.getCellularLocation() == null);
    }

    @Override
    public int equivalenceCode() {
        return 29 * this.entityReference.equivalenceCode() + this.cellularLocation.equivalenceCode();
    }
}

