/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level2;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.set.CompositeSet;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionRule;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.Direction;
import org.biopax.paxtools.model.level2.SpontaneousType;
import org.biopax.paxtools.model.level2.catalysis;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.interaction;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.process;
import org.biopax.paxtools.util.ClassFilterSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsecutiveCatalysisRule
implements InteractionRule {
    @Override
    public void inferInteractions(Set<SimpleInteraction> interactionSet, physicalEntity pe, Model model, Map options) {
        if (options.containsKey((Object)BinaryInteractionType.SEQUENTIAL_CATALYSIS) && options.get((Object)BinaryInteractionType.SEQUENTIAL_CATALYSIS).equals(false)) {
            return;
        }
        Set<catalysis> catalysises = pe.getAllInteractions(catalysis.class);
        for (catalysis aCatalysis : catalysises) {
            SpontaneousType catalysisDirection = this.mapDirectionToSpontaneous(aCatalysis.getDIRECTION());
            Set<process> controlled = aCatalysis.getCONTROLLED();
            for (process process2 : controlled) {
                conversion aConversion = (conversion)process2;
                SpontaneousType direction = this.findConsensusDirection(catalysisDirection, aConversion.getSPONTANEOUS());
                assert (direction != null);
                Set<physicalEntity> interactors = this.getInteractors(aConversion, direction);
                for (physicalEntity interactor : interactors) {
                    interactionSet.add(new SimpleInteraction(pe, interactor, BinaryInteractionType.SEQUENTIAL_CATALYSIS));
                }
            }
        }
    }

    private SpontaneousType findConsensusDirection(SpontaneousType direction1, SpontaneousType direction2) {
        boolean first = this.isReversible(direction1);
        boolean second = this.isReversible(direction2);
        SpontaneousType consensus = first ? (second ? SpontaneousType.NOT_SPONTANEOUS : direction2) : (second ? direction1 : (direction1.equals((Object)direction2) ? direction1 : null));
        return consensus;
    }

    private boolean isReversible(SpontaneousType direction1) {
        return direction1 == null || direction1.equals((Object)SpontaneousType.NOT_SPONTANEOUS);
    }

    private Set<physicalEntity> getInteractors(conversion centerConversion, SpontaneousType direction) {
        HashSet<physicalEntity> interactors = new HashSet<physicalEntity>();
        Set<physicalEntityParticipant> peps = this.getCompatiblePEPs(direction, centerConversion);
        Set<conversion> conversions = this.getCompatibleConversions(peps, direction);
        for (conversion neighbor : conversions) {
            this.findAndAddCatalysts(neighbor, interactors, direction);
        }
        return interactors;
    }

    private Set<physicalEntityParticipant> getCompatiblePEPs(SpontaneousType direction, conversion aConversion) {
        switch (direction) {
            case L_R: {
                return aConversion.getRIGHT();
            }
            case R_L: {
                return aConversion.getLEFT();
            }
        }
        return new CompositeSet(new Set[]{aConversion.getLEFT(), aConversion.getRIGHT()});
    }

    private Set<conversion> getCompatibleConversions(Set<physicalEntityParticipant> peps, SpontaneousType direction) {
        HashSet<conversion> compatibleConversions = new HashSet<conversion>();
        for (physicalEntityParticipant pep : peps) {
            Set<physicalEntityParticipant> npeps = pep.getPHYSICAL_ENTITY().isPHYSICAL_ENTITYof();
            for (physicalEntityParticipant npep : npeps) {
                conversion aConversion;
                if (pep.equals(npep) || !pep.isInEquivalentState(npep) || npep.isPARTICIPANTSof().isEmpty()) continue;
                assert (npep.isPARTICIPANTSof().size() == 1);
                interaction anI = npep.isPARTICIPANTSof().iterator().next();
                if (!(anI instanceof conversion) || this.findConsensusDirection(direction, (aConversion = (conversion)anI).getSPONTANEOUS()) == null || !this.participantIsAtACompatibleSide(direction, npep, aConversion)) continue;
                compatibleConversions.add(aConversion);
            }
        }
        return compatibleConversions;
    }

    private boolean participantIsAtACompatibleSide(SpontaneousType direction, physicalEntityParticipant npep, conversion aConversion) {
        switch (direction) {
            case L_R: {
                return aConversion.getLEFT().contains(npep);
            }
            case R_L: {
                return aConversion.getRIGHT().contains(npep);
            }
        }
        return aConversion.getRIGHT().contains(npep) || aConversion.getLEFT().contains(npep);
    }

    private void findAndAddCatalysts(conversion aConversion, Set<physicalEntity> pes, SpontaneousType direction) {
        Set<control> controls = aConversion.isCONTROLLEDOf();
        for (catalysis aCatalysis : new ClassFilterSet<catalysis>(controls, catalysis.class)) {
            if (this.findConsensusDirection(direction, this.mapDirectionToSpontaneous(aCatalysis.getDIRECTION())) == null) continue;
            for (physicalEntityParticipant pepi : aCatalysis.getCONTROLLER()) {
                pes.add(pepi.getPHYSICAL_ENTITY());
            }
        }
    }

    private SpontaneousType mapDirectionToSpontaneous(Direction direction) {
        if (direction != null) {
            switch (direction) {
                case IRREVERSIBLE_LEFT_TO_RIGHT: 
                case PHYSIOL_LEFT_TO_RIGHT: {
                    return SpontaneousType.L_R;
                }
                case IRREVERSIBLE_RIGHT_TO_LEFT: 
                case PHYSIOL_RIGHT_TO_LEFT: {
                    return SpontaneousType.R_L;
                }
            }
        }
        return null;
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return Arrays.asList(BinaryInteractionType.SEQUENTIAL_CATALYSIS);
    }
}

