/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.simpleIO;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.io.simpleIO.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;

public class SimpleExporter {
    private EditorMap editorMap;
    public static final String owlNS = "http://www.w3.org/2002/07/owl#";
    public static final String xsdNS = "http://www.w3.org/2001/XMLSchema#";
    public static final String rdfNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String RDF_ID = "rdf:ID=\"";
    public static final String RDF_about = "rdf:about=\"";
    public static final String close = "\">";
    String base;
    String bp;
    Map<String, String> nsMap;
    Map<String, String> reverseMap;

    public SimpleExporter(BioPAXLevel level) {
        this.editorMap = new SimpleEditorMap(level);
    }

    public void convertToOWL(Model model, OutputStream outputStream) throws IOException, IllegalAccessException, InvocationTargetException {
        this.initialize(model);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.writeHeader(out);
        this.writeObjects(out, model);
        out.write("\n</rdf:RDF>");
        ((Writer)out).close();
    }

    private void writeObjects(Writer out, Model model) throws IOException {
        Set<BioPAXElement> bioPAXElements = model.getObjects();
        for (BioPAXElement bean : bioPAXElements) {
            String name = this.bp + ":" + bean.getModelInterface().getSimpleName();
            this.writeIDLine(out, bean, name);
            for (PropertyEditor editor : this.editorMap.getEditorsOf(bean)) {
                Object value = editor.getValueFromBean(bean);
                if (value == null || editor.isUnknown(value)) continue;
                if (editor.isMultipleCardinality()) {
                    for (Object valueElement : (Set)value) {
                        this.writeStatementFor(bean, editor, valueElement, out);
                    }
                    continue;
                }
                this.writeStatementFor(bean, editor, value, out);
            }
            out.write("\n</" + name + ">");
        }
    }

    private void writeStatementFor(BioPAXElement bean, PropertyEditor editor, Object value, Writer out) throws IOException {
        assert (bean != null && editor != null);
        String prop = this.bp + ":" + editor.getProperty();
        out.write("\n <" + prop);
        if (value instanceof BioPAXElement) {
            String id = ((BioPAXElement)value).getRDFId();
            assert (id != null);
            if (this.base != null && id.startsWith(this.base)) {
                id = id.substring(id.lastIndexOf(35));
            }
            out.write(" rdf:resource=\"" + id + "\" />");
        } else {
            String type = this.findLiteralType(editor);
            String valString = this.escapeXml(value.toString());
            out.write(" rdf:datatype = \"xsd:" + type + close + valString + "</" + prop + ">");
        }
    }

    private String escapeXml(String str) {
        str = str.replace("&", "&amp;");
        str = str.replace("<", "&lt;");
        str = str.replace(">", "&gt;");
        str = str.replace("\"", "&quot;");
        str = str.replace("'", "&apos;");
        return str;
    }

    private String findLiteralType(PropertyEditor editor) {
        Class range = editor.getRange();
        String type = null;
        if (range.isEnum() || range.equals(String.class)) {
            type = "string";
        } else if (range.equals(Double.TYPE)) {
            type = "double";
        } else if (range.equals(Integer.TYPE)) {
            type = "int";
        } else if (range.equals(Float.TYPE)) {
            type = "float";
        }
        return type;
    }

    private void writeIDLine(Writer out, BioPAXElement bpe, String name) throws IOException {
        out.write("\n\n<" + name + " ");
        String s = bpe.getRDFId();
        int index = s.lastIndexOf(35) + 1;
        if (s.substring(0, index).equals(this.base)) {
            String id = s.substring(index);
            out.write(RDF_ID + id + close);
        } else {
            out.write(RDF_about + s + close);
        }
    }

    private void initialize(Model model) {
        this.base = null;
        this.bp = null;
        this.nsMap = model.getNameSpacePrefixMap();
        String owlPre = null;
        String rdfPre = null;
        String xsdPre = null;
        this.reverseMap = new HashMap<String, String>();
        for (String pre : this.nsMap.keySet()) {
            String ns = this.nsMap.get(pre);
            if (ns.equalsIgnoreCase(rdfNS)) {
                rdfPre = pre;
            } else if (ns.equalsIgnoreCase(owlNS)) {
                owlPre = pre;
            } else if (ns.equalsIgnoreCase(xsdNS)) {
                xsdPre = pre;
            }
            this.reverseMap.put(ns, pre);
        }
        if (owlPre != null) {
            this.reverseMap.remove(this.nsMap.get(owlPre));
            this.nsMap.remove(owlPre);
        }
        if (rdfPre != null) {
            this.reverseMap.remove(this.nsMap.get(rdfPre));
            this.nsMap.remove(rdfPre);
        }
        if (xsdPre != null) {
            this.reverseMap.remove(this.nsMap.get(xsdPre));
            this.nsMap.remove(xsdPre);
        }
        this.nsMap.put("rdf", rdfNS);
        this.nsMap.put("owl", owlNS);
        this.nsMap.put("xsd", rdfNS);
    }

    private void writeHeader(Writer out) throws IOException {
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.write("\n<rdf:RDF");
        String bpns = this.editorMap.getLevel().getNameSpace();
        for (String pre : this.nsMap.keySet()) {
            String ns = this.nsMap.get(pre);
            if (pre.equals("")) {
                this.base = ns;
            } else {
                if (ns.equalsIgnoreCase(bpns)) {
                    this.bp = pre;
                }
                pre = ":" + pre;
            }
            out.write("\n xmlns" + pre + "=\"" + ns + "\"");
        }
        if (this.bp == null) {
            this.bp = "bp";
            out.write("\n xmlns:bp=\"" + bpns + "\"");
        }
        if (this.base != null) {
            out.write("\n xml:base=\"" + this.base + "\"");
        }
        out.write(">");
        out.write("\n<owl:Ontology rdf:about=\"\">");
        out.write("\n <owl:imports rdf:resource=\"http://www.biopax.org/release/biopax-level2.owl\" />");
        out.write("\n</owl:Ontology>");
    }
}

