/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.dataadapter;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.AdapterWidgetI;
import org.geneontology.dataadapter.DataAdapter;
import org.geneontology.dataadapter.DataAdapterException;
import org.geneontology.dataadapter.DataAdapterRegistry;
import org.geneontology.dataadapter.DataAdapterUI;
import org.geneontology.dataadapter.DataAdapterUIException;
import org.geneontology.dataadapter.DataAdapterUIFactory;
import org.geneontology.dataadapter.DataAdapterUtil;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.dataadapter.ParameterUI;
import org.geneontology.util.ProgressListener;
import org.geneontology.util.Tag;
import org.geneontology.util.TagSpec;

public class CommandLineWidget
implements AdapterWidgetI {
    protected static CommandLineWidget self = new CommandLineWidget();
    static /* synthetic */ Class class$0;

    private CommandLineWidget() {
    }

    public static TagSpec getTagSpec(DataAdapterRegistry registry, DataAdapter defaultAdapter, IOOperation op, Object input) {
        TagSpec outerSpec = new TagSpec("-adapter", "<adapter options>");
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.geneontology.dataadapter.ParameterUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] classes = classArray;
        DataAdapter[] adapters = DataAdapterUtil.getAdapters(registry, IOOperation.READ, classes);
        DataAdapterUIFactory factory = registry.getUIFactory();
        int i = 0;
        while (i < adapters.length) {
            TagSpec adapterSpec = new TagSpec("-" + adapters[i].getID());
            outerSpec.addArgumentSpec(adapterSpec, 1);
            if (adapters[i].equals(defaultAdapter)) {
                outerSpec.setImpliedSpec(adapterSpec, 1);
            }
            Collection uis = factory.getUIs(adapters[i]);
            DataAdapterUI ui = DataAdapterUtil.getUI(adapters[i], registry, classes);
            if (ui != null) {
                ui.init(self, op, adapters[i], input);
                TagSpec spec = ((ParameterUI)ui).getParameterSpec().copy("-options");
                ui.cleanup();
                adapterSpec.addArgumentSpec(spec, 1);
                adapterSpec.setImpliedSpec(spec, 1);
            }
            ++i;
        }
        return outerSpec;
    }

    public static Object execute(DataAdapterRegistry registry, IOOperation op, Tag params, Object input, List listeners) throws DataAdapterUIException, DataAdapterException {
        Tag tag;
        if (!params.getName().equals("-adapter")) {
            throw new DataAdapterUIException("Invalid argument: " + params.getName() + ". " + "CommandLineWidget requires an " + "-adapter argument");
        }
        Tag adapterTag = null;
        Tag adapterOptions = null;
        DataAdapter adapter = null;
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.geneontology.dataadapter.ParameterUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] classes = classArray;
        Iterator it = params.getArguments().iterator();
        while (it.hasNext()) {
            tag = (Tag)it.next();
            adapter = registry.getAdapter(tag.getName().substring(1));
            if (adapter == null) continue;
            adapterTag = tag;
            break;
        }
        if (adapter == null) {
            throw new DataAdapterUIException("No adapter specified!");
        }
        it = adapterTag.getArguments().iterator();
        while (it.hasNext()) {
            tag = (Tag)it.next();
            if (!tag.getName().equals("-options")) continue;
            adapterOptions = tag;
            break;
        }
        if (adapterOptions == null) {
            adapterOptions = new Tag("-options", true);
        }
        DataAdapterUI ui = null;
        ui = DataAdapterUtil.getUI(adapter, registry, classes);
        if (ui == null) {
            throw new DataAdapterException("Adapter " + adapter.getID() + " does " + "not support command line " + "arguments.");
        }
        System.err.println("adapter = " + adapter + ", adapterOptions = " + adapterOptions);
        ui.init(self, op, adapter, input);
        ((ParameterUI)ui).setParameters(adapterOptions);
        AdapterConfiguration config = ui.getConfig(op, adapter, input);
        ui.cleanup();
        it = listeners.iterator();
        while (it.hasNext()) {
            ProgressListener listener = (ProgressListener)it.next();
            adapter.addProgressListener(listener);
        }
        Object output = adapter.doOperation(op, config, input);
        it = listeners.iterator();
        while (it.hasNext()) {
            ProgressListener listener = (ProgressListener)it.next();
            adapter.removeProgressListener(listener);
        }
        return output;
    }
}

