/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.expression.parser;

import org.geneontology.expression.ExpressionException;
import org.geneontology.expression.JexlContext;
import org.geneontology.expression.parser.ASTJexlScript;
import org.geneontology.expression.parser.Node;
import org.geneontology.expression.parser.Parser;
import org.geneontology.expression.parser.ParserTreeConstants;
import org.geneontology.expression.parser.ParserVisitor;
import org.geneontology.expression.parser.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Parser parser;
    public Token first_token;
    public Token last_token;

    public SimpleNode(int i) {
        this.id = i;
    }

    public int getLineNum() {
        return this.first_token.beginLine;
    }

    public int getCharNum() {
        return this.first_token.beginColumn;
    }

    public void throwExpressionException(String message, Exception e) throws ExpressionException {
        throw new ExpressionException(message, e, this.getLineNum(), this.getCharNum());
    }

    public void throwExpressionException(String message) throws ExpressionException {
        this.throwExpressionException(message, null);
    }

    public SimpleNode(Parser p, int i) {
        this(i);
        this.parser = p;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(ParserVisitor visitor, Object data) {
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                this.children[i].jjtAccept(visitor, data);
                ++i;
            }
        }
        return data;
    }

    public String toString() {
        return ParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return String.valueOf(prefix) + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    n.dump(String.valueOf(prefix) + " ");
                }
                ++i;
            }
        }
    }

    public boolean interpret(JexlContext pc) throws ExpressionException {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            SimpleNode node = (SimpleNode)this.jjtGetChild(i);
            if (!node.interpret(pc)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object value(JexlContext context) throws Exception {
        return null;
    }

    public Object setValue(JexlContext context, Object value) throws Exception {
        return null;
    }

    public Object execute(Object o, JexlContext ctx) throws Exception {
        return null;
    }

    public ASTJexlScript getEnclosingScript() {
        SimpleNode p = (SimpleNode)this.jjtGetParent();
        while (p != null && !(p instanceof ASTJexlScript)) {
            p = (SimpleNode)p.jjtGetParent();
        }
        return (ASTJexlScript)p;
    }
}

