/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.io;

import java.io.File;
import java.io.FilenameFilter;

public class ExtensionFilenameFilter
implements FilenameFilter {
    protected String[] extensions;
    protected String desc;
    protected boolean showHidden;

    private static String[] createExtensionArray(String ext) {
        String[] exts = new String[]{ext};
        return exts;
    }

    public ExtensionFilenameFilter(String extension) {
        this(extension, null);
    }

    public ExtensionFilenameFilter(String extension, String desc) {
        this(ExtensionFilenameFilter.createExtensionArray(extension), desc);
    }

    public ExtensionFilenameFilter(String[] extensions) {
        this(extensions, null);
    }

    public ExtensionFilenameFilter(String[] extensions, String desc) {
        this.extensions = extensions;
        this.desc = desc;
        this.showHidden = false;
    }

    public boolean accept(File dir, String file) {
        File path = new File(dir, file);
        if (!this.showHidden && file.startsWith(".")) {
            return false;
        }
        if (path.isDirectory()) {
            return true;
        }
        int i = 0;
        while (i < this.extensions.length) {
            if (file.endsWith("." + this.extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    public boolean getShowHidden() {
        return this.showHidden;
    }

    protected String getExtensionDesc() {
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < this.extensions.length) {
            if (i > 0) {
                out.append(",");
            }
            out.append("*." + this.extensions[i]);
            ++i;
        }
        return out.toString();
    }

    public String toString() {
        if (this.desc == null) {
            return this.getExtensionDesc();
        }
        return String.valueOf(this.desc) + " (" + this.getExtensionDesc() + ")";
    }
}

