/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DragListener;

public class BasicDragListener
implements DragListener {
    protected Image dragImage;
    protected Image disabledImage;
    protected Object data;
    protected Cursor cursor;
    protected static final Point offset = new Point(0, 0);

    public BasicDragListener(Object data, Image dragImage, Cursor cursor) {
        this.setDragData(data);
        this.setCursor(cursor);
        this.setDragImage(dragImage);
    }

    public Point getDragOffset(DragEvent e, boolean dropAllowed) {
        return offset;
    }

    public BasicDragListener(Object data) {
        this(data, null, null);
    }

    public BasicDragListener(Object data, Image image) {
        this(data, image, null);
    }

    public BasicDragListener(Object data, Cursor cursor) {
        this(data, null, cursor);
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public void setDragImage(Image dragImage) {
        this.dragImage = dragImage;
        this.disabledImage = dragImage != null ? BasicDragListener.createDisabled(dragImage) : null;
    }

    public void setDragData(Object data) {
        this.data = data;
    }

    public boolean allowDrag(MouseEvent e) {
        return true;
    }

    public void dragEnd(DragEvent e) {
    }

    public void dragging(DragEvent e) {
    }

    public void dropped(DragEvent e) {
    }

    public Cursor getDragCursor(DragEvent e, boolean dropAllowed) {
        return this.cursor;
    }

    public Object getDragData(MouseEvent e) {
        return this.data;
    }

    public Image getDragImage(DragEvent e, boolean dropAllowed) {
        if (dropAllowed) {
            return this.dragImage;
        }
        return this.disabledImage;
    }

    protected static Image createDisabled(Image image) {
        BufferedImage newImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics g = newImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.setColor(new Color(0, 0, 0, 150));
        g.fillRect(0, 0, image.getWidth(null), image.getHeight(null));
        return newImage;
    }
}

