/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import org.geneontology.swing.AutoScrollSpec;
import org.geneontology.swing.DragContainer;
import org.geneontology.swing.DragFriendlyUI;
import org.geneontology.swing.DragSource;
import org.geneontology.swing.DropTarget;
import org.geneontology.swing.SwingUtil;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DragListener;
import org.geneontology.swing.event.DropListener;

public class DragController {
    protected static final int DEFAULT_DRAG_THRESHOLD = 20;
    protected int dragThreshold = 20;
    protected DragContainer dragContainer;
    protected Set dragContainers = new HashSet();
    protected boolean dragging;
    protected JWindow dragWindow = new DragWindow();
    protected boolean useDragContainers = true;
    protected boolean useFloatingWindow = false;
    protected boolean fixWindowSize = false;
    protected Image dragImage;
    protected Point dragOffset;
    protected int dragX;
    protected int dragY;
    protected Cursor dragCursor;
    protected Component lastDraggedOver;
    protected List lastDraggedOverTargets;
    protected Component draggedOver;
    protected List draggedOverTargets;
    protected Component currentDropComponent;
    protected Component currentDragSource;
    protected boolean canDrop;
    protected Map dropTargets;
    protected Map dragSources;
    protected Map scrollSpecs;
    protected AutoScrollSpec scrollSpec;
    protected Point lastMouseLoc = new Point();
    protected Point scratchPoint = new Point();
    protected Rectangle scratchRect = new Rectangle();
    protected Timer scrollTimer;
    protected ScrollTimerTask timerTask = new ScrollTimerTask();
    protected List windowList = new LinkedList();
    protected Window targetWindow;
    protected MouseInputAdapter windowTargetListener = new MouseInputAdapter(){

        protected void doSwitch(Window w) {
            if (DragController.this.targetWindow != null) {
                DragController.this.targetWindow.repaint();
            }
            if (DragController.this.targetWindow != null && DragController.this.targetWindow instanceof RootPaneContainer) {
                ((RootPaneContainer)((Object)DragController.this.targetWindow)).getGlassPane().setVisible(true);
            }
            DragController.this.targetWindow = w;
            if (DragController.this.targetWindow != null && DragController.this.targetWindow instanceof RootPaneContainer) {
                ((RootPaneContainer)((Object)DragController.this.targetWindow)).getGlassPane().setVisible(false);
            }
            if (DragController.this.targetWindow != null) {
                DragController.this.targetWindow.repaint();
            }
        }

        public void mouseEntered(MouseEvent e) {
            Window w = e.getComponent() instanceof Window ? (Window)e.getComponent() : SwingUtilities.getWindowAncestor(e.getComponent());
            this.doSwitch(w);
        }
    };
    protected HierarchyListener windowHierarchyListener = new HierarchyListener(){

        public void hierarchyChanged(HierarchyEvent e) {
            DragController.this.findDragContainers();
        }
    };
    protected static Point imagePoint = new Point();
    protected Area drawnArea = new Area();
    protected Rectangle dcBounds = new Rectangle();
    protected ResizeRunnable resizeRunnable = new ResizeRunnable();
    boolean animate = true;
    static final int ANIMATION_FRAMES = 10;
    static final int FRAME_TIME = 80;
    AnimationThread animationThread = new AnimationThread();
    protected Stack animationStack = new Stack();

    public void lockWindows(boolean lock) {
        Iterator it = this.windowList.iterator();
        while (it.hasNext()) {
            Window w = (Window)it.next();
            System.err.println("Locking window " + w);
            if (lock) {
                w.removeMouseListener(this.windowTargetListener);
                if (w instanceof RootPaneContainer) {
                    ((RootPaneContainer)((Object)w)).getGlassPane().removeMouseListener(this.windowTargetListener);
                }
            } else {
                w.addMouseListener(this.windowTargetListener);
                if (w instanceof RootPaneContainer) {
                    ((RootPaneContainer)((Object)w)).getGlassPane().addMouseListener(this.windowTargetListener);
                }
            }
            if (w instanceof RootPaneContainer) {
                RootPaneContainer pane = (RootPaneContainer)((Object)w);
                if (lock) {
                    pane.getGlassPane().setVisible(true);
                    ((JComponent)pane.getGlassPane()).setOpaque(true);
                    pane.getGlassPane().setBackground(Color.gray);
                    pane.getGlassPane().setEnabled(true);
                    pane.getGlassPane().validate();
                } else {
                    pane.getGlassPane().setVisible(pane != this.targetWindow);
                    ((JComponent)pane.getGlassPane()).setOpaque(false);
                }
            }
            w.repaint();
        }
    }

    public void imageChanged(Image dragImage, Point dragOffset, int dragX, int dragY, int width, int height) {
        boolean containersDrewEntireImage = false;
        int offsetx = 0;
        int offsety = 0;
        if (dragOffset != null) {
            offsetx = (int)dragOffset.getX();
            offsety = (int)dragOffset.getY();
        }
        if (this.useDragContainers) {
            this.drawnArea.reset();
            Iterator it = this.dragContainers.iterator();
            while (it.hasNext()) {
                DragContainer dc = (DragContainer)it.next();
                if (!containersDrewEntireImage) {
                    this.scratchRect.x = dragX - offsetx;
                    this.scratchRect.y = dragY - offsety;
                    this.scratchRect.width = width;
                    this.scratchRect.height = height;
                    DragController.imagePoint.x = 0;
                    DragController.imagePoint.y = 0;
                    imagePoint = SwingUtilities.convertPoint((Component)((Object)dc), imagePoint, this.currentDragSource);
                    this.dcBounds.x = DragController.imagePoint.x;
                    this.dcBounds.y = DragController.imagePoint.y;
                    this.dcBounds.width = ((Component)((Object)dc)).getWidth();
                    this.dcBounds.height = ((Component)((Object)dc)).getHeight();
                    Rectangle intersection = this.scratchRect.intersection(this.dcBounds);
                    this.drawnArea.add(new Area(this.scratchRect.intersection(this.dcBounds)));
                    if (this.drawnArea.contains(this.scratchRect)) {
                        containersDrewEntireImage = true;
                    }
                }
                DragController.imagePoint.x = dragX;
                DragController.imagePoint.y = dragY;
                imagePoint = SwingUtilities.convertPoint(this.currentDragSource, imagePoint, (Component)((Object)dc));
                dc.imageChanged(dragImage, DragController.imagePoint.x - offsetx, DragController.imagePoint.y - offsety, width, height);
            }
        }
        if (this.useFloatingWindow) {
            if (dragImage == null) {
                this.dragWindow.setVisible(false);
            } else if (!this.useDragContainers) {
                DragController.imagePoint.x = dragX;
                DragController.imagePoint.y = dragY;
                SwingUtilities.convertPointToScreen(imagePoint, this.currentDragSource);
                this.dragWindow.setBounds(DragController.imagePoint.x - offsetx, DragController.imagePoint.y - offsety, width, height);
                this.dragWindow.repaint();
                this.dragWindow.setVisible(true);
                this.dragWindow.toFront();
            } else {
                Rectangle windowBounds;
                this.scratchRect.x = dragX - offsetx;
                this.scratchRect.y = dragY - offsety;
                this.scratchRect.width = width;
                this.scratchRect.height = height;
                Area windowArea = new Area(this.scratchRect);
                windowArea.subtract(this.drawnArea);
                if (windowArea.isEmpty()) {
                    this.dragWindow.setVisible(false);
                } else if (this.fixWindowSize) {
                    windowBounds = windowArea.getBounds();
                    DragController.imagePoint.x = dragX - offsetx;
                    DragController.imagePoint.y = dragY - offsety;
                    SwingUtilities.convertPointToScreen(imagePoint, this.currentDragSource);
                    this.resizeRunnable.setBounds(DragController.imagePoint.x, DragController.imagePoint.y, width, height);
                    SwingUtilities.invokeLater(this.resizeRunnable);
                } else {
                    windowBounds = windowArea.getBounds();
                    DragController.imagePoint.x = (int)windowBounds.getX();
                    DragController.imagePoint.y = (int)windowBounds.getY();
                    SwingUtilities.convertPointToScreen(imagePoint, this.currentDragSource);
                    this.resizeRunnable.setBounds(DragController.imagePoint.x, DragController.imagePoint.y, (int)windowBounds.getWidth(), (int)windowBounds.getHeight());
                    SwingUtilities.invokeLater(this.resizeRunnable);
                }
            }
        }
    }

    public void setDragThreshold(int dragThreshold) {
        this.dragThreshold = dragThreshold;
    }

    protected void updateScroll() {
        if (this.lastMouseLoc == null || this.scrollSpec == null) {
            return;
        }
        Point vp = SwingUtilities.convertPoint(this.currentDragSource, this.lastMouseLoc, this.scrollSpec.getViewport());
        int intersect = SwingUtil.withinInsets(vp, this.scrollSpec.getInsets(), this.scrollSpec.getViewport());
        if (intersect == SwingUtil.NONE) {
            return;
        }
        Point originalScrollPos = this.scrollSpec.getViewport().getViewPosition();
        Point scrollPos = new Point(originalScrollPos.x, originalScrollPos.y);
        int scrollOffset = this.scrollSpec.getScrollDistance();
        if ((intersect & SwingUtil.TOP) != 0) {
            scrollPos.y -= scrollOffset;
        } else if ((intersect & SwingUtil.BOTTOM) != 0) {
            scrollPos.y += scrollOffset;
        }
        if ((intersect & SwingUtil.LEFT) != 0) {
            scrollPos.x -= scrollOffset;
        } else if ((intersect & SwingUtil.RIGHT) != 0) {
            scrollPos.x += scrollOffset;
        }
        if (scrollPos.x < 0) {
            scrollPos.x = 0;
        } else if (scrollPos.x >= this.scrollSpec.getComponent().getSize().width - this.scrollSpec.getViewport().getViewRect().width) {
            scrollPos.x = this.scrollSpec.getComponent().getSize().width - this.scrollSpec.getViewport().getViewRect().width;
        }
        if (scrollPos.y < 0) {
            scrollPos.y = 0;
        } else if (scrollPos.y >= this.scrollSpec.getComponent().getSize().height - this.scrollSpec.getViewport().getViewRect().height) {
            scrollPos.y = this.scrollSpec.getComponent().getSize().height - this.scrollSpec.getViewport().getViewRect().height;
        }
        if (!scrollPos.equals(originalScrollPos)) {
            this.scrollSpec.getViewport().setViewPosition(scrollPos);
            int xdelta = originalScrollPos.x - scrollPos.x;
            int ydelta = originalScrollPos.y - scrollPos.y;
            if (this.dragContainer != null && this.dragImage != null) {
                ((Component)((Object)this.dragContainer)).repaint(this.dragX - xdelta, this.dragY - ydelta, this.dragImage.getWidth(null) + xdelta, this.dragImage.getHeight(null) + ydelta);
            }
            this.lastMouseLoc.x -= xdelta;
            this.lastMouseLoc.y -= ydelta;
            this.scrollTimer.start();
        }
    }

    public List getWindowList() {
        return this.windowList;
    }

    public DragController(DragContainer container) {
        this.dragSources = new HashMap();
        this.dropTargets = new HashMap();
        this.scrollSpecs = new HashMap();
        this.setDragContainer(container);
        this.scrollTimer = new Timer(100, this.timerTask);
        this.scrollTimer.setRepeats(false);
        Timer.setLogTimers(false);
        this.scrollTimer.setInitialDelay(100);
        this.registerWindow(this.dragWindow);
        this.animationThread.start();
    }

    public void registerWindow(Window w) {
        w.addMouseListener(this.windowTargetListener);
        if (w instanceof RootPaneContainer) {
            JComponent glassPane = null;
            if (((RootPaneContainer)((Object)w)).getGlassPane() instanceof JComponent) {
                glassPane = (JComponent)((RootPaneContainer)((Object)w)).getGlassPane();
            }
            if (glassPane == null) {
                glassPane = new JPanel();
                ((RootPaneContainer)((Object)w)).setGlassPane(glassPane);
            }
            glassPane.addMouseListener(this.windowTargetListener);
            glassPane.setVisible(false);
        }
        w.addHierarchyListener(this.windowHierarchyListener);
        this.windowList.add(w);
        this.findDragContainers();
    }

    public void unregisterWindow(Window w) {
        w.removeMouseListener(this.windowTargetListener);
        if (w instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)w)).getGlassPane().removeMouseListener(this.windowTargetListener);
            ((RootPaneContainer)((Object)w)).getGlassPane().setVisible(false);
        }
        w.removeHierarchyListener(this.windowHierarchyListener);
        this.windowList.remove(w);
        this.findDragContainers();
    }

    protected void findDragContainers() {
        this.dragContainers.clear();
        int i = 0;
        while (i < this.windowList.size()) {
            this.findDragContainers((Window)this.windowList.get(i));
            ++i;
        }
    }

    protected void findDragContainers(Component c) {
        if (!(c instanceof Container)) {
            return;
        }
        if (c instanceof DragContainer) {
            this.dragContainers.add(c);
            return;
        }
        Component[] components = ((Container)c).getComponents();
        int i = 0;
        while (i < components.length) {
            this.findDragContainers(components[i]);
            ++i;
        }
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public boolean isAnimated() {
        return this.animate;
    }

    protected void setAnimation(List list) {
        this.animationStack.clear();
        int i = list.size() - 1;
        while (i >= 0) {
            this.animationStack.push(list.get(i));
            --i;
        }
    }

    protected List getDissolveFrames(Image dragImage, Image newImage) {
        LinkedList<AnimationFrame> out = new LinkedList<AnimationFrame>();
        int width = newImage.getWidth(null);
        if (dragImage.getWidth(null) > width) {
            width = dragImage.getWidth(null);
        }
        int height = newImage.getHeight(null);
        if (dragImage.getHeight(null) > height) {
            height = dragImage.getHeight(null);
        }
        float stageSize = 0.1f;
        int i = 0;
        while (i < 10) {
            BufferedImage frame = new BufferedImage(width, height, 2);
            out.add(new AnimationFrame(frame, this.dragOffset));
            Graphics2D g2 = (Graphics2D)((Image)frame).getGraphics();
            float colorVal = (float)i / 10.0f;
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f - stageSize * (float)i));
            g2.drawImage(dragImage, 0, 0, null);
            g2.setComposite(AlphaComposite.getInstance(3, stageSize * (float)i));
            g2.drawImage(newImage, 0, 0, null);
            ++i;
        }
        return out;
    }

    protected List getCollapseFrames(Image dragImage, Point p) {
        LinkedList<AnimationFrame> out = new LinkedList<AnimationFrame>();
        float stageSize = 0.1f;
        int i = 9;
        while (i >= 0) {
            int newwidth = dragImage.getWidth(null) * i / 10;
            int newheight = dragImage.getHeight(null) * i / 10;
            int xoffset = (int)(p.getX() * (double)i / 10.0);
            int yoffset = (int)(p.getY() * (double)i / 10.0);
            if (newwidth == 0 && newheight == 0) break;
            if (newwidth == 0) {
                newwidth = 1;
            }
            if (newheight == 0) {
                newheight = 1;
            }
            Point newOffset = new Point(xoffset, yoffset);
            BufferedImage frame = new BufferedImage(newwidth, newheight, 2);
            Graphics2D g2 = (Graphics2D)((Image)frame).getGraphics();
            g2.drawImage(dragImage, 0, 0, newwidth, newheight, 0, 0, dragImage.getWidth(null), dragImage.getHeight(null), null);
            out.add(new AnimationFrame(frame, newOffset));
            --i;
        }
        out.add(null);
        return out;
    }

    public void updateDragImage(DragSource ds) {
        this.updateDragImage(ds, true);
    }

    public void updateDragImage(DragSource ds, boolean immediate) {
        this.updateDragImage(ds.getListener(), immediate);
    }

    public void updateDragImage(DragListener dl, boolean immediate) {
        Image newImage = dl.getDragImage(null, this.canDrop);
        this.dragOffset = dl.getDragOffset(null, this.canDrop);
        if (this.animate && !immediate) {
            this.animationThread.pause();
            Image currentImage = this.dragImage;
            if (this.animationStack.size() > 0) {
                currentImage = ((AnimationFrame)this.animationStack.peek()).getImage();
            }
            if (currentImage != null) {
                this.setAnimation(this.getDissolveFrames(currentImage, newImage));
            }
            this.animationThread.unpause();
        } else {
            if (this.dragImage != null) {
                this.imageChanged(this.dragImage, this.dragOffset, this.dragX, this.dragY, this.dragImage.getWidth(null), this.dragImage.getWidth(null));
            }
            this.dragImage = newImage;
            if (this.dragImage != null) {
                this.imageChanged(this.dragImage, this.dragOffset, this.dragX, this.dragY, this.dragImage.getWidth(null), this.dragImage.getHeight(null));
            }
        }
    }

    public int getX() {
        return this.dragX;
    }

    public int getY() {
        return this.dragY;
    }

    public Image getDragImage() {
        return this.dragImage;
    }

    public Point getDragOffset() {
        return this.dragOffset;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragContainer(DragContainer dragContainer) {
        this.dragging = false;
    }

    public void registerDragSource(DragSource ds) {
        DragListenerBridge listener = new DragListenerBridge(ds);
        ds.getComponent().addMouseListener(listener);
        ds.getComponent().addMouseMotionListener(listener);
        ds.getComponent().addKeyListener(listener);
        this.dragSources.put(ds, listener);
    }

    public void unregisterDragSource(DragSource ds) {
        DragListenerBridge listener = (DragListenerBridge)this.dragSources.get(ds);
        ds.getComponent().removeMouseListener(listener);
        ds.getComponent().removeMouseMotionListener(listener);
        ds.getComponent().removeKeyListener(listener);
        this.dragSources.remove(ds);
    }

    public void registerScrollSpec(AutoScrollSpec spec) {
        this.scrollSpecs.put(spec.getComponent(), spec);
    }

    public void unregisterScrollSpec(AutoScrollSpec spec) {
        this.scrollSpecs.remove(spec.getComponent());
    }

    public void registerDropTarget(DropTarget dt) {
        LinkedList<DropTarget> v = (LinkedList<DropTarget>)this.dropTargets.get(dt.getComponent());
        if (v == null) {
            v = new LinkedList<DropTarget>();
            this.dropTargets.put(dt.getComponent(), v);
        }
        v.add(dt);
    }

    public void unregisterDropTarget(DropTarget dt) {
        List v = (List)this.dropTargets.get(dt.getComponent());
        if (v != null) {
            v.remove(dt);
        }
    }

    protected class ScrollTimerTask
    implements ActionListener {
        protected ScrollTimerTask() {
        }

        public void actionPerformed(ActionEvent e) {
            DragController.this.updateScroll();
        }
    }

    protected class DragWindow
    extends JWindow {
        private static final long serialVersionUID = 1515703754332563398L;
        Point p = new Point();

        public DragWindow() {
            this.setContentPane(new ContentPanel());
        }

        protected class ContentPanel
        extends JComponent {
            private static final long serialVersionUID = -5830685535355799515L;

            protected ContentPanel() {
            }

            public void paint(Graphics g) {
                g.setColor(Color.white);
                Rectangle r = g.getClipBounds();
                g.fillRect(r.x, r.y, r.width, r.height);
                if (((DragWindow)DragWindow.this).DragController.this.dragImage != null) {
                    int offsetx = 0;
                    int offsety = 0;
                    if (((DragWindow)DragWindow.this).DragController.this.dragOffset != null) {
                        offsetx = (int)((DragWindow)DragWindow.this).DragController.this.dragOffset.getX();
                        offsety = (int)((DragWindow)DragWindow.this).DragController.this.dragOffset.getY();
                    }
                    DragWindow.this.p.x = ((DragWindow)DragWindow.this).DragController.this.dragX - offsetx;
                    DragWindow.this.p.y = ((DragWindow)DragWindow.this).DragController.this.dragY - offsety;
                    DragWindow.this.p = SwingUtilities.convertPoint(((DragWindow)DragWindow.this).DragController.this.currentDragSource, DragWindow.this.p, DragWindow.this);
                    g.drawImage(((DragWindow)DragWindow.this).DragController.this.dragImage, DragWindow.this.p.x, DragWindow.this.p.y, null);
                }
            }
        }
    }

    protected class ResizeRunnable
    implements Runnable {
        int x;
        int y;
        int width;
        int height;

        protected ResizeRunnable() {
        }

        public void setBounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void run() {
            DragController.this.dragWindow.setBounds(this.x, this.y, this.width, this.height);
            if (!DragController.this.dragWindow.isVisible()) {
                DragController.this.dragWindow.setVisible(true);
            }
            DragController.this.dragWindow.toFront();
            ((JComponent)DragController.this.dragWindow.getContentPane()).repaint();
        }
    }

    protected class DragListenerBridge
    extends MouseInputAdapter
    implements KeyListener {
        protected int modifierMask;
        protected Component dragSourceComponent;
        protected DragListener dragListener;
        protected DragFriendlyUI dragSourceUI = null;
        protected Object data;
        protected DragEvent event;
        protected int startPressLocX = -1;
        protected int startPressLocY = -1;
        static /* synthetic */ Class class$0;

        public DragListenerBridge(DragSource source) {
            this(source.getListener(), source.getComponent(), source.getModifierMask());
        }

        public DragListenerBridge(DragListener dragListener, Component dragSourceComponent, int modifierMask) {
            ComponentUI ui;
            this.dragListener = dragListener;
            this.dragSourceComponent = dragSourceComponent;
            this.modifierMask = modifierMask;
            if (dragSourceComponent instanceof JComponent && (ui = SwingUtil.getUI((JComponent)dragSourceComponent)) != null && ui instanceof DragFriendlyUI) {
                this.dragSourceUI = (DragFriendlyUI)((Object)ui);
            }
        }

        protected void doSetCursor(Cursor cursor) {
            DragController.this.dragCursor = cursor;
            this.dragSourceComponent.setCursor(cursor);
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (DragController.this.dragging && this.event != null) {
                this.event = new DragEvent((Component)this.event.getSource(), this.event.getID(), this.event.getWhen(), e.getModifiers(), this.event.getX(), this.event.getY(), this.event.getClickCount(), this.event.isPopupTrigger(), this.event.getData(), this.event.getDragSource());
                this.doSetCursor(this.dragListener.getDragCursor(this.event, DragController.this.canDrop));
            }
        }

        protected String pad(int val) {
            int len = 8;
            String str = Integer.toString(val, 2);
            int padamt = len - str.length();
            int i = 0;
            while (i < padamt) {
                str = " " + str;
                ++i;
            }
            return str;
        }

        public void keyReleased(KeyEvent e) {
            if (DragController.this.dragging && this.event != null) {
                int code = e.getKeyCode();
                int modifier = e.getModifiers();
                if (code == 16) {
                    modifier ^= 1;
                } else if (code == 17) {
                    modifier ^= 2;
                } else if (code == 18) {
                    modifier ^= 8;
                } else if (code == 157) {
                    modifier ^= 4;
                }
                this.event = new DragEvent((Component)this.event.getSource(), this.event.getID(), this.event.getWhen(), modifier, this.event.getX(), this.event.getY(), this.event.getClickCount(), this.event.isPopupTrigger(), this.event.getData(), this.event.getDragSource());
                this.doSetCursor(this.dragListener.getDragCursor(this.event, DragController.this.canDrop));
            }
        }

        public void mouseDragged(MouseEvent e) {
            int dragDist;
            if (DragController.this.dragging) {
                this.myMouseDragged(e);
            } else if (!DragController.this.dragging && (e.getModifiers() & this.modifierMask) == this.modifierMask && this.dragListener.allowDrag(e) && (dragDist = (this.startPressLocX - e.getX()) * (this.startPressLocX - e.getX()) + (this.startPressLocY - e.getY()) * (this.startPressLocY - e.getY())) > DragController.this.dragThreshold * DragController.this.dragThreshold) {
                this.startMouseDrag(e);
            }
        }

        public void startMouseDrag(MouseEvent e) {
            this.data = this.dragListener.getDragData(e);
            DragController.this.dragging = true;
            DragController.this.dragImage = null;
            DragController.this.dragOffset = null;
            DragController.this.lastDraggedOver = null;
            DragController.this.canDrop = false;
            DragController.this.targetWindow = SwingUtilities.getWindowAncestor(this.dragSourceComponent);
        }

        public void mousePressed(MouseEvent e) {
            int dragDist;
            if (this.startPressLocX == -1 && e.getX() > 0) {
                this.startPressLocX = e.getX();
                this.startPressLocY = e.getY();
            } else if (!DragController.this.dragging && (e.getModifiers() & this.modifierMask) == this.modifierMask && this.dragListener.allowDrag(e) && (dragDist = (this.startPressLocX - e.getX()) * (this.startPressLocX - e.getX()) + (this.startPressLocY - e.getY()) * (this.startPressLocY - e.getY())) > DragController.this.dragThreshold * DragController.this.dragThreshold) {
                this.startMouseDrag(e);
            }
        }

        public void myMouseDragged(MouseEvent e) {
            DragController.this.lastMouseLoc.x = e.getX();
            DragController.this.lastMouseLoc.y = e.getY();
            if (DragController.this.dragging) {
                DragController.this.scratchPoint.x = e.getX();
                DragController.this.scratchPoint.y = e.getY();
                Point p = SwingUtilities.convertPoint(this.dragSourceComponent, DragController.this.scratchPoint, DragController.this.targetWindow);
                DragController.this.draggedOver = SwingUtilities.getDeepestComponentAt(DragController.this.targetWindow, p.x, p.y);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.geneontology.swing.DragContainer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                DragController.this.dragContainer = (DragContainer)((Object)SwingUtilities.getAncestorOfClass(clazz, DragController.this.draggedOver));
                DragController.this.currentDragSource = this.dragSourceComponent;
                if (DragController.this.dragImage != null) {
                    DragController.this.imageChanged(DragController.this.dragImage, DragController.this.dragOffset, DragController.this.dragX, DragController.this.dragY, DragController.this.dragImage.getWidth(null), DragController.this.dragImage.getHeight(null));
                }
                this.event = new DragEvent(e, this.data, this.dragSourceComponent);
                if (DragController.this.lastDraggedOver != DragController.this.draggedOver) {
                    Iterator it;
                    if (DragController.this.lastDraggedOver != null && DragController.this.canDrop) {
                        DragController.this.lastDraggedOverTargets = (List)DragController.this.dropTargets.get(DragController.this.lastDraggedOver);
                        if (DragController.this.lastDraggedOverTargets != null) {
                            it = DragController.this.lastDraggedOverTargets.iterator();
                            while (it.hasNext()) {
                                ComponentUI ui;
                                DropTarget oldDropTarget = (DropTarget)it.next();
                                oldDropTarget.getListener().dragExit(this.event);
                                if (!(oldDropTarget.getComponent() instanceof JComponent) || (ui = SwingUtil.getUI((JComponent)oldDropTarget.getComponent())) == null || !(ui instanceof DragFriendlyUI)) continue;
                                ((DragFriendlyUI)((Object)ui)).setIsDragging(false);
                            }
                        }
                        DragController.this.scrollSpec = null;
                        DragController.this.currentDropComponent = null;
                    }
                    if (DragController.this.draggedOver != null) {
                        DragController.this.draggedOverTargets = (List)DragController.this.dropTargets.get(DragController.this.draggedOver);
                        if (DragController.this.draggedOverTargets != null) {
                            it = DragController.this.draggedOverTargets.iterator();
                            while (it.hasNext()) {
                                ComponentUI ui;
                                DropTarget dt = (DropTarget)it.next();
                                DropListener dropListener = dt.getListener();
                                boolean newCanDrop = dropListener.allowDrop(this.event);
                                DragController.this.scrollSpec = (AutoScrollSpec)DragController.this.scrollSpecs.get(dt.getComponent());
                                if (DragController.this.scrollSpec != null) {
                                    DragController.this.scrollTimer.setInitialDelay(DragController.this.scrollSpec.getScrollInterval());
                                    DragController.this.scrollTimer.setDelay(DragController.this.scrollSpec.getScrollInterval());
                                }
                                DragController.this.currentDropComponent = dt.getComponent();
                                if (newCanDrop != DragController.this.canDrop || DragController.this.dragImage == null) {
                                    DragController.this.canDrop = newCanDrop;
                                    DragController.this.dragImage = this.dragListener.getDragImage(this.event, DragController.this.canDrop);
                                    DragController.this.dragOffset = this.dragListener.getDragOffset(this.event, DragController.this.canDrop);
                                    this.doSetCursor(this.dragListener.getDragCursor(this.event, DragController.this.canDrop));
                                }
                                if (!DragController.this.canDrop) continue;
                                dropListener.dragEnter(this.event);
                                if (!(dt.getComponent() instanceof JComponent) || (ui = SwingUtil.getUI((JComponent)dt.getComponent())) == null || !(ui instanceof DragFriendlyUI)) continue;
                                ((DragFriendlyUI)((Object)ui)).setIsDragging(true);
                            }
                        } else {
                            DragController.this.canDrop = false;
                            DragController.this.dragImage = this.dragListener.getDragImage(this.event, DragController.this.canDrop);
                            DragController.this.dragOffset = this.dragListener.getDragOffset(this.event, DragController.this.canDrop);
                            this.doSetCursor(this.dragListener.getDragCursor(this.event, DragController.this.canDrop));
                        }
                    }
                } else if (DragController.this.draggedOver != null && DragController.this.draggedOverTargets != null) {
                    Iterator it = DragController.this.draggedOverTargets.iterator();
                    while (it.hasNext()) {
                        DropTarget dt = (DropTarget)it.next();
                        DropListener dropListener = dt.getListener();
                        boolean newCanDrop = dropListener.allowDrop(this.event);
                        if (newCanDrop != DragController.this.canDrop || DragController.this.dragImage == null) {
                            DragController.this.canDrop = newCanDrop;
                            DragController.this.dragImage = this.dragListener.getDragImage(this.event, DragController.this.canDrop);
                            DragController.this.dragOffset = this.dragListener.getDragOffset(this.event, DragController.this.canDrop);
                            this.doSetCursor(this.dragListener.getDragCursor(this.event, DragController.this.canDrop));
                        }
                        if (!DragController.this.canDrop) continue;
                        dt.getListener().draggedOver(this.event);
                    }
                }
                if (DragController.this.scrollSpec != null && DragController.this.scrollSpec.allowScroll(this.event)) {
                    DragController.this.scrollTimer.start();
                }
                this.dragListener.dragging(this.event);
                if (this.dragSourceUI != null) {
                    this.dragSourceUI.setIsDragging(true);
                }
                DragController.this.dragX = e.getX();
                DragController.this.dragY = e.getY();
                if (DragController.this.dragImage != null) {
                    DragController.this.imageChanged(DragController.this.dragImage, DragController.this.dragOffset, DragController.this.dragX, DragController.this.dragY, DragController.this.dragImage.getWidth(null), DragController.this.dragImage.getHeight(null));
                }
                DragController.this.lastDraggedOver = DragController.this.draggedOver;
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.startPressLocX = -1;
            this.startPressLocY = -1;
            if (DragController.this.dragging) {
                DragController.this.dragging = false;
                if (DragController.this.dragImage != null && DragController.this.animate) {
                    DragController.this.setAnimation(DragController.this.getCollapseFrames(DragController.this.dragImage, DragController.this.dragOffset));
                } else {
                    DragController.this.imageChanged(null, null, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
                }
                this.doSetCursor(null);
                this.event = new DragEvent(e, this.data, this.dragSourceComponent, DragController.this.canDrop ? DragController.this.currentDropComponent : null);
                if (this.dragSourceUI != null) {
                    this.dragSourceUI.setIsDragging(false);
                }
                this.dragListener.dragEnd(this.event);
                if (DragController.this.lastDraggedOver != null && DragController.this.currentDropComponent != null) {
                    List targets = (List)DragController.this.dropTargets.get(DragController.this.currentDropComponent);
                    if (targets != null) {
                        Iterator it = targets.iterator();
                        while (it.hasNext()) {
                            ComponentUI ui;
                            DropTarget dt = (DropTarget)it.next();
                            if (dt.getComponent() instanceof JComponent && (ui = SwingUtil.getUI((JComponent)dt.getComponent())) != null && ui instanceof DragFriendlyUI) {
                                ((DragFriendlyUI)((Object)ui)).setIsDragging(false);
                            }
                            if (DragController.this.canDrop) {
                                dt.getListener().drop(this.event);
                                continue;
                            }
                            dt.getListener().dragExit(this.event);
                        }
                    }
                    if (DragController.this.canDrop) {
                        this.dragListener.dropped(this.event);
                    }
                }
                e.consume();
                this.event = null;
            }
        }
    }

    protected class AnimationFrame {
        protected Image image;
        protected Point offset;

        public AnimationFrame(Image image, Point offset) {
            this.image = image;
            this.offset = offset;
        }

        public Image getImage() {
            return this.image;
        }

        public Point getOffset() {
            return this.offset;
        }
    }

    protected class AnimationThread
    extends Thread {
        protected boolean halt = false;
        protected boolean paused = false;

        protected AnimationThread() {
        }

        public void pause() {
            this.paused = true;
        }

        public void unpause() {
            this.paused = false;
        }

        public int getTimeLeft() {
            return 80 * DragController.this.animationStack.size();
        }

        public void run() {
            while (!this.halt) {
                if (!DragController.this.animationStack.empty() && !this.paused) {
                    AnimationFrame frame = (AnimationFrame)DragController.this.animationStack.pop();
                    if (frame == null) {
                        DragController.this.imageChanged(null, null, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
                    } else {
                        DragController.this.dragImage = frame.getImage();
                        DragController.this.dragOffset = frame.getOffset();
                        DragController.this.imageChanged(frame.getImage(), frame.getOffset(), DragController.this.dragX, DragController.this.dragY, frame.getImage().getWidth(null), frame.getImage().getHeight(null));
                    }
                }
                try {
                    AnimationThread.sleep(80L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

