/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.geneontology.swing.DragController;
import org.geneontology.swing.DragSource;
import org.geneontology.swing.dragtree.DefaultDragTreeCellRenderer;
import org.geneontology.swing.dragtree.DefaultDragTreeListener;
import org.geneontology.swing.event.DragListener;
import org.geneontology.swing.plaf.DragFriendlyTreeUI;

public class DragTree
extends JTree {
    private static final long serialVersionUID = 2646385455826792865L;
    protected int highlightedRow;
    protected int startClickRow;
    protected DragController dragController;
    protected DragSource dragSource;

    public DragTree(DragController dragController) {
        this.init(dragController);
    }

    public DragTree(DragController dragController, TreeNode root) {
        super(root);
        this.init(dragController);
    }

    public DragTree(DragController dragController, TreeModel model) {
        super(model);
        this.init(dragController);
    }

    protected void setDragController(DragController dragController) {
        if (this.dragController != null) {
            this.dragController.unregisterDragSource(this.dragSource);
        }
        this.dragController = dragController;
        if (this.dragController != null) {
            this.dragController.registerDragSource(this.dragSource);
        }
    }

    public void finalize() {
        this.setDragController(null);
    }

    public Cursor getCursor(int modifiers, boolean dropAllowed) {
        return null;
    }

    protected void init(DragController dragController) {
        this.updateUI();
        this.setUI(this.getDefaultUI());
        this.dragSource = new DragSource(this, this.getDefaultDragTreeListener());
        DragTreeMouseHandler listener = new DragTreeMouseHandler(this);
        this.addMouseListener(listener);
        this.setCellRenderer(new DefaultDragTreeCellRenderer());
        this.setDragController(dragController);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.highlightedRow = -1;
        this.startClickRow = -1;
        this.setScrollsOnExpand(false);
    }

    public void setArrowOffset(int arrowOffset) {
        if (this.getUI() instanceof DragFriendlyTreeUI) {
            DragFriendlyTreeUI ui = (DragFriendlyTreeUI)this.getUI();
            ui.setTriangleOffset(arrowOffset);
        }
    }

    public void setArrowWidth(int arrowWidth) {
        if (this.getUI() instanceof DragFriendlyTreeUI) {
            DragFriendlyTreeUI ui = (DragFriendlyTreeUI)this.getUI();
            ui.setTriangleXSize(arrowWidth);
        }
    }

    public void setArrowHeight(int arrowHeight) {
        if (this.getUI() instanceof DragFriendlyTreeUI) {
            DragFriendlyTreeUI ui = (DragFriendlyTreeUI)this.getUI();
            ui.setTriangleYSize(arrowHeight);
        }
    }

    public void setDrawArrowhead(boolean drawArrowhead) {
        if (this.getUI() instanceof DragFriendlyTreeUI) {
            DragFriendlyTreeUI ui = (DragFriendlyTreeUI)this.getUI();
            ui.setDrawArrowhead(drawArrowhead);
        }
    }

    protected DragFriendlyTreeUI getDefaultUI() {
        return new DragFriendlyTreeUI();
    }

    protected DragListener getDefaultDragTreeListener() {
        return new DefaultDragTreeListener(this);
    }

    public void repaintPath(TreePath path) {
        Rectangle bounds;
        if (path != null && (bounds = this.getPathBounds(path)) != null) {
            this.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    public void repaintRow(int row) {
        Rectangle bounds;
        if (row != -1 && (bounds = this.getRowBounds(row)) != null) {
            this.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    public int getHighlightRow() {
        return this.highlightedRow;
    }

    public void highlightDropTarget(int row) {
        int oldHighlightedRow = this.highlightedRow;
        this.highlightedRow = row;
        this.repaintRow(this.highlightedRow);
        this.repaintRow(oldHighlightedRow);
    }

    public void indicateClickTarget(int row) {
        int oldStartClickRow = this.startClickRow;
        this.startClickRow = row;
        this.repaintRow(this.startClickRow);
        this.repaintRow(oldStartClickRow);
    }

    public int getClickTarget() {
        return this.startClickRow;
    }

    public class DragTreeMouseHandler
    extends MouseAdapter {
        DragTree dragTree;

        public DragTreeMouseHandler(DragTree in) {
            this.dragTree = in;
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) || SwingUtilities.isRightMouseButton(e)) {
                int row = this.dragTree.getRowForLocation(e.getX(), e.getY());
                this.dragTree.indicateClickTarget(row);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            this.dragTree.indicateClickTarget(-1);
            this.dragTree.highlightDropTarget(-1);
        }
    }
}

