/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing.draglist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.geneontology.swing.DragList;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DragListener;

public class DefaultDragListListener
implements DragListener {
    protected JList list;
    protected Image dragEnabledImage;
    protected Image dragDisabledImage;
    protected CellRendererPane rendererPane = new CellRendererPane();
    protected static final Point offset = new Point(0, 0);

    public DefaultDragListListener(JList list) {
        this.list = list;
        this.rendererPane.setBackground(Color.red);
        list.add(this.rendererPane);
    }

    public Point getDragOffset(DragEvent e, boolean allow) {
        return offset;
    }

    public boolean allowDrag(MouseEvent e) {
        int[] rows = this.list.getSelectedIndices();
        return rows != null && rows.length > 0;
    }

    protected void buildImageCache() {
        this.dragEnabledImage = this.getDragImage(this.list.getSelectedIndices());
        this.dragDisabledImage = new BufferedImage(this.dragEnabledImage.getWidth(null), this.dragEnabledImage.getHeight(null), 2);
        Graphics imageGraphics = this.dragDisabledImage.getGraphics();
        imageGraphics.drawImage(this.dragEnabledImage, 0, 0, null);
        imageGraphics.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        imageGraphics.fillRect(0, 0, this.dragDisabledImage.getWidth(null), this.dragDisabledImage.getHeight(null));
    }

    public Cursor getDragCursor(DragEvent e, boolean dropAllowed) {
        if (this.list instanceof DragList) {
            return ((DragList)this.list).getCursor(e.getModifiers(), dropAllowed);
        }
        return null;
    }

    protected void clearImageCache() {
        this.dragEnabledImage = null;
        this.dragDisabledImage = null;
    }

    protected BufferedImage getDragImage(int[] row) {
        int highlightRow = -1;
        int clickTargetRow = -1;
        ListCellRenderer rend = this.list.getCellRenderer();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < row.length) {
            Component rendComponent = rend.getListCellRendererComponent(this.list, this.list.getModel().getElementAt(row[i]), row[i], false, false);
            this.rendererPane.add(rendComponent);
            rendComponent.validate();
            Dimension dim = rendComponent.getPreferredSize();
            rendComponent.setVisible(true);
            width = (int)Math.max((double)width, dim.getWidth());
            height = (int)((double)height + dim.getHeight());
            ++i;
        }
        BufferedImage out = new BufferedImage(width, height, 2);
        Graphics2D graphics = out.createGraphics();
        graphics.setColor(new Color(0, 0, 255, 80));
        graphics.fillRect(0, 0, width, height);
        graphics.setClip(0, 0, width, height);
        int i2 = 0;
        while (i2 < row.length) {
            Component rendComponent = rend.getListCellRendererComponent(this.list, this.list.getModel().getElementAt(row[i2]), row[i2], false, false);
            boolean isOpaque = true;
            if (rendComponent instanceof JComponent) {
                isOpaque = ((JComponent)rendComponent).isOpaque();
                ((JComponent)rendComponent).setOpaque(false);
            }
            Dimension dim = rendComponent.getPreferredSize();
            this.rendererPane.paintComponent(graphics, rendComponent, this.list, 0, i2 * dim.height, width, dim.height, true);
            if (rendComponent instanceof JComponent) {
                ((JComponent)rendComponent).setOpaque(isOpaque);
            }
            if (i2 != row.length - 1) {
                graphics.setColor(new Color(0, 0, 255, 180));
                graphics.drawLine(0, (int)(dim.getHeight() * (double)(i2 + 1)), width, (int)(dim.getHeight() * (double)(i2 + 1)));
            }
            ++i2;
        }
        this.rendererPane.removeAll();
        return out;
    }

    public Image getDragImage(DragEvent e, boolean dropAllowed) {
        if (this.dragEnabledImage == null || this.dragDisabledImage == null) {
            this.buildImageCache();
        }
        if (dropAllowed) {
            return this.dragEnabledImage;
        }
        return this.dragDisabledImage;
    }

    public Object getDragData(MouseEvent e) {
        return this.list.getSelectedValues();
    }

    public void dragging(DragEvent e) {
    }

    public void dragEnd(DragEvent e) {
        this.clearImageCache();
    }

    public void dropped(DragEvent e) {
        this.clearImageCache();
    }
}

