/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing.dragtree;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.geneontology.swing.DragTree;

public class DefaultDragTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -5687904756195401889L;
    Color defaultSelectionColor;
    Color highlightColor;
    Color clickBorderColor;

    public DefaultDragTreeCellRenderer() {
        this.setOpaque(false);
        this.setClosedIcon(null);
        this.setOpenIcon(null);
        this.setLeafIcon(null);
        this.defaultSelectionColor = this.getBackgroundSelectionColor();
        this.highlightColor = Color.yellow;
        this.clickBorderColor = this.defaultSelectionColor;
    }

    public void setHighlightColor(Color in) {
        this.highlightColor = in;
    }

    public void setClickBorderColor(Color in) {
        this.clickBorderColor = in;
    }

    protected void doObjectRender(Component out, TreePath path, Object in) {
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DragTree dt = (DragTree)tree;
        TreePath path = dt.getPathForRow(row);
        boolean pathIncludesValue = false;
        if (row == dt.getHighlightRow()) {
            this.setBackground(this.highlightColor);
            this.setBackgroundNonSelectionColor(this.highlightColor);
            this.setBackgroundSelectionColor(this.highlightColor);
        } else {
            this.setBackground(null);
            this.setBackgroundNonSelectionColor(null);
            this.setBackgroundSelectionColor(this.defaultSelectionColor);
        }
        if (row == dt.getClickTarget()) {
            this.setBorder(new LineBorder(this.clickBorderColor));
        } else {
            this.setBorder(null);
        }
        DefaultTreeCellRenderer out = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        out.setOpaque(false);
        out.setBackground(null);
        this.doObjectRender(out, path, value);
        return out;
    }
}

