/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.geneontology.util.CollectionUtil;

public abstract class AbstractCachedIterator
implements Iterator {
    protected Iterator iterator;
    protected Collection cache;

    public void setIterator(Iterator iterator) {
        this.iterator = iterator;
        this.cache = null;
    }

    protected void doCache() {
        this.cache = CollectionUtil.initialize(new LinkedList(), this.iterator);
        this.iterator = this.cache.iterator();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        return this.iterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException("CachedIterators are read-only");
    }
}

