/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.util;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.geneontology.util.Subset;
import org.geneontology.util.Subsetable;
import org.geneontology.util.VectorFilter;

public class HashSubsetable
extends LinkedHashSet
implements Subsetable,
Serializable {
    private static final long serialVersionUID = -999036291683126314L;
    protected HashSet subsets = new HashSet();

    public Set getUncachedSubset(VectorFilter filter) {
        Subset out = new Subset(filter, this, false);
        this.subsets.add(out);
        return out;
    }

    public Set getSubset(VectorFilter filter) {
        Subset out = new Subset(filter, this, true);
        this.subsets.add(out);
        return out;
    }

    public boolean removeSubset(Set set) {
        return this.subsets.remove(set);
    }

    public void clear() {
        super.clear();
        Iterator it = this.subsets.iterator();
        while (it.hasNext()) {
            Subset set = (Subset)it.next();
            set.cacheSize(0);
        }
    }

    public boolean add(Object o) {
        boolean add = super.add(o);
        if (add) {
            Iterator it = this.subsets.iterator();
            while (it.hasNext()) {
                Subset set = (Subset)it.next();
                set.updateAdd(o);
            }
        }
        return add;
    }

    public boolean remove(Object o) {
        boolean remove = super.remove(o);
        if (remove) {
            Iterator it = this.subsets.iterator();
            while (it.hasNext()) {
                Subset set = (Subset)it.next();
                set.updateRemove(o);
            }
        }
        return remove;
    }

    public void markForRecategorize(Object o) {
        Iterator it = this.subsets.iterator();
        while (it.hasNext()) {
            Subset set = (Subset)it.next();
            set.markForRecategorize(o);
        }
    }

    public void recategorize(Object o) {
        Iterator it = this.subsets.iterator();
        while (it.hasNext()) {
            Subset set = (Subset)it.next();
            set.recategorize(o);
        }
    }

    public void recache(Set s) {
        if (this.subsets.contains(s)) {
            ((Subset)s).cacheSize();
        }
    }

    public void recache() {
        Iterator it = this.subsets.iterator();
        while (it.hasNext()) {
            Subset set = (Subset)it.next();
            set.cacheSize();
        }
    }
}

