/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.util;

import java.util.LinkedList;
import java.util.List;
import org.geneontology.util.CycleState;

public class StateCycler {
    protected List states = new LinkedList();
    protected int currentIndex = 0;
    protected boolean tryEveryState = false;
    protected String desc;

    public StateCycler() {
    }

    public StateCycler(String desc) {
        this.setDesc(desc);
    }

    public void addState(CycleState state) {
        this.states.add(state);
    }

    public void addState(CycleState state, int index) {
        this.states.add(index, state);
    }

    public void removeState(CycleState state) {
        this.states.remove(state);
    }

    public CycleState getCurrentState() {
        return (CycleState)this.states.get(this.currentIndex);
    }

    public void enforceCurrentState() {
        this.getCurrentState().apply();
    }

    public void cycleStates() {
        int updates = 0;
        CycleState currentState = this.getCurrentState();
        if (!currentState.isActive()) {
            this.enforceCurrentState();
            return;
        }
        do {
            this.currentIndex = (this.currentIndex + 1) % this.states.size();
            ++updates;
            currentState = this.getCurrentState();
            if (!this.tryEveryState && !currentState.alwaysActivate() && currentState.isActive()) continue;
            this.enforceCurrentState();
            return;
        } while (updates < this.states.size());
    }

    public boolean getTryEveryState() {
        return this.tryEveryState;
    }

    public void setTryEveryState(boolean tryEveryState) {
        this.tryEveryState = tryEveryState;
    }

    public List getStates() {
        return this.states;
    }

    public void setStates(List states) {
        this.states = states;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

