/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.util;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.geneontology.util.CollectionUtil;
import org.geneontology.util.ComparableComparator;
import org.geneontology.util.EqualityComparator;
import org.geneontology.util.EqualsEqualityComparator;
import org.geneontology.util.ObjectUtil;
import org.geneontology.util.Pair;
import org.geneontology.util.VectorCondenser;
import org.geneontology.util.VectorFilter;
import org.geneontology.util.VectorTransformer;

public class VectorUtil {
    private static final ComparableComparator comparableComparator = new ComparableComparator();
    private static final EqualsEqualityComparator equalityComparator = new EqualsEqualityComparator();

    private VectorUtil() {
    }

    public static Vector mergeVectors(Vector a, Vector b) {
        int i = 0;
        while (i < b.size()) {
            if (!a.contains(b.elementAt(i))) {
                a.addElement(b.elementAt(i));
            }
            ++i;
        }
        return a;
    }

    public static Vector condense(Vector vector, VectorCondenser condenser) {
        int oldCount = 0;
        while ((oldCount = vector.size()) != (vector = VectorUtil.doCondense(vector, condenser)).size()) {
        }
        return vector;
    }

    private static Vector doCondense(Vector vector, VectorCondenser condenser) {
        vector = (Vector)vector.clone();
        Vector out = new Vector();
        int lastIndex = 0;
        while (lastIndex < vector.size()) {
            Object item = vector.elementAt(lastIndex);
            if (lastIndex + 1 >= vector.size()) {
                out.addElement(item);
                break;
            }
            boolean condensed = false;
            int i = lastIndex + 1;
            while (i < vector.size()) {
                Object item2 = vector.elementAt(i);
                Pair pair = condenser.condense(item, item2);
                if (pair != null && (pair.getA() != null || pair.getB() != null)) {
                    condensed = true;
                    if (pair.getB() == VectorCondenser.REMOVE_OP) {
                        vector.removeElementAt(i);
                    } else if (pair.getB() != null) {
                        vector.setElementAt(pair.getB(), i);
                    }
                    if (pair.getA() == VectorCondenser.REMOVE_OP) {
                        vector.removeElementAt(lastIndex);
                        break;
                    }
                    if (pair.getA() == null) break;
                    vector.setElementAt(pair.getA(), lastIndex);
                    break;
                }
                ++i;
            }
            if (condensed) continue;
            out.addElement(item);
            ++lastIndex;
        }
        return out;
    }

    public static Vector trueClone(Vector values) {
        Vector<Object> out = new Vector<Object>(values.size());
        int i = 0;
        while (i < values.size()) {
            out.addElement(ObjectUtil.cloneObject(values.elementAt(i)));
            ++i;
        }
        return out;
    }

    public static List trueClone(List values) {
        Vector<Object> out = new Vector<Object>(values.size());
        int i = 0;
        while (i < values.size()) {
            out.add(ObjectUtil.cloneObject(values.get(i)));
            ++i;
        }
        return out;
    }

    public static boolean hasSameContents(Vector a, Vector b) {
        return VectorUtil.hasSameContents(a, b, equalityComparator);
    }

    public static boolean hasSameContents(Vector a, Vector b, EqualityComparator cmp) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator it = a.iterator();
        while (it.hasNext()) {
            if (VectorUtil.contains(b, it.next(), cmp)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Vector vector, Object o, EqualityComparator cmp) {
        Iterator it = vector.iterator();
        while (it.hasNext()) {
            if (!cmp.equals(it.next(), o)) continue;
            return true;
        }
        return false;
    }

    public static Vector transform(VectorTransformer transformer, Vector values) {
        return VectorUtil.filter(null, transformer, values);
    }

    public static Vector transform(VectorTransformer transformer, Enumeration values) {
        return VectorUtil.filter(null, transformer, values);
    }

    public static Vector filter(VectorFilter filter, Vector values) {
        return VectorUtil.filter(filter, null, values);
    }

    public static Vector filter(VectorFilter filter, Enumeration values) {
        return VectorUtil.filter(filter, null, values);
    }

    public static Vector filter(VectorFilter filter, VectorTransformer transformer, Vector values) {
        Vector out = new Vector(values.size());
        int i = 0;
        while (i < values.size()) {
            Object o = values.get(i);
            if (filter == null || filter.satisfies(o)) {
                if (transformer != null) {
                    o = transformer.transform(o);
                }
                out.addElement(o);
            }
            ++i;
        }
        out.trimToSize();
        return out;
    }

    public static Vector filter(VectorFilter filter, VectorTransformer transformer, Enumeration values) {
        Vector out = new Vector();
        while (values.hasMoreElements()) {
            Object o = values.nextElement();
            if (filter != null && !filter.satisfies(o)) continue;
            if (transformer != null) {
                o = transformer.transform(o);
            }
            out.addElement(o);
        }
        out.trimToSize();
        return out;
    }

    public static Vector getVector(Enumeration e) {
        Vector out = new Vector();
        while (e.hasMoreElements()) {
            out.addElement(e.nextElement());
        }
        return out;
    }

    public static boolean insertSorted(List v, Comparator c, Object o, boolean duplicates) {
        return CollectionUtil.insertSorted(v, c, o, duplicates);
    }

    public static boolean insertSorted(List v, Comparator c, Object o) {
        return CollectionUtil.insertSorted(v, c, o);
    }

    public static void insertSorted(List v, Object o) {
        CollectionUtil.insertSorted(v, o);
    }
}

