/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.client.gui;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.FileSetConverter;
import psidev.psi.mi.tab.expansion.ExpansionStrategy;
import psidev.psi.mi.tab.expansion.MatrixBinaryExpansion;
import psidev.psi.mi.tab.expansion.SpokeExpansion;
import psidev.psi.mi.tab.processor.PostProcessorStrategy;

public class FilesProcessor {
    public static final Log log = LogFactory.getLog(FilesProcessor.class);

    public void process(JFrame frame, File[] files, ExpansionStrategy expansionStrategy, PostProcessorStrategy postProcessorStrategy, boolean aggregateFiles) {
        ArrayList<File> inputFiles = new ArrayList<File>(files.length);
        ArrayList<File> unselectedFiles = new ArrayList<File>(files.length);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.getName().endsWith(".xml")) {
                inputFiles.add(file);
                continue;
            }
            unselectedFiles.add(file);
        }
        if (!unselectedFiles.isEmpty()) {
            String message = "Some of the file your have dropped are not XML files:";
            for (File unselectedFile : unselectedFiles) {
                message = message + "\n- " + unselectedFile.getName();
            }
            message = message + "\nPlease try again.";
            JOptionPane.showMessageDialog(frame, message, "Invalid file(s)", 0);
        }
        if (inputFiles.isEmpty()) {
            String message = "No input file to be processed, please drop one or manu XML files.";
            JOptionPane.showMessageDialog(frame, message, "No input file.", 2);
        } else {
            FileSetConverter fsc = new FileSetConverter();
            fsc.setExpansionStrategy(expansionStrategy);
            fsc.setPostProcessor(postProcessorStrategy);
            if (aggregateFiles) {
                log.debug((Object)"Aggregate conversion starts...");
                File output = this.buildOutputFile((File)inputFiles.get(0), aggregateFiles, expansionStrategy);
                try {
                    long start = System.currentTimeMillis();
                    fsc.convert(output, inputFiles);
                    long stop = System.currentTimeMillis();
                    log.debug((Object)("conversion tool: " + (stop - start) + "ms"));
                    String message = "Your file" + (files.length > 1 ? "s were" : " was") + " converted succesfully." + "\nLocation: " + output.getAbsolutePath();
                    JOptionPane.showMessageDialog(frame, message, "Conversion complete", 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String message = e.getMessage();
                    JOptionPane.showMessageDialog(frame, message, "Error - " + e.getClass().getSimpleName(), 0);
                }
            } else {
                log.debug((Object)"Non aggregate conversion starts...");
                boolean completed = false;
                int ok = 0;
                int failed = 0;
                for (File inputFile : inputFiles) {
                    File output = this.buildOutputFile(inputFile, aggregateFiles, expansionStrategy);
                    try {
                        long start = System.currentTimeMillis();
                        ArrayList<File> singleFile = new ArrayList<File>(1);
                        singleFile.add(inputFile);
                        fsc.convert(output, singleFile);
                        long stop = System.currentTimeMillis();
                        log.debug((Object)("conversion tool: " + (stop - start) + "ms"));
                        ++ok;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        String message = e.getMessage();
                        JOptionPane.showMessageDialog(frame, message, "Error - " + e.getClass().getSimpleName(), 0);
                        ++failed;
                    }
                }
                String message = ok + " file" + (ok > 1 ? "s were" : " was") + " converted succesfully.";
                if (failed > 0) {
                    message = message + "\n" + failed + " failed to be converted.";
                }
                JOptionPane.showMessageDialog(frame, message, "Conversion complete", 1);
            }
        }
    }

    private File buildOutputFile(File file, boolean aggregateName, ExpansionStrategy expansionStrategy) {
        String baseFilename;
        if (aggregateName) {
            baseFilename = file.getParentFile().getAbsolutePath();
            baseFilename = baseFilename + File.separator + file.getParentFile().getName();
        } else {
            baseFilename = file.getAbsolutePath().replaceAll(".xml", "");
        }
        if (expansionStrategy != null) {
            if (expansionStrategy instanceof SpokeExpansion) {
                baseFilename = baseFilename + ".spoke";
            } else if (expansionStrategy instanceof MatrixBinaryExpansion) {
                baseFilename = baseFilename + ".matrix";
            }
        }
        File output = new File(baseFilename + ".xls");
        int i = 1;
        while (output.exists()) {
            log.warn((Object)(output.getName() + " exists, change filename."));
            output = new File(baseFilename + ".v" + ++i + ".xls");
        }
        return output;
    }
}

