/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.xml2tab.TabConvertionException;
import psidev.psi.mi.tab.converter.xml2tab.XrefUtils;
import psidev.psi.mi.tab.model.SimpleCvType;
import psidev.psi.mi.xml.model.CvType;
import psidev.psi.mi.xml.model.DbReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CvConverter {
    public static final Log log = LogFactory.getLog(CvConverter.class);
    public static final String PSI_MI = "psi-mi";
    public static final String PSI_MI_REF = "MI:0488";

    public <CV extends SimpleCvType> CV toMitab(CvType cv, Class<CV> clazz) throws TabConvertionException {
        Collection<DbReference> refs;
        SimpleCvType myCv = null;
        if (cv == null) {
            throw new IllegalArgumentException("You must give a non null JAXB OpenCvType.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("You must give a non null implementation class of model.CvType.");
        }
        String name = null;
        String id = null;
        if (cv.hasNames()) {
            name = cv.getNames().getShortLabel();
        }
        if (!(refs = XrefUtils.searchByDatabase(cv.getXref(), PSI_MI, PSI_MI_REF)).isEmpty()) {
            Iterator<DbReference> iterator = refs.iterator();
            id = iterator.next().getId();
            if (iterator.hasNext()) {
                log.warn((Object)(cv + " has " + refs.size() + " references to PSI-MI to choose from, picked the first one."));
                log.warn((Object)("1: " + id));
                int i = 1;
                while (iterator.hasNext()) {
                    DbReference dbReference = iterator.next();
                    log.warn((Object)(++i + ": " + dbReference.getId()));
                }
            }
        }
        if (name != null) {
            try {
                Constructor<CV> constructor = clazz.getConstructor(String.class, String.class);
                myCv = (SimpleCvType)constructor.newInstance(name, id);
            }
            catch (Exception e) {
                throw new TabConvertionException("An exception was thrown while instanciating an model.CvType via reflection. Nested Exception attached", e);
            }
        }
        return (CV)myCv;
    }

    public <CV extends SimpleCvType, T extends CvType> CvType fromMitab(CV tabCv, Class<T> clazz) {
        throw new UnsupportedOperationException();
    }
}

