/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.expansion;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.expansion.BinaryExpansionStrategy;
import psidev.psi.mi.xml.model.ExperimentalRole;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Participant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixBinaryExpansion
extends BinaryExpansionStrategy {
    public static final Log log = LogFactory.getLog(MatrixBinaryExpansion.class);

    @Override
    public Collection<Interaction> expand(Interaction interaction) {
        ArrayList<Interaction> interactions = new ArrayList<Interaction>();
        if (this.isBinary(interaction)) {
            log.debug((Object)("interaction " + interaction.getId() + "/" + interaction.getImexId() + " was binary, no further processing involved."));
            interactions.add(interaction);
        } else {
            Participant[] participants = interaction.getParticipants().toArray(new Participant[0]);
            log.debug((Object)(participants.length + " participant(s) found."));
            for (int i = 0; i < participants.length; ++i) {
                Participant p1 = participants[i];
                for (int j = i + 1; j < participants.length; ++j) {
                    Participant p2 = participants[j];
                    if (log.isDebugEnabled()) {
                        String p1Str = this.displayParticipant(p1);
                        String p2Str = this.displayParticipant(p2);
                        log.debug((Object)("Build new binary interaction [" + p1Str + "," + p2Str + "]"));
                    }
                    Interaction newInteraction = this.buildInteraction(interaction, p1, p2);
                    interactions.add(newInteraction);
                }
            }
            log.debug((Object)("After expansion: " + interactions.size() + " binary interaction(s) were generated."));
        }
        return interactions;
    }

    private String displayParticipant(Participant p) {
        String role = "";
        for (ExperimentalRole aRole : p.getExperimentalRoles()) {
            if (role.length() > 0) {
                role = role + "&";
            }
            if (aRole.hasNames()) {
                role = role + aRole.getNames().getShortLabel();
                continue;
            }
            role = role + "?";
        }
        String interactor = p.getInteractor().getNames().getShortLabel();
        return interactor + ":" + role;
    }
}

