/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.db;

import com.mysql.jdbc.Driver;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;
import org.genemania.dw.util.DefParams;
import org.genemania.dw.util.GenUtil;

public class DBUtil {
    public static final String LOAD = "LOAD";
    private static final String JDBC_MYSQL = "jdbc:mysql://";
    private static final String DBUSER = "user";
    private static final String DBPASSWD = "password";
    private static PrintWriter log = GenUtil.getDefaultLog();
    private static String DBServer;
    private static Connection con;
    private static Properties conProps;

    private DBUtil() {
    }

    private static void registerDriver() {
        try {
            DriverManager.registerDriver((java.sql.Driver)new Driver());
            DBServer = DefParams.getDefaultProp("DefDBServer");
            conProps = new Properties();
            conProps.setProperty(DBUSER, DefParams.getDefaultProp("DefDBUser"));
            conProps.setProperty(DBPASSWD, DefParams.getDefaultProp("DefDBPasswd"));
            conProps.setProperty("sendStringParametersAsUnicode", "false");
        }
        catch (Exception e) {
            System.err.println("Unable to register DB Driver.");
            e.printStackTrace();
        }
    }

    public static Connection getConnection() throws SQLException {
        if (log == null) {
            log = GenUtil.getDefaultLog();
        }
        if (con == null || con.isClosed()) {
            try {
                if (DBServer == null) {
                    DBServer = InetAddress.getLocalHost().getHostAddress();
                }
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                e.printStackTrace(log);
                DBServer = DefParams.getDefaultProp("DefDBServer");
            }
            con = DriverManager.getConnection(JDBC_MYSQL + DBServer, conProps);
            for (SQLWarning warn = con.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                log.println("SQL Warning:");
                log.println("State  : " + warn.getSQLState());
                log.println("Message: " + warn.getMessage());
                log.println("Error  : " + warn.getErrorCode());
            }
            con.setAutoCommit(false);
        }
        return con;
    }

    static {
        DBUtil.registerDriver();
    }
}

